/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.pearlriver.utils;

import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;

public class DtoUtils {
    public static <T> T from(Object source, Class<T> clazz) {
        T result;
        if (null == source) {
            return null;
        }
        try {
            result = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("newInstance ERROR, clz: " + clazz, e);
        }
        return DtoUtils.from(source, result);
    }

    public static <T> T from(Object source, T result) {
        if (null == source || null == result) {
            return result;
        }
        try {
            org.springframework.beans.BeanUtils.copyProperties((Object)source, result);
        }
        catch (Exception e) {
            throw new RuntimeException("copyProperties ERROR, obj: " + source.getClass() + " clz: " + result.getClass(), e);
        }
        return result;
    }

    public static <T> List<T> fromList(Collection<? extends Object> list, Class<T> clazz) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        if (null != list) {
            for (Object object : list) {
                result.add(DtoUtils.from(object, clazz));
            }
        }
        return result;
    }

    public static <T> T populate(Map<String, Object> source, Class<T> clazz) {
        T result;
        if (null == source) {
            return null;
        }
        try {
            result = clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("newInstance ERROR, clz: " + clazz, e);
        }
        return DtoUtils.populate(source, result);
    }

    public static <T> T populate(Map<String, Object> source, T result) {
        if (null == source || null == result) {
            return result;
        }
        try {
            BeanUtils.populate(result, source);
        }
        catch (Exception e) {
            throw new RuntimeException("populate ERROR, clz: " + result.getClass(), e);
        }
        return result;
    }

    public static <T> PageInfo<T> fromPage(PageInfo source, Class<T> clazz) {
        if (null == source) {
            return null;
        }
        PageInfo result = (PageInfo)DtoUtils.from((Object)source, PageInfo.class);
        List<T> list = DtoUtils.fromList(result.getList(), clazz);
        result.setList(list);
        return result;
    }
}

