/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.pearlriver.utils;

import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.util.JacksonUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.util.CollectionUtils;

public class StringFormatUtil {
    private static Logger logger = LoggerFactory.getLogger(StringFormatUtil.class);

    public static String format(String str, Map<String, Object> map) {
        if (!org.springframework.util.StringUtils.isEmpty((Object)str) && !CollectionUtils.isEmpty(map)) {
            Matcher m = Pattern.compile("#\\{(.*?)\\}").matcher(str);
            while (m.find()) {
                if (org.springframework.util.StringUtils.isEmpty((Object)map.get(m.group(1)))) {
                    str = str.replace(m.group(), "");
                    continue;
                }
                str = str.replace(m.group(), map.get(m.group(1)).toString());
            }
        }
        return str;
    }

    public static String format(String str) {
        return str.replace("#{", "").replace("}", "");
    }

    public static Map<String, Object> getParams(String str, Map<String, Object> map) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)str) && null != map && !map.isEmpty()) {
            Matcher m = Pattern.compile("#\\{(.*?)\\}").matcher(str);
            while (m.find()) {
                paramsMap.put(m.group(1), map.get(m.group(1)));
            }
        }
        return paramsMap;
    }

    public static Map<String, String> changeExtrasParam(String extrasparam) {
        if (StringUtils.isNotEmpty((CharSequence)extrasparam)) {
            Map tempMap = (Map)JacksonUtil.readValue((String)extrasparam, Map.class);
            HashMap<String, String> extraMap = new HashMap<String, String>();
            for (Map.Entry entry : tempMap.entrySet()) {
                extraMap.put((String)entry.getKey(), entry.getValue().toString());
            }
            return extraMap;
        }
        return null;
    }

    public static String getContentByHold(String content, Map<String, String> mapValue) {
        if (StringUtils.isNotBlank((CharSequence)content) && mapValue != null && mapValue.size() > 0) {
            for (Map.Entry<String, String> entry : mapValue.entrySet()) {
                String key = entry.getKey();
                key = key.replaceAll("\\{", "\\\\{").replaceAll("\\}", "\\\\}");
                content = content.replaceAll(key, entry.getValue());
            }
        }
        content = content.replaceAll("\\{", "\u3010");
        content = content.replaceAll("}", "\u3011");
        content = content.replaceAll("\\$", "");
        return content;
    }

    public static boolean isPhoneCode(String phone) {
        logger.info("\u624b\u673a\u53f7\uff1a" + phone);
        if (StringUtils.isBlank((CharSequence)phone)) {
            logger.info("\u624b\u673a\u53f7StringUtils.isBlank\uff1a" + phone);
            return false;
        }
        phone = phone.trim();
        String regex = "^1([0-9])\\d{9}$";
        logger.info(" \u957f\u5ea6:" + phone.length());
        for (int i = 0; i < phone.length(); ++i) {
            logger.info("phone\u5b57\u7b26\uff1a" + phone.substring(i, i + 1));
        }
        return Pattern.matches(regex, phone);
    }

    public static void main(String[] args) {
        System.out.println(StringFormatUtil.isPhoneCode(" 13570999662".trim()));
    }
}

