/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.pearlriver.utils.poi;

import com.dtyunxi.pearlriver.utils.poi.ExcelType;
import com.dtyunxi.pearlriver.utils.poi.ExcelWSheetProcessor;
import com.dtyunxi.pearlriver.utils.poi.annotation.ColumnData;
import com.dtyunxi.pearlriver.utils.poi.annotation.RowData;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class ExcelWriteUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExcelWriteUtils.class);

    public static void write(ExcelType excelType, OutputStream outputStream, ExcelWSheetProcessor<?> ... sheetProcessors) {
        SXSSFWorkbook workbook = ExcelWriteUtils.createWorkBook();
        try {
            for (ExcelWSheetProcessor<?> sheetProcessor : sheetProcessors) {
                String sheetName = sheetProcessor.getSheetName();
                Integer sheetIndex = sheetProcessor.getSheetIndex();
                SXSSFSheet sheet = ExcelWriteUtils.createSheet(workbook, sheetName, sheetIndex);
                sheetProcessor.setSheet(sheet);
                Class clazz = (Class)((ParameterizedTypeImpl)sheetProcessor.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
                ExcelWriteUtils.createTableHead((Sheet)sheet, clazz);
                int writeRowIndex = sheetProcessor.getRowStartIndex();
                List<?> dataList = sheetProcessor.getDataList();
                Map<String, CellStyle> cellStyles = ExcelWriteUtils.getCellStyle((Workbook)workbook, clazz);
                if (dataList == null || dataList.size() <= 0) continue;
                int pageSize = sheetProcessor.getPageSize() < 1000 ? 1000 : sheetProcessor.getPageSize();
                int size = dataList.size();
                int part = size % pageSize == 0 ? size / pageSize : size / pageSize + 1;
                logger.info("\u5171\u6709 \uff1a{}\u6761\u6570\u636e\uff0c\u5206\u4e3a \uff1a{}\u6279", (Object)size, (Object)part);
                for (int i = 0; i < part; ++i) {
                    List<Object> listPage = new ArrayList();
                    if (i == part - 1) {
                        writeRowIndex = ExcelWriteUtils.write(sheetProcessor, dataList, clazz, cellStyles, writeRowIndex);
                        dataList.clear();
                        continue;
                    }
                    listPage = dataList.subList(0, pageSize);
                    writeRowIndex = ExcelWriteUtils.write(sheetProcessor, listPage, clazz, cellStyles, writeRowIndex);
                    dataList.subList(0, pageSize).clear();
                }
            }
            workbook.write(outputStream);
            logger.info("\u751f\u6210Excle\u6587\u4ef6\u6210\u529f~");
        }
        catch (Exception e) {
            logger.error("\u751f\u6210Excle\u6587\u4ef6\u65f6\u5f02\u5e38~", (Throwable)e);
            throw new RuntimeException("\u751f\u6210Excle\u6587\u4ef6\u65f6\u5f02\u5e38~", e);
        }
        finally {
            ExcelWriteUtils.close(outputStream);
            workbook.dispose();
        }
    }

    private static SXSSFSheet createSheet(SXSSFWorkbook workbook, String sheetName, Integer sheetIndex) {
        SXSSFSheet sheet;
        if (sheetName != null) {
            sheet = workbook.createSheet(sheetName);
            if (sheetIndex != null) {
                workbook.setSheetOrder(sheetName, sheetIndex.intValue());
            }
        } else if (sheetIndex != null) {
            sheet = workbook.createSheet();
            workbook.setSheetOrder(sheet.getSheetName(), sheetIndex.intValue());
        } else {
            sheet = workbook.createSheet();
            workbook.setSheetOrder(sheet.getSheetName(), 0);
        }
        return sheet;
    }

    private static int write(ExcelWSheetProcessor<?> sheetProcessor, List<?> listPage, Class<?> clazz, Map<String, CellStyle> cellStyles, int writeRowIndex) throws Exception {
        SXSSFSheet sheet = sheetProcessor.getSheet();
        RowData rowData = clazz.getAnnotation(RowData.class);
        Field[] declaredFields = clazz.getDeclaredFields();
        for (Object obj : listPage) {
            List<Row> rowList = ExcelWriteUtils.getRowList(writeRowIndex, (Sheet)sheet, rowData);
            for (Field field : declaredFields) {
                PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(clazz, (String)field.getName());
                Object val = pd.getReadMethod().invoke(obj, new Object[0]);
                ColumnData column = field.getAnnotation(ColumnData.class);
                if (null == column) continue;
                Cell cell = rowList.get(column.rowIndex()).createCell(column.colIndex());
                try {
                    if (rowData != null && column.isAcross()) {
                        CellRangeAddress cra = new CellRangeAddress(writeRowIndex, writeRowIndex + rowData.rowAcross() - 1, column.colIndex(), column.colIndex());
                        sheet.addMergedRegion(cra);
                    }
                    ExcelWriteUtils.setCell(cell, field.getType(), val);
                    CellStyle cellStyle = cellStyles.get(field.getName());
                    if (cellStyle != null) {
                        sheet.setColumnWidth(column.colIndex(), (int)column.width());
                        cell.setCellStyle(cellStyle);
                    }
                    if (!column.autoWidth()) continue;
                    sheet.trackAllColumnsForAutoSizing();
                    sheet.autoSizeColumn(column.colIndex());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (column.dealType().equals((Object)ColumnData.dealType.CONTINUE_CELL)) continue;
                    if (column.dealType().equals((Object)ColumnData.dealType.CONTINUE_ROW)) break;
                    throw new RuntimeException("deal cell exception", e);
                }
            }
            if (rowData != null) {
                writeRowIndex += rowData.rowAcross();
                continue;
            }
            ++writeRowIndex;
        }
        return writeRowIndex;
    }

    private static List<Row> getRowList(int writeRowIndex, Sheet sheet, RowData rowData) {
        ArrayList<Row> rowList = new ArrayList<Row>();
        for (int i = 0; rowData != null && i < rowData.rowAcross() || i < 1; ++i) {
            Row row = sheet.getRow(writeRowIndex + i);
            if (row == null) {
                row = ExcelWriteUtils.getRow(sheet, writeRowIndex + i);
            }
            rowList.add(row);
        }
        return rowList;
    }

    private static void setCell(Cell cell, Class<?> clazz, Object val) {
        try {
            if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
                cell.setCellValue((double)((Short)val).shortValue());
            } else if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
                cell.setCellValue((double)((Integer)val).intValue());
            } else if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
                cell.setCellValue((double)((Long)val).longValue());
            } else if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
                cell.setCellValue((double)((Float)val).floatValue());
            } else if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
                cell.setCellValue(((Double)val).doubleValue());
            } else if (clazz.equals(Date.class)) {
                cell.setCellValue((Date)val);
            } else if (clazz.equals(BigDecimal.class)) {
                cell.setCellValue(((BigDecimal)val).doubleValue());
            } else {
                cell.setCellValue(StringUtils.isEmpty((Object)val) ? "" : val.toString());
            }
        }
        catch (Exception e) {
            cell.setCellValue(StringUtils.isEmpty((Object)val) ? "" : val.toString());
        }
    }

    private static Map<String, CellStyle> getCellStyle(Workbook workbook, Class<?> clazz) {
        Field[] declaredFields;
        HashMap<String, CellStyle> cellStyles = new HashMap<String, CellStyle>();
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            ColumnData column = field.getAnnotation(ColumnData.class);
            if (null == column || StringUtils.isEmpty((Object)column.format())) continue;
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setAlignment(HorizontalAlignment.LEFT);
            DataFormat dataFormat = workbook.createDataFormat();
            cellStyle.setDataFormat(dataFormat.getFormat(column.format()));
            cellStyles.put(field.getName(), cellStyle);
        }
        return cellStyles;
    }

    private static SXSSFWorkbook createWorkBook() {
        return new SXSSFWorkbook(500);
    }

    private static void createTableHead(Sheet sheet, Class<?> clazz) {
        Field[] declaredFields;
        Row headRow = sheet.createRow(0);
        sheet.setColumnWidth(2, 5120);
        headRow.setHeightInPoints(20.0f);
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            ColumnData columnData = field.getAnnotation(ColumnData.class);
            if (null == columnData) continue;
            Cell cell = headRow.createCell(columnData.colIndex());
            cell.setCellValue("".equals(columnData.comment()) ? field.getName() : columnData.comment());
        }
    }

    private static Row getRow(Sheet sheet, int rownum) {
        return sheet.createRow(rownum);
    }

    private static void close(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (IOException e) {
            logger.error("\u5173\u95ed\u8f93\u51fa\u6d41\u65f6\u5f02\u5e38~", (Throwable)e);
            throw new RuntimeException("\u5173\u95ed\u8f93\u51fa\u6d41\u65f6\u5f02\u5e38~", e);
        }
    }
}

