package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
* 销售订单表Eo对象
*
* @author haoxiao
* @since 2022-03-10
*/
@ApiModel(value = "SaleOrderAmountReqDto", description = "销售订单表Eo对象")
public class SaleOrderAmountReqDto {


    @ApiModelProperty(
            name = "orderStatus",
            value = "订单状态"
    )
    private String orderStatus;
    @ApiModelProperty(
            name = "订单交易状态",
            value = "订单交易状态"
    )
    private String orderTradeStatus;

    /**
     *  销售订单创建时间
     */
    @ApiModelProperty(name = "saleOrderCreateTimeStart", value = "销售订单创建时间开始")
    private Date saleOrderCreateTimeStart;
    /**
     *  销售订单创建时间
     */
    @ApiModelProperty(name = "saleOrderCreateTimeEnd", value = "销售订单创建时间结束")
    private Date saleOrderCreateTimeEnd;

    /**
     *  平台订单号
     */
    @ApiModelProperty(name = "orderNo", value = "单号（平台订单号/内部销售订单号）")
    private String orderNo;


    /**
     *  关键字
     */
    @ApiModelProperty(name = "keyword", value = "关键字")
    private String keyword;


    @ApiModelProperty(name = "customerIds", value = "单号（平台订单号/内部销售订单号）")
    private List<Long> customerIds;

    @ApiModelProperty(name = "strCustomerIds", value = "单号（平台订单号/内部销售订单号）")
    private List<String> strCustomerIds;

    @ApiModelProperty(name = "orderStatusList", value = "状态集合")
    private List<String> orderStatusList;

    @ApiModelProperty(name = "noInOrderStatusList", value = "状态集合")
    private List<String> noInOrderStatusList;

    @ApiModelProperty(name = "payStatusList", value = "状态集合")
    private List<String> payStatusList;


    @ApiModelProperty(name = "noInPayStatusList", value = "状态集合")
    private List<String> noInPayStatusList;

    public String getOrderStatus() {
        return orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public String getOrderTradeStatus() {
        return orderTradeStatus;
    }

    public void setOrderTradeStatus(String orderTradeStatus) {
        this.orderTradeStatus = orderTradeStatus;
    }

    public Date getSaleOrderCreateTimeStart() {
        return saleOrderCreateTimeStart;
    }

    public void setSaleOrderCreateTimeStart(Date saleOrderCreateTimeStart) {
        this.saleOrderCreateTimeStart = saleOrderCreateTimeStart;
    }

    public Date getSaleOrderCreateTimeEnd() {
        return saleOrderCreateTimeEnd;
    }

    public void setSaleOrderCreateTimeEnd(Date saleOrderCreateTimeEnd) {
        this.saleOrderCreateTimeEnd = saleOrderCreateTimeEnd;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public List<Long> getCustomerIds() {
        return customerIds;
    }

    public void setCustomerIds(List<Long> customerIds) {
        this.customerIds = customerIds;
        if (customerIds!=null){
            setStrCustomerIds(customerIds.stream().map(String::valueOf).collect(Collectors.toList()));
        }
    }

    public List<String> getStrCustomerIds() {
        return customerIds.stream().map(String::valueOf).collect(Collectors.toList());
    }

    public void setStrCustomerIds(List<String> strCustomerIds) {
        this.strCustomerIds = strCustomerIds;
    }

    public List<String> getOrderStatusList() {
        return orderStatusList;
    }

    public void setOrderStatusList(List<String> orderStatusList) {
        this.orderStatusList = orderStatusList;
    }

    public List<String> getNoInOrderStatusList() {
        return noInOrderStatusList;
    }

    public void setNoInOrderStatusList(List<String> noInOrderStatusList) {
        this.noInOrderStatusList = noInOrderStatusList;
    }

    public List<String> getPayStatusList() {
        return payStatusList;
    }

    public void setPayStatusList(List<String> payStatusList) {
        this.payStatusList = payStatusList;
    }

    public List<String> getNoInPayStatusList() {
        return noInPayStatusList;
    }

    public void setNoInPayStatusList(List<String> noInPayStatusList) {
        this.noInPayStatusList = noInPayStatusList;
    }
}
