package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author minyue
 * @description: 订单明细统计
 * @since 2022-01-15 17:54
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OrderDetailStatisticsRespDto extends OrderDetailBaseRespDto {

    @ApiModelProperty(name = "orderNo", value = "订货单号")
    private String orderNo;

    @ApiModelProperty(name = "itemNum", value = "数量")
    private Integer itemNum;

    @ApiModelProperty(name = "unit", value = "单位")
    private String unit;

    @ApiModelProperty(name = "itemOrigAmount", value = "小计")
    private BigDecimal itemOrigAmount;

    @ApiModelProperty(name = "orderTradeStatus", value = "业务状态")
    private String orderTradeStatus;

    @ApiModelProperty(name = "orderTradeStatusName", value = "业务状态name")
    private String orderTradeStatusName;
}
