package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author minyue
 * @description: 促销活动汇总
 * @since 2022-01-13 17:52
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "PromotionalActivitiesStatisticsRespDto", description = "促销活动汇总")
@Data
public class PromotionalActivitiesStatisticsRespDto extends ReportBrandBaseRespDto {
    @ApiModelProperty(name = "itemType", value = "商品类型")
    private Integer itemType;

    @ApiModelProperty(name = "itemTypeStr", value = "商品类型Str")
    private String itemTypeStr;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "activityOrderNum", value = "活动订单数量")
    private Integer activityOrderNum;

    @ApiModelProperty(name = "activitySaleNum", value = "活动销售数量")
    private Integer activitySaleNum;

    @ApiModelProperty(name = "activitySaleAmount", value = "活动销售金额")
    private BigDecimal activitySaleAmount;

    @ApiModelProperty(name = "activityDiscountAmount", value = "活动优惠金额")
    private BigDecimal activityDiscountAmount;

    @ApiModelProperty(name = "saleAmount", value = "常规销售金额")
    private BigDecimal saleAmount;


    @ApiModelProperty(name = "partakeActivityNum", value = "参与活动次数")
    private Integer partakeActivityNum;


    @ApiModelProperty(name = "monthlyAverageOrderNum", value = "月均活动订单数量")
    private Integer monthlyAverageOrderNum;



    @ApiModelProperty(name = "monthlyAverageSaleNum", value = "月均销售数量")
    private Integer monthlyAverageSaleNum;


    @ApiModelProperty(name = "monthlyAverageSaleAmount", value = "月均活动销售金额")
    private BigDecimal monthlyAverageSaleAmount;



    @ApiModelProperty(name = "monthlyAverageDiscountAmount", value = "月均活动优惠金额")
    private BigDecimal monthlyAverageDiscountAmount;

    @ApiModelProperty(name = "monthlyAverageOrderPayAmount", value = "月均活动订单金额")
    private BigDecimal monthlyAverageOrderPayAmount;

    @ApiModelProperty(name = "activityOrderPayAmount", value = "活动订单实付金额（活动实付金额）")
    private BigDecimal activityOrderPayAmount;





}
