package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Table;


@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Table(name="task_customer_verify")
@ApiModel(value = "QueryCustomerVerifyTaskRespDto", description = "QueryCustomerVerifyTaskRespDto")
public class QueryCustomerVerifyTaskRespDto {

    @Column(name = "id")
    @ApiModelProperty(value = "主键")
    private String id;

    @Column(name = "code")
    @ApiModelProperty(value = "客户编号")
    private String code;

    @Column(name = "org_name")
    @ApiModelProperty(value = "公司名称")
    private String orgName;

    @Column(name = "credit_code")
    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    @Column(name = "legal_name")
    @ApiModelProperty(value = "法定代表人")
    private String legalName;

    @Column(name = "verify")
    @ApiModelProperty(value = "返回结果")
    private String verify;

    @Column(name = "verify_result")
    @ApiModelProperty(value = "返回结果信息")
    private String verifyResult;

    @Column(name = "process_status")
    @ApiModelProperty(value = "处理状态 默认-1(未处理),0处理失败,1处理成功")
    private String processStatus;

    @Column(name = "create_time")
    @ApiModelProperty(value = "创建时间")
    private String createTime;

    @Column(name = "update_time")
    @ApiModelProperty(value = "修改时间")
    private String updateTime;



}
