package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CountOrderItemNumReqDto;
import com.dtyunxi.tcbj.api.dto.response.CountorderItemNumRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Api(tags = {"报表中心: 单品管控"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/controlReport",
        url = "${tcbj.center.report.api:}"
)
public interface IControlReportQueryApi {

    @PostMapping("/countOrderItemNumByMonth")
    @ApiOperation("/查询月份有效订单商品数量(指定区域)")
    RestResponse<List<CountorderItemNumRespDto>> countOrderItemNumByMonth(@RequestBody List<CountOrderItemNumReqDto> countOrderItemNumReqDtos);


    @PostMapping("/countOrderItemNumByCustomerId")
    @ApiOperation("/查询月份有效订单商品数量(指定用户)")
    RestResponse<List<CountorderItemNumRespDto>> countOrderItemNumByCustomerId(@RequestBody List<CountOrderItemNumReqDto> countOrderItemNumReqDtos);
}
