package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.PhysicsInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.response.PhysicsInventoryCountDto;
import com.dtyunxi.tcbj.api.dto.response.PhysicsInventoryRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 物理仓库存表服务接口
*
* @author wude
* @since 2022-03-07
*/
@Api(tags = {"物理仓库存表服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/physicsInventory", url = "${tcbj.center.report.api:}")
public interface  IPhysicsInventoryQueryApi {

    /**
    * 根据id查询物理仓库存表
    *
    * @param id 物理仓库存表id
    * @return   物理仓库存表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询物理仓库存表", notes = "根据id查询物理仓库存表")
    RestResponse<PhysicsInventoryRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 物理仓库存表分页数据
    *
    * @param filter   物理仓库存表查询条件
    * @return 物理仓库存表分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "物理仓库存表分页数据", notes = "根据filter查询条件查询物理仓库存表数据，filter=PhysicsInventoryReqDto")
    RestResponse<PageInfo<PhysicsInventoryRespDto>> queryByPage(@RequestBody PhysicsInventoryReqDto filter);

    /**
     * 物理仓库存统计数据
     *
     * @param filter   物理仓库存表查询条件
     * @return 物理仓库存统计数据
     */
    @PostMapping("/count")
    @ApiOperation(value = "物理仓库存统计数据", notes = "根据filter查询条件查询物理仓库存表数据，filter=PhysicsInventoryReqDto")
    RestResponse<PhysicsInventoryCountDto> queryByCount(@RequestBody PhysicsInventoryReqDto filter);

}
