package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.LogicWarehouseReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 逻辑仓服务接口
*
* @author wude
* @since 2022-03-07
*/
@Api(tags = {"逻辑仓服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/report", url = "${tcbj.center.report.api:}")
public interface ILogicWarehouseQueryApi {

    /**
    * 根据id查询逻辑仓
    *
    * @param id 逻辑仓id
    * @return   逻辑仓数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询逻辑仓", notes = "根据id查询逻辑仓")
    RestResponse<LogicWarehouseRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 逻辑仓分页数据
    *
    * @param filter   逻辑仓查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 逻辑仓分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "逻辑仓分页数据", notes = "根据filter查询条件查询逻辑仓数据，filter=LogicWarehouseReqDto")
    RestResponse<PageInfo<LogicWarehouseRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
