package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.QueryCustomerOrgInfoReqDto;
import com.dtyunxi.tcbj.api.dto.response.QueryCustomerOrgInfoRespDto;
import com.dtyunxi.tcbj.api.dto.response.QueryCustomerVerifyTaskRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Api(tags = {"报表中心：客户数据关联查询"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/customerInfo",
        url = "${tcbj.center.report.api:}"
)
public interface ICustomerInfoApi {

    @PostMapping(value = {"/queryCustomerOrgInfo"}, produces = "application/json")
    @ApiOperation(value = "关联org表查询Customer信息", notes = "关联org表查询Customer信息")
    RestResponse<List<QueryCustomerOrgInfoRespDto>> queryCustomerOrgInfo(@RequestBody QueryCustomerOrgInfoReqDto reqDto);

    @PostMapping(value = {"/queryCustomerVerifyTask"}, produces = "application/json")
    @ApiOperation(value = "queryCustomerVerifyTask", notes = "queryCustomerVerifyTask")
    RestResponse<List<QueryCustomerVerifyTaskRespDto>> queryCustomerVerifyTask();

    @PostMapping(value = {"/updateVerifyTask"}, produces = "application/json")
    @ApiOperation(value = "updateVerifyTask", notes = "updateVerifyTask")
    RestResponse<Void> updateVerifyTask(@RequestBody QueryCustomerVerifyTaskRespDto reqDto);
}
