package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.BaseDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * Eo对象
 *
 * @author shuyi
 * @since 2022-04-07
 */
@ApiModel(value = "StrategyAutoCheckRuleReportReqDto", description = "Eo对象")
@Data
public class StrategyAutoCheckRuleReportReqDto extends BaseDto {
    /**
     * 主键
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     * 规则名称
     */
    @ApiModelProperty(name = "ruleName", value = "规则名称")
    private String ruleName;
    /**
     * 规则编码
     */
    @ApiModelProperty(name = "ruleCode", value = "规则编码")
    private String ruleCode;
    /**
     * 优先级
     */
    @ApiModelProperty(name = "priority", value = "优先级")
    private Integer priority;
    /**
     * 有效周期 开始时间
     */
    @ApiModelProperty(name = "activeStartTime", value = "有效周期 开始时间")
    private Date activeStartTime;
    /**
     * 结束时间
     */
    @ApiModelProperty(name = "activeEndTime", value = "结束时间")
    private Date activeEndTime;
    /**
     * 规则状态 0-已禁用 1-已启用 2-已失效
     */
    @ApiModelProperty(name = "ruleStatus", value = "规则状态 0-已禁用 1-已启用 2-已失效")
    private Integer ruleStatus;


    @ApiModelProperty(name="createStartTime", value = "创建开始区间")
    private Date createStartTime;


    @ApiModelProperty(name="createEndTime", value = "创建结束时间")
    private Date createEndTime;


    @ApiModelProperty(name="updateStartTime", value = "更新开始时间")
    private Date updateStartTime;


    @ApiModelProperty(name="updateEndTime", value = "更新结束时间")
    private Date updateEndTime;
}
