package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.CompanySimpleInfoDto;
import com.dtyunxi.tcbj.api.dto.response.OrganizationInfoExtTemporaryDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
* @author lshaowu
* @time 2022/7/13 19:10
* @description 增加用于通过名称和其他字段查询出全部用户包含注销和未注销，可补充其他方法
*/
@Api(tags = {"报表中心：用户账户扩展查询服务V2版"})
@FeignClient(contextId = "com-dtyunxi-tcbj-api-query-IUserExtV2QueryApi",path = "/v2/user",name = "${com.dtyunxi.tcbj.api.name:tcbj-center-report}",url = "${tcbj.center.report.api:}")
public interface IUserExtV2QueryApi {

    /**
    * @Date 2022/7/13 20:10
    * @author lshaowu
    * @Description  新增用于查询出注销和未注销的所有用户。
    * @Param
    * @return
    */
    @ApiOperation(value = "根据名称（nickName或userName）查询用户ID信息服务",notes = "根据名称查询出所用用户ID，包括已删除和未删除的")
    @GetMapping("/queryUserByName")
    RestResponse<List<Long>> queryUserByName(@RequestParam(name = "name") String name);

    /**
     * 根据组织id查询组织公司信息
     * @param orgIdList
     * @return
     */
    @PostMapping("/queryOrgInfoByOrgId")
    @ApiOperation(value = "根据组织id查询组织公司信息", notes = "根据组织id查询组织公司信息")
    RestResponse<List<OrganizationInfoExtTemporaryDto>> queryOrgInfoByOrgId(@RequestBody List<Long> orgIdList);

    @GetMapping("/getOrgInfoByUserId")
    @ApiOperation(value = "查询用户的绑定人员有效的组织商家", notes = "查询用户的绑定人员有效的组织商家")
    RestResponse<List<OrganizationDto>> getOrgInfoByUserId(@RequestParam("userId")Long userId);

    /**
     * 根据客户id查询公司名称和组织id
     * @param cusIdList
     * @return
     */
    @PostMapping("/queryCompanyNameByCusId")
    @ApiOperation(value = "根据组织id查询组织公司信息", notes = "根据组织id查询组织公司信息")
    RestResponse<Map<Long, CompanySimpleInfoDto>> queryCompanyNameByCusId(@RequestBody List<Long> cusIdList);
}
