package com.dtyunxi.tcbj.api.biz.customer;

import com.dtyunxi.tcbj.api.biz.customer.dto.CustomerFullAreaDto;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface CustomerExport2025Mapper {

    @Select({
        "SELECT",
        "  customer_id AS customerId,",
        "  full_area AS fullArea,",
        "  t0.name AS region0,",
        "  t1.name AS region1,",
        "  t2.name AS region2",
        "FROM yx_prod_customer.customer_full_area",
        "WHERE customer_id IN",
        "<foreach collection='customerIds' item='id' open='(' separator=',' close=')'>",
        "  #{id}",
        "</foreach>"
    })
    List<CustomerFullAreaDto> queryByCustomerIds(@Param("customerIds") List<Long> customerIds);
}