package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.QualityInspectionDataReqDto;
import com.dtyunxi.tcbj.api.dto.response.QualityInspectionDataRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 质检数据服务接口
 *
 * @author 天泽
 * @since 2022-08-09
 */
@Api(tags = {"质检数据服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-query-IQualityInspectionDataQueryApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/quality/inspection",
        url = "${tcbj.center.report.api:}"
)
public interface IQualityInspectionDataQueryApi {

    /**
     * 根据id查询质检数据
     *
     * @param id 质检数据id
     * @return 质检数据数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询质检数据", notes = "根据id查询质检数据")
    RestResponse<QualityInspectionDataRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 质检数据分页数据
     *
     * @param filter   质检数据查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 质检数据分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "质检数据分页数据", notes = "根据filter查询条件查询质检数据数据，filter=QualityInspectionDataReqDto")
    RestResponse<PageInfo<QualityInspectionDataRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                     @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                     @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 质检列表数据
     *
     * @param queryList   质检数据查询条件

     * @return 质检数据分页数据
     */
    @PostMapping("/list")
    @ApiOperation(value = "质检数据不分页", notes = "QualityInspectionDataReqDto")
    RestResponse<List<QualityInspectionDataRespDto>> queryByList(@RequestBody List<QualityInspectionDataReqDto> queryList);

}
