package com.dtyunxi.tcbj.api.dto.response;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * LogicalInventoryListPageParams
 */
@Data
@ApiModel(value = "LogicInventoryListRespDto", description = "请求类")
public class LogicInventoryListRespDto {


    /** 仓库ID */
    @ApiModelProperty(name="warehouseId",value = "仓库ID")
    private Long warehouseId;
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 货品编码 */
    @ApiModelProperty(name="skuCode",value = "货品编码")
    private String skuCode;
    @ApiModelProperty(name = "skuName", value = "货品名称")
    private String skuName;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 批次类型 common-正常,defective-残次品,其他类型待定 */
    @ApiModelProperty(name="batchType",value = "批次类型 common-正常,defective-残次品,其他类型待定")
    private String batchType;
    /** 总库存 */
    @ApiModelProperty(name="balance",value = "总库存")
    private BigDecimal balance;
    /** 预占库存 */
    @ApiModelProperty(name="preempt",value = "预占库存")
    private BigDecimal preempt;
    /** 已分配库存 */
    @ApiModelProperty(name="allocate",value = "已分配库存")
    private BigDecimal allocate;
    /** 活动分配库存 */
    @ApiModelProperty(name="activityAllocate",value = "活动分配库存")
    private BigDecimal activityAllocate;
    /** 在途库存 */
    @ApiModelProperty(name="intransit",value = "在途库存")
    private BigDecimal intransit;
    /** 已调拨库存 */
    @ApiModelProperty(name="transfer",value = "已调拨库存")
    private BigDecimal transfer;
    /** 可用库存,可用库存 = 总库存 + 在途库存 - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存 */
    @ApiModelProperty(name="available",value = "可用库存,可用库存 = 总库存 + 在途库存 - 预占库存 - 已分配库存 - 已调拨库存 - 活动分配库存")
    private BigDecimal available;
    /** 备注 */
    @ApiModelProperty(name="remark",value = "备注")
    private String remark;
    @ApiModelProperty(name = "expireTime", value = "过期日期")
    private Date expireTime;
    @ApiModelProperty(name = "produceTime", value = "生产日期")
    private Date produceTime;

}
