/**
 * @(#) GetOutNoticeOrderListPageParams.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.request.es;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * EsOutNoticeOrderListPageParams
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "EsOutNoticeOrderListPageParams", description = "")
public class EsOutNoticeOrderListPageParams extends EsBaseReqParams {
  
  @ApiModelProperty(name="documentNo", value = "出库通知单号/前置业务单号/平台单号")
  @JsonProperty("documentNo")
  private String documentNo;

  @ApiModelProperty(name="documentNos", value = "出库通知单号集合")
  @JsonProperty("documentNos")
  private List<String> documentNos;
  
  
  @ApiModelProperty(name="businessType", value = "业务类型")
  @JsonProperty("businessType")
  private String businessType;
  
  
  @ApiModelProperty(name="documentStatus", value = "出库状态")
  @JsonProperty("documentStatus")
  private String documentStatus;
  
  
  @ApiModelProperty(name="startTime", value = "开始时间")
  @JsonProperty("startTime")
  private String startTime;
  
  
  @ApiModelProperty(name="endTime", value = "结束时间")
  @JsonProperty("endTime")
  private String endTime;


  @ApiModelProperty(name="startTimeDate", value = "开始时间Date")
  @JsonProperty("startTimeDate")
  private Date startTimeDate;


  @ApiModelProperty(name="endTimeDate", value = "结束时间Date")
  @JsonProperty("endTimeDate")
  private Date endTimeDate;


  @ApiModelProperty(name="inLogicWarehouseName", value = "入库逻辑仓库")
  @JsonProperty("inLogicWarehouseName")
  private String inLogicWarehouseName;

  @ApiModelProperty(name="outLogicWarehouseName", value = "出库逻辑仓库")
  @JsonProperty("outLogicWarehouseName")
  private String outLogicWarehouseName;

  private String orderType;

  @ApiModelProperty(name = "orderStatus", value = "单据状态")
  @JsonProperty("orderStatus")
  private String orderStatus;

  @ApiModelProperty(name="wmsStatusList", value = "wms执行状态")
  @JsonProperty("wmsStatusList")
  private List<String> wmsStatusList;

  @ApiModelProperty(name="businessTypeList", value = "业务类型集合")
  @JsonProperty("businessTypeList")
  private List<String> businessTypeList;

  @ApiModelProperty(name="documentStatusList", value = "出库状态")
  @JsonProperty("documentStatusList")
  private List<String> documentStatusList;
}

