package com.dtyunxi.tcbj.api.dto.request.es;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 销售订单明细列表查询入参
 *
 */
@Data
@ApiModel(value = "SaleOrderContrastPageParams", description = "销售订单明细列表查询入参")
public class SaleOrderContrastPageEsParams extends EsBaseReqParams {


    @ApiModelProperty(name = "orderNo", value = "单号")
    private String orderNo;

    @ApiModelProperty(name = "orderStatus", value = "单据状态")
    private String orderStatus;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "itemCode", value = "商品编码")
    private String itemCode;

    @ApiModelProperty(name = "startOutItemNum", value = "起始已出库数量")
    private BigDecimal startOutItemNum;

    @ApiModelProperty(name = "endOutItemNum", value = "结束已出库数量")
    private BigDecimal endOutItemNum;

    @ApiModelProperty(name = "startItemNum", value = "起始商品数量")
    private BigDecimal startItemNum;

    @ApiModelProperty(name = "endItemNum", value = "结束商品数量")
    private BigDecimal endItemNum;

    @ApiModelProperty(name = "startDifferenceNum", value = "起始差异数")
    private BigDecimal startDifferenceNum;

    @ApiModelProperty(name = "endDifferenceNum", value = "结束差异数")
    private BigDecimal endDifferenceNum;

    @ApiModelProperty(name = "startTime", value = "开始时间")
    private String startTime;

    @ApiModelProperty(name = "endTime", value = "结束时间")
    private String endTime;

    @ApiModelProperty(name = "startVolumeSum", value = "起始总体积")
    private BigDecimal startVolumeSum;

    @ApiModelProperty(name = "endVolumeSum", value = "结束总体积")
    private BigDecimal endVolumeSum;

    @ApiModelProperty(name = "logicalWarehouse", value = "逻辑仓")
    private String logicalWarehouse;

    @ApiModelProperty(name = "startSalePrice", value = "起始含税单价")
    private BigDecimal startSalePrice;

    @ApiModelProperty(name = "endSalePrice", value = "结束含税单价")
    private BigDecimal endSalePrice;

    @ApiModelProperty(name = "startLineAmount", value = "起始税价合计")
    private BigDecimal startLineAmount;

    @ApiModelProperty(name = "endLineAmount", value = "结束税价合计")
    private BigDecimal endLineAmount;

    @ApiModelProperty(name = "orderType", value = "订单类型 订单类型 common_order: ''普通订单'',agency_order: ''经销订单'',shoppe_order: ''专柜订单'',integral_order: ''积分订单'',replenishment_order: ''货补订单'',activity_order: ''活动订单'',customer_refunding_order: ''消费者退换'',compensation_order: ''索赔订单'',quality_refunding_order: ''质量退换货'',replenish_order: ''少货补发''")
    private String orderType;

    @ApiModelProperty(name = "updatePerson", value = "修改人")
    private String updatePerson;

    @ApiModelProperty(name = "batchNo", value = "批次号")
    private String batchNo;

    @ApiModelProperty(name = "isOnline", value = "订单来源：0：线下 1: 线上")
    private Integer isOnline;

    @ApiModelProperty(name = "orderSource", value = "订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入")
    private String orderSource;

    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;

    @ApiModelProperty(name = "organizationCodeList", value = "组织code")
    private List<String> organizationCodeList;

    @ApiModelProperty(name = "warehouseCode", value = "物理仓仓库编码")
    private String warehouseCode;

    @ApiModelProperty(name = "warehouseCodeList", value = "物理仓仓库编码")
    private List<String> warehouseCodeList;

    /**
     *  订单级别：0-原 1-主 2-子
     */
    @ApiModelProperty(name = "orderLevelList", value = "订单级别：0-原 1-主 2-子")
    private List<Integer> orderLevelList;

//
//    @ApiModelProperty(name="isPointGoods", value = "是否积分产品")
//    @JsonProperty("isPointGoods")
//    private String isPointGoods;



    @ApiModelProperty(name="customerName", value = "客户名称")
    @JsonProperty("customerName")
    private String customerName;

    @ApiModelProperty(name="deliveryName", value = "收件人姓名")
    @JsonProperty("deliveryName")
    private String deliveryName;

    @ApiModelProperty(name="deliveryPhone", value = "收件人电话")
    @JsonProperty("deliveryPhone")
    private String deliveryPhone;

    /**
     * 实际发货出库批次
     */
    @ApiModelProperty(name = "deliveryOutBatchNo", value = "实际发货出库批次")
    private String deliveryOutBatchNo;

    @ApiModelProperty(name="logisticsCompany", value = "承运商（物流公司）")
    @JsonProperty("logisticsCompany")
    private String logisticsCompany;


    /**
     *  发货方式
     */
    @JsonProperty("deliveryType")
    @ApiModelProperty(name = "deliveryType", value = "发货方式")
    private String deliveryType;

    /**
     *省
     */
    @ApiModelProperty(name = "province")
    @JsonProperty("province")
    private String province;
    /**
     *  省份编码
     */
    @ApiModelProperty(name = "provinceCode")
    @JsonProperty("provinceCode")
    private String provinceCode;

    @ApiModelProperty(name = "deliveryStauts",value = "发货状态 undelivered 未发货；delivered 已发货")
    private String deliveryStauts;

    @ApiModelProperty(name="orderTypeList", value = "订单类型")
    @JsonProperty("orderTypeList")
    private List<String> orderTypeList;

    private List<String> orderSourceList;

    private List<String> orderNoList;

    private List<String> saleOrderStatusList;

    /**
     *  是否积分商品:0否，1是
     */
    @ApiModelProperty(name = "integral", value = "是否积分商品:0否，1是")
    private Integer integral;


    @ApiModelProperty(name="shippingNo", value = "快递单号")
    @JsonProperty("shippingNo")
    private String shippingNo;

    @ApiModelProperty(name="logisticsNo", value = "物流单号")
    @JsonProperty("logisticsNo")
    private String logisticsNo;

    @JsonProperty("deliveryTypeList")
    @ApiModelProperty(name = "deliveryTypeList", value = "发货方式")
    private List<String> deliveryTypeList;

    @ApiModelProperty(name="deliveryPhysicalWarehouseList", value = "发货物理仓")
    private List<String> deliveryPhysicalWarehouseList;


    @ApiModelProperty(name = "startTime", value = "开始时间")
    private String deliveryStartTime;

    @ApiModelProperty(name = "endTime", value = "结束时间")
    private String deliveryEndTime;

    @ApiModelProperty(name = "startTime", value = "开始时间")
    private String easVerifyStartTime;

    @ApiModelProperty(name = "endTime", value = "结束时间")
    private String easVerifyEndTime;

    @ApiModelProperty(name = "allotType", value = "调拨方式")
    private String allotType;

    @ApiModelProperty(name = "allotOutWarehouseCode", value = "调出仓编码")
    private String allotOutWarehouseCode;

    @ApiModelProperty(name = "allotInWarehouseCode", value = "调入仓编码")
    private String allotInWarehouseCode;

    @ApiModelProperty(name = "excludeOrderTypeList", value = "排除的订单类型")
    private List<String> excludeOrderTypeList;



}
