package com.dtyunxi.tcbj.api.dto.constant.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
public enum LogisticInfoStatusEnum {
    NO_MSG("-1", "无物流轨迹"),
    SUBMIT("0", "提交"),
    ASSIGN("1", "捡货"),
    SEND("2", "已发货"),
    IN_ROAD("3", "在途"),
    SIGN("4", "签收"),
    RETURN("5", "回单");

    private String code;
    private String name;

    LogisticInfoStatusEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }
    public static Map<String,String> map = new HashMap<String,String>();
    static {
        LogisticInfoStatusEnum[] values = LogisticInfoStatusEnum.values();
        for (LogisticInfoStatusEnum value : values) {
            String code = value.code;
            String name = value.getName();
            map.put(code,name);
        }
    }
}
