package com.dtyunxi.tcbj.api.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.math.BigDecimal;

/**
 * LogicalInventoryCountPageVO
 */
@Data
@ApiModel(value = "LogicalInventoryCountPageVO", description = "响应实体类")
public class LogicalInventoryCountPageVO {

    @Valid
    @ApiModelProperty(name="actualInventory", value = "实际库存")
    @JsonProperty("actualInventory")
    private BigDecimal actualInventory;


    @Valid
    @ApiModelProperty(name="preoccupyInventory", value = "预占库存")
    @JsonProperty("preoccupyInventory")
    private BigDecimal preoccupyInventory;


    @Valid
    @ApiModelProperty(name="availableInventory", value = "可用库存")
    @JsonProperty("availableInventory")
    private BigDecimal availableInventory;


    @Valid
    @ApiModelProperty(name="moveInventory", value = "在途库存")
    @JsonProperty("moveInventory")
    private BigDecimal moveInventory;


    @Valid
    @ApiModelProperty(name="receivedInventory", value = "待收库存")
    @JsonProperty("receivedInventory")
    private BigDecimal receivedInventory;


    @Valid
    @ApiModelProperty(name="countInventory", value = "合计总数")
    @JsonProperty("countInventory")
    private BigDecimal countInventory;

}
