package com.dtyunxi.tcbj.api.dto.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class ClaimOrderDetailReqDto {

    @ApiModelProperty(name = "platformOrderNo", value = "单号（平台订单号）")
    private String platformOrderNo;
    /**
     *  平台下单时间
     */
    @ApiModelProperty(name = "platformCreateTimeStart", value = "平台下单时间开始")
    private Date platformCreateTimeStart;
    /**
     *  平台下单时间
     */
    @ApiModelProperty(name = "platformCreateTimeEnd", value = "平台下单时间结束")
    private Date platformCreateTimeEnd;

    @ApiModelProperty( name = "skuCode",value = "商品编码")
    private String skuCode;

    @ApiModelProperty(name = "orderType", value = "订单类型，'claim_reissue': ''仓库索赔补发'','claim_posting': ''仓库索赔过账'','compensation_not_order': ''索赔不补发''," +
            " 'compensation_order': ''索赔补发'','bb_transfer_claim_not_reissue': ''BB调拨索赔不补发'','ds_transfer_claims_not_reissue': ''电商调拨索赔不补发'")
    @JsonProperty("orderType")
    private String orderType;

    @ApiModelProperty(name = "organizationIds", value = "组织")
    @JsonProperty("organizationIds")
    private List<Long> organizationIds;

    @ApiModelProperty(name = "orderTypeList", value = "订单类型")
    @JsonProperty("orderTypeList")
    private List<String> orderTypeList;

    @ApiModelProperty(name = "transferStatusList", value = "转单状态")
    @JsonProperty("transferStatusList")
    private List<String> transferStatusList;

    @ApiModelProperty(name="pageNum", value = "")
    @JsonProperty("pageNum")
    private Integer pageNum = 1;

    @ApiModelProperty(name="pageSize", value = "")
    @JsonProperty("pageSize")
    private Integer pageSize = 10;

}
