package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;

import com.dtyunxi.tcbj.api.dto.request.RpAllotLoseEfficacyConfigReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 近效期配置表服务接口
*
* @author jiejun
* @since 2022-10-14
*/
@Api(tags = {"近效期配置表服务"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/rpAllotLoseEfficacyConfig",
        url = "${tcbj.center.report.api:}"
)
public interface IRpAllotLoseEfficacyConfigApi {

/**
* 新增近效期配置表
*
* @param addReqDto 近效期配置表请求对象
* @return 处理结果
*/
    @PostMapping("/addRpAllotLoseEfficacyConfig")
    @ApiOperation(value = "新增近效期配置表", notes = "新增近效期配置表")
    RestResponse<Long> addRpAllotLoseEfficacyConfig(@RequestBody RpAllotLoseEfficacyConfigReqDto addReqDto);

    /**
    * 修改近效期配置表
    *
    * @param modifyReqDto 近效期配置表请求对象
    * @return 处理结果
    */
    @PostMapping("/modifyRpAllotLoseEfficacyConfig")
    @ApiOperation(value = "修改近效期配置表", notes = "修改近效期配置表")
    RestResponse<Void> modifyRpAllotLoseEfficacyConfig(@RequestBody RpAllotLoseEfficacyConfigReqDto modifyReqDto);

    /**
    * 删除近效期配置表
    *
    * @param ids        近效期配置表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除近效期配置表", notes = "删除近效期配置表")
    RestResponse<Void> removeRpAllotLoseEfficacyConfig(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
