package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @Description 定开人员表
 */
@ApiModel(value = "EmployeeOrgQueryReqDto", description = "组织人员查询DTO")
public class EmployeeOrgQueryReqDto extends RequestDto {


    private Integer pageNum;

    private Integer pageSize;
    /**
     * 主键IDs(查询参数)
     */
    @ApiModelProperty(name = "ids", value = "人员id集合")
    private List<Long> ids;
    @ApiModelProperty(name = "organizationId", value = "组织Id")
    private Long organizationId;
    @ApiModelProperty(name = "organizationIdList",value = "组织id集合")
    private List<Long> organizationIdList;
    @ApiModelProperty(name = "orgNameLike",value = "组织名称-模糊查询")
    private String orgNameLike;
    @ApiModelProperty(name = "orgCodeLike",value = "组织编码-模糊查询")
    private String orgCodeLike;
    @ApiModelProperty(name = "sellerNameLike",value = "商家名称-模糊查询")
    private String sellerNameLike;
    @ApiModelProperty(name = "superiorSellerName",value = "上级商家名称-模糊查询")
    private String superiorSellerNameLike;
    @ApiModelProperty(name = "dealerCode",value = "客户/经销商编号-模糊查询")
    private String dealerCodeLike;

    /**
     * 状态:1启用,2禁用
     */
    @ApiModelProperty(name = "status",value = "状态:1启用,2禁用")
    private Integer status;

    /**
     * 姓名
     */
    @ApiModelProperty(name = "name",value = " 姓名")
    private String name;

    /**
     * 部门
     */
    @ApiModelProperty(name = "station",value = "部门")
    private String station;

    /**
     * 职位
     */
    @ApiModelProperty(name = "position",value = "职位")
    private String position;

    /**
     * 工号
     */
    @ApiModelProperty(name = "employeeNo",value = "工号")
    private String employeeNo;


    /**
     * 登录账号
     */
    @ApiModelProperty(name = "userName",value = "登录账号")
    private String userName;

    /**
     * 手机号码
     */
    @ApiModelProperty(name = "phoneNum",value = "手机号码")
    private String phoneNum;

    /**
     * 人员ID
     */
    @ApiModelProperty(name = "staffId",value = "人员ID")
    private String staffId;

    /**
     * 角色id集合
     */
    @ApiModelProperty(name = "roleIds",value = "角色id集合")
    private List<Long> roleIds;

    @ApiModelProperty(name = "customerId", value = "客户id")
    private Long customerId;

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public List<Long> getOrganizationIdList() {
        return organizationIdList;
    }

    public void setOrganizationIdList(List<Long> organizationIdList) {
        this.organizationIdList = organizationIdList;
    }

    public String getOrgNameLike() {
        return orgNameLike;
    }

    public void setOrgNameLike(String orgNameLike) {
        this.orgNameLike = orgNameLike;
    }

    public String getOrgCodeLike() {
        return orgCodeLike;
    }

    public void setOrgCodeLike(String orgCodeLike) {
        this.orgCodeLike = orgCodeLike;
    }

    public String getSellerNameLike() {
        return sellerNameLike;
    }

    public void setSellerNameLike(String sellerNameLike) {
        this.sellerNameLike = sellerNameLike;
    }

    public String getSuperiorSellerNameLike() {
        return superiorSellerNameLike;
    }

    public void setSuperiorSellerNameLike(String superiorSellerNameLike) {
        this.superiorSellerNameLike = superiorSellerNameLike;
    }

    public String getDealerCodeLike() {
        return dealerCodeLike;
    }

    public void setDealerCodeLike(String dealerCodeLike) {
        this.dealerCodeLike = dealerCodeLike;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStation() {
        return station;
    }

    public void setStation(String station) {
        this.station = station;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getEmployeeNo() {
        return employeeNo;
    }

    public void setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPhoneNum() {
        return phoneNum;
    }

    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }

    public String getStaffId() {
        return staffId;
    }

    public void setStaffId(String staffId) {
        this.staffId = staffId;
    }

    public List<Long> getRoleIds() {
        return roleIds;
    }

    public void setRoleIds(List<Long> roleIds) {
        this.roleIds = roleIds;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
}
