/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.api.dto.constant;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.tcbj.api.dto.constant.enums.BusinessTypeCodeEnum;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public enum ChargeReportBusinessTypeEnum {
    PURCHASE_REFUND(BusinessTypeCodeEnum.PURCHASE_REFUND.getCode(), "\u91c7\u8d2d\u8ba2\u5355\u9000\u8d27", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    BC_ALLOT(BusinessTypeCodeEnum.BC_ALLOT.getCode(), "bc\u8c03\u62e8", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    LLOT_OUT_ONLY(BusinessTypeCodeEnum.ALLOT_OUT_ONLY.getCode(), "\u5e93\u5b58\u8c03\u62e8\u5355\uff08\u8c03\u62e8\u51fa\u5e93\uff09", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS", "STAKE"})),
    ALLOT_OUT(BusinessTypeCodeEnum.ALLOT_OUT.getCode(), "\u8c03\u62e8\u5355\uff08\u666e\u901a\u8c03\u62e8\uff09", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS", "STAKE"})),
    ALLOT_SALE(BusinessTypeCodeEnum.ALLOT_SALE.getCode(), "\u9500\u552e\u8c03\u62e8", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS", "STAKE"})),
    OTHER_OUT(BusinessTypeCodeEnum.OTHER_OUT.getCode(), "\u5176\u4ed6\u51fa\u5e93", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS", "STAKE"})),
    ORDER_SALES_OUT(BusinessTypeCodeEnum.ORDER_SALES_OUT.getCode(), "\u8ba2\u5355\u9500\u552e\u51fa\u5e93", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    BAIJIAN_DIRECT_SALES(BusinessTypeCodeEnum.BAIJIAN_DIRECT_SALES.getCode(), "\u4f70\u5065\u76f4\u9500", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    CLAIM_REISSUE(BusinessTypeCodeEnum.CLAIM_REISSUE.getCode(), "\u4ed3\u5e93\u7d22\u8d54\u8865\u53d1", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    SECONDARY_DISTRIBUTION(BusinessTypeCodeEnum.SECONDARY_DISTRIBUTION.getCode(), "\u4e8c\u7ea7\u5206\u9500", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    AGENCY_ORDER(BusinessTypeCodeEnum.AGENCY_ORDER.getCode(), "\u7ecf\u9500\u8ba2\u5355", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    INTEGRAL_ORDER(BusinessTypeCodeEnum.INTEGRAL_ORDER.getCode(), "\u79ef\u5206\u8ba2\u5355", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    INTERNAL_DISTRIBUTION(BusinessTypeCodeEnum.INTERNAL_DISTRIBUTION.getCode(), "\u5185\u90e8\u5206\u9500", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    COMMON_ORDER(BusinessTypeCodeEnum.COMMON_ORDER.getCode(), "\u666e\u901a\u8ba2\u5355", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    PRESALE_ORDER(BusinessTypeCodeEnum.PRESALE_ORDER.getCode(), "\u9884\u552e\u8ba2\u5355", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    SHOPPE_ORDER(BusinessTypeCodeEnum.SHOPPE_ORDER.getCode(), "\u4e13\u67dc\u8ba2\u5355", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    ACTIVITY_ORDER(BusinessTypeCodeEnum.ACTIVITY_ORDER.getCode(), "\u6d3b\u52a8\u8ba2\u5355", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    NUTRITION_INTEGRAL(BusinessTypeCodeEnum.NUTRITION_INTEGRAL.getCode(), "\u8425\u517b\u5bb6\u79ef\u5206", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    OTHER_OUT_STOCK(BusinessTypeCodeEnum.OTHER_OUT_STOCK.getCode(), "\u5176\u4ed6\u51fa\u5e93\u5355", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS", "STAKE"})),
    REPLENISH_ORDER(BusinessTypeCodeEnum.REPLENISH_ORDER.getCode(), "\u5c11\u8d27\u8865\u53d1", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    COMPENSATION_ORDER(BusinessTypeCodeEnum.COMPENSATION_ORDER.getCode(), "\u7d22\u8d54\u8865\u53d1", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    CUSTOMER_REFUNDING_ORDER(BusinessTypeCodeEnum.CUSTOMER_REFUNDING_ORDER.getCode(), "\u6d88\u8d39\u8005\u9000\u6362\u8d27", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    REPLENISHMENT_ORDER(BusinessTypeCodeEnum.REPLENISHMENT_ORDER.getCode(), "\u8d27\u8865\u8ba2\u5355", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    QUALITY_REFUNDING_ORDER(BusinessTypeCodeEnum.QUALITY_REFUNDING_ORDER.getCode(), "\u8d28\u91cf\u9000\u6362\u8d27", Lists.newArrayList((Object[])new String[]{"PREMIUM", "SORT", "LOGISTICS", "EXPRESS"})),
    CHILD_DIRECT_SALES(BusinessTypeCodeEnum.CHILD_DIRECT_SALES.getCode(), "\u5b50\u516c\u53f8\u76f4\u9500", Lists.newArrayList((Object[])new String[]{"SORT", "LOGISTICS", "EXPRESS"}));

    private final String code;
    private final String name;
    private final List<String> labels;
    public static final String PREMIUM = "PREMIUM";
    public static final String SORT = "SORT";
    public static final String LOGISTICS = "LOGISTICS";
    public static final String EXPRESS = "EXPRESS";
    public static final String STAKE = "STAKE";
    public static final String STOCK_COMPANY = "0102";

    private ChargeReportBusinessTypeEnum(String code, String name, List<String> labels) {
        this.code = code;
        this.name = name;
        this.labels = labels;
    }

    public static List<String> getChargeType() {
        return ChargeReportBusinessTypeEnum.getCodeByLabel(Lists.newArrayList((Object[])new String[]{PREMIUM, SORT, LOGISTICS, EXPRESS}));
    }

    public static List<String> getCodeByLabel(String label) {
        return ChargeReportBusinessTypeEnum.getCodeByLabel(Lists.newArrayList((Object[])new String[]{label}));
    }

    public static List<String> getCodeByLabel(List<String> labels) {
        List collect = Arrays.stream(ChargeReportBusinessTypeEnum.values()).filter(f -> CollectionUtil.containsAny(f.getLabels(), (Collection)labels)).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(collect)) {
            return collect.stream().map(ChargeReportBusinessTypeEnum::getCode).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public static boolean checkGeneral(String businessType, String relevanceTableName, String outInventoryOrgCode) {
        return relevanceTableName.equals("cs_order_sale") || relevanceTableName.equals(BC_ALLOT.getCode()) || !Objects.equals(outInventoryOrgCode, STOCK_COMPANY);
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLabels() {
        return this.labels;
    }
}

