/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.query.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.tcbj.api.dto.request.CustomerExtReqDto;
import com.dtyunxi.tcbj.api.dto.request.CustomerStoreReqDto;
import com.dtyunxi.tcbj.api.dto.response.CustomerExtRespDto;
import com.dtyunxi.tcbj.api.dto.response.CustomerStoreResponseDto;
import com.dtyunxi.tcbj.biz.service.CustomerDistributorsService;
import com.dtyunxi.tcbj.dao.das.CsCustomerDas;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreCategoryCodeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CustomerDistributorsServiceImpl
implements CustomerDistributorsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomerDistributorsServiceImpl.class);
    @Resource
    private CsCustomerDas customerDas;

    @Override
    public CustomerRespDto queryCustomerByDistributionCode(String distributionCode) {
        return this.customerDas.queryCustomerByDistributionCode(distributionCode);
    }

    @Override
    public List<CustomerExtRespDto> queryCustomer(CustomerExtReqDto customerReqDto) {
        return this.customerDas.queryCustomer(customerReqDto);
    }

    @Override
    public List<CustomerRespDto> queryCustomerList(CustomerExtReqDto customerReqDto) {
        return this.customerDas.queryCustomerList(customerReqDto);
    }

    @Override
    public PageInfo<CustomerExtRespDto> queryCustomerPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerExtReqDto customerExtReqDto = (CustomerExtReqDto)JSON.parseObject((String)filter, CustomerExtReqDto.class);
        Page customerExtRespDtoPage = this.customerDas.queryCustomerPage(customerExtReqDto, pageNum, pageSize);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)customerExtRespDtoPage, (String[])new String[]{"list", "navigatepageNums"});
        List customerExtRespDtoPageResult = customerExtRespDtoPage.getResult();
        if (CollectionUtils.isNotEmpty((Collection)customerExtRespDtoPageResult)) {
            ArrayList respDto = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)respDto, (Collection)customerExtRespDtoPageResult, CustomerExtRespDto.class);
            respDtoPageInfo.setList((List)respDto);
        }
        return respDtoPageInfo;
    }

    @Override
    public List<CustomerExtRespDto> queryCustomerAndUserList(CustomerExtReqDto customerReqDto) {
        return this.customerDas.queryCustomerAndUserList(customerReqDto);
    }

    @Override
    public PageInfo<CustomerStoreResponseDto> queryCustomerStorePage(String filter, Integer pageNum, Integer pageSize) {
        LOGGER.info("\u67e5\u8be2\u5ba2\u6237\u836f\u5e97\u5168\u91cf\u4fe1\u606f params : {}", (Object)filter);
        CustomerStoreReqDto customerStoreReqDto = (CustomerStoreReqDto)JSON.parseObject((String)filter, CustomerStoreReqDto.class);
        Page customerStoreResponseDtos = this.customerDas.queryCustomerStorePage(customerStoreReqDto, pageNum, pageSize);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)customerStoreResponseDtos, (String[])new String[]{"list", "navigatepageNums"});
        List customerStoreResponseDtosResult = customerStoreResponseDtos.getResult();
        if (CollectionUtils.isNotEmpty((Collection)customerStoreResponseDtosResult)) {
            customerStoreResponseDtosResult.forEach(c -> {
                if (StoreCategoryCodeEnum.fromCode((String)c.getStoreCategoryCode()) != null) {
                    c.setStoreCategoryName(StoreCategoryCodeEnum.fromCode((String)c.getStoreCategoryCode()).getName());
                }
            });
            respDtoPageInfo.setList(customerStoreResponseDtosResult);
        }
        return respDtoPageInfo;
    }
}

