/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.query.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.dto.BaseRespDto;
import com.dtyunxi.tcbj.api.dto.request.EmployeeOrgQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.OrgSellerCustomerQueryReqDto;
import com.dtyunxi.tcbj.api.dto.response.EmployeeOrgRespDto;
import com.dtyunxi.tcbj.api.dto.response.OrgSellerCustomerRespDto;
import com.dtyunxi.tcbj.biz.service.query.IOrgSellerCustomerService;
import com.dtyunxi.tcbj.dao.das.OrgSellerCustomerDas;
import com.dtyunxi.tcbj.dao.vo.EmployeeAreaCountVo;
import com.dtyunxi.tcbj.dao.vo.EmployeeCustomerCountVo;
import com.dtyunxi.tcbj.dao.vo.EmployeeCustomerQueryVo;
import com.dtyunxi.tcbj.dao.vo.EmployeeExpandQueryVo;
import com.dtyunxi.tcbj.dao.vo.EmployeeRoleVo;
import com.dtyunxi.tcbj.dao.vo.EmployeeUserVo;
import com.dtyunxi.tcbj.dao.vo.OrgSellerCustomerQueryVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgSellerCustomerServiceImpl
implements IOrgSellerCustomerService {
    private static final Logger logger = LoggerFactory.getLogger(OrgSellerCustomerServiceImpl.class);
    @Resource
    private OrgSellerCustomerDas orgSellerCustomerDas;
    @Resource
    private HttpServletRequest request;

    @Override
    public PageInfo<OrgSellerCustomerRespDto> orgSellerCustomerPage(OrgSellerCustomerQueryReqDto queryReqDto) {
        logger.info("\u67e5\u8be2\u7ec4\u7ec7\u5ba2\u6237\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryReqDto));
        OrgSellerCustomerQueryVo queryVo = new OrgSellerCustomerQueryVo();
        CubeBeanUtils.copyProperties((Object)queryVo, (Object)queryReqDto, (String[])new String[]{"organizationIdList", "merchantIdList"});
        queryVo.setOrganizationIdList(queryReqDto.getOrganizationIdList());
        queryVo.setMerchantIdList(queryReqDto.getMerchantIdList());
        PageInfo voPage = this.orgSellerCustomerDas.queryOrgSellerCustomerPage(queryVo);
        if (CollectionUtils.isEmpty((Collection)voPage.getList())) {
            return new PageInfo();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)voPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)voPage.getList(), OrgSellerCustomerRespDto.class);
        pageInfo.setList((List)dtoList);
        return pageInfo;
    }

    @Override
    public PageInfo<EmployeeOrgRespDto> queryEmployeeOrgPage(EmployeeOrgQueryReqDto queryReqDto) {
        List userVos;
        List employeeRoleVos;
        logger.info("\u67e5\u8be2\u7ec4\u7ec7\u4eba\u5458\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryReqDto));
        EmployeeExpandQueryVo queryVo = new EmployeeExpandQueryVo();
        CubeBeanUtils.copyProperties((Object)queryVo, (Object)queryReqDto, (String[])new String[]{"organizationIdList", "roleIds"});
        queryVo.setOrganizationIdList(queryReqDto.getOrganizationIdList());
        queryVo.setRoleIds(queryReqDto.getRoleIds());
        PageInfo voPage = new PageInfo();
        if (null != queryReqDto.getPageNum() && null != queryReqDto.getPageSize()) {
            voPage = this.orgSellerCustomerDas.queryEmployeeOrgPage(queryVo);
        } else {
            List employeeOrgList = this.orgSellerCustomerDas.queryEmployeeOrgList(queryVo);
            voPage.setList(employeeOrgList);
        }
        if (CollectionUtils.isEmpty((Collection)voPage.getList())) {
            return new PageInfo();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)voPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)voPage.getList(), EmployeeOrgRespDto.class);
        List employeeIdList = dtoList.stream().map(BaseRespDto::getId).distinct().collect(Collectors.toList());
        Map<Object, Object> roleNameMap = new HashMap();
        if (CollectionUtils.isNotEmpty(employeeIdList) && CollectionUtils.isNotEmpty((Collection)(employeeRoleVos = this.orgSellerCustomerDas.queryRoleByEmployeeId(employeeIdList)))) {
            roleNameMap = employeeRoleVos.stream().collect(Collectors.toMap(EmployeeRoleVo::getEmployeeId, Function.identity()));
        }
        List userIdList = dtoList.stream().map(EmployeeOrgRespDto::getUserId).distinct().collect(Collectors.toList());
        Map<Object, Object> userNameMap = new HashMap();
        if (CollectionUtils.isNotEmpty(userIdList) && CollectionUtils.isNotEmpty((Collection)(userVos = this.orgSellerCustomerDas.queryUserById(userIdList)))) {
            userNameMap = userVos.stream().collect(Collectors.toMap(EmployeeUserVo::getId, Function.identity()));
        }
        Date today = DateUtil.getToday();
        List orgIdList = dtoList.stream().map(EmployeeOrgRespDto::getOrganizationId).distinct().collect(Collectors.toList());
        EmployeeCustomerQueryVo areaQuery = new EmployeeCustomerQueryVo();
        areaQuery.setEmployeeIdList(employeeIdList);
        areaQuery.setOrganizationIdList(orgIdList);
        areaQuery.setToDay(DateUtil.getDateFormat((Date)today, (String)"yyyy-MM-dd"));
        List employeeAreaCountVos = this.orgSellerCustomerDas.queryAreaNumByEmployeeId(areaQuery);
        Map<Object, Object> areaNumMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)employeeAreaCountVos)) {
            areaNumMap = employeeAreaCountVos.stream().collect(Collectors.toMap(vo -> vo.getMerchantId() + "_" + vo.getEmployeeId(), EmployeeAreaCountVo::getCountNum));
        }
        List employeeCustomerCountVos = this.orgSellerCustomerDas.queryCustomerByEmployeeId(areaQuery);
        Map<Object, Object> customerNumMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)employeeCustomerCountVos)) {
            customerNumMap = employeeCustomerCountVos.stream().collect(Collectors.toMap(vo -> vo.getMerchantId() + "_" + vo.getEmployeeId(), EmployeeCustomerCountVo::getCountNum));
        }
        for (EmployeeOrgRespDto employeeOrgDto : dtoList) {
            if (!roleNameMap.isEmpty() && roleNameMap.containsKey(employeeOrgDto.getId())) {
                EmployeeRoleVo employeeRoleVo = (EmployeeRoleVo)roleNameMap.get(employeeOrgDto.getId());
                employeeOrgDto.setRoleNames(employeeRoleVo.getRoleNames());
            }
            if (!userNameMap.isEmpty() && userNameMap.containsKey(employeeOrgDto.getUserId())) {
                EmployeeUserVo userVo = (EmployeeUserVo)userNameMap.get(employeeOrgDto.getUserId());
                employeeOrgDto.setUserName(userVo.getUserName());
            }
            String key = employeeOrgDto.getOrganizationId() + "_" + employeeOrgDto.getId();
            employeeOrgDto.setCustomerAreaNum(0);
            if (!areaNumMap.isEmpty() && areaNumMap.containsKey(key)) {
                employeeOrgDto.setCustomerAreaNum(((Integer)areaNumMap.get(key)).intValue());
            }
            employeeOrgDto.setCustomerNum(0);
            if (customerNumMap.isEmpty() || !customerNumMap.containsKey(key)) continue;
            employeeOrgDto.setCustomerNum(((Integer)customerNumMap.get(key)).intValue());
        }
        pageInfo.setList((List)dtoList);
        return pageInfo;
    }

    @Override
    public PageInfo<EmployeeOrgRespDto> employeeByCustomerIdPage(EmployeeOrgQueryReqDto queryReqDto) {
        logger.info("\u6839\u636e\u5ba2\u6237id\u67e5\u8be2\u4eba\u5458\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryReqDto));
        EmployeeExpandQueryVo queryVo = new EmployeeExpandQueryVo();
        CubeBeanUtils.copyProperties((Object)queryVo, (Object)queryReqDto, (String[])new String[]{"organizationIdList", "roleIds"});
        queryVo.setOrganizationIdList(queryReqDto.getOrganizationIdList());
        PageInfo voPage = this.orgSellerCustomerDas.employeeByCustomerIdPage(queryVo);
        if (CollectionUtils.isEmpty((Collection)voPage.getList())) {
            return new PageInfo();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)voPage, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isEmpty((Collection)voPage.getList())) {
            return pageInfo;
        }
        ArrayList dtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)voPage.getList(), EmployeeOrgRespDto.class);
        pageInfo.setList((List)dtoList);
        return pageInfo;
    }
}

