/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderAmountReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.CommonAddrRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderAmountDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderCountRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.tcbj.biz.service.ISaleOrderService;
import com.dtyunxi.tcbj.biz.utils.AddressResolutionUtil;
import com.dtyunxi.tcbj.dao.das.SaleOrderDas;
import com.dtyunxi.tcbj.dao.eo.SaleOrderEo;
import com.dtyunxi.tcbj.dao.vo.SaleOrderRespVo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleOrderServiceImpl
implements ISaleOrderService {
    @Resource
    private SaleOrderDas saleOrderDas;

    @Override
    public Long addSaleOrder(SaleOrderReqDto addReqDto) {
        SaleOrderEo saleOrderEo = new SaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)saleOrderEo);
        this.saleOrderDas.insert((BaseEo)saleOrderEo);
        return saleOrderEo.getId();
    }

    @Override
    public void modifySaleOrder(SaleOrderReqDto modifyReqDto) {
        SaleOrderEo saleOrderEo = new SaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)saleOrderEo);
        this.saleOrderDas.updateSelective((BaseEo)saleOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSaleOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.saleOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SaleOrderRespDto queryById(Long id) {
        SaleOrderEo saleOrderEo = (SaleOrderEo)this.saleOrderDas.selectByPrimaryKey(id);
        SaleOrderRespDto saleOrderRespDto = new SaleOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)saleOrderEo, (BaseVo)saleOrderRespDto);
        return saleOrderRespDto;
    }

    @Override
    public PageInfo<SaleOrderRespDto> queryByPage(SaleOrderReqDto filter) {
        filter.setDetailAddress(AddressResolutionUtil.extractDetailAddress(filter.getDetailAddress()));
        Page saleOrderRespVos = this.saleOrderDas.queryByPage(filter);
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)saleOrderRespVos, (String[])new String[]{"list", "navigatepageNums"});
        List saleOrderRespVoList = saleOrderRespVos.getResult();
        if (CollectionUtils.isNotEmpty((Collection)saleOrderRespVoList)) {
            Map<Long, SaleOrderRespVo> saleOrderRespVoMap = saleOrderRespVoList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e, (a1, a2) -> a2));
            ArrayList respDto = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)respDto, (Collection)saleOrderRespVoList, SaleOrderRespDto.class);
            for (SaleOrderRespDto dto : respDto) {
                CommonAddrRespDto orderAddress = new CommonAddrRespDto();
                SaleOrderRespVo saleOrderRespVo = saleOrderRespVoMap.get(dto.getId());
                if (saleOrderRespVo != null) {
                    CubeBeanUtils.copyProperties((Object)orderAddress, (Object)saleOrderRespVo, (String[])new String[0]);
                }
                dto.setOrderAddress(orderAddress);
            }
            respDtoPageInfo.setList((List)respDto);
        }
        return respDtoPageInfo;
    }

    @Override
    public SaleOrderCountRespDto queryByCount(SaleOrderReqDto filter) {
        filter.setDetailAddress(AddressResolutionUtil.extractDetailAddress(filter.getDetailAddress()));
        return this.saleOrderDas.queryByCount(filter);
    }

    @Override
    public SaleOrderAmountDto queryAmountInfo(SaleOrderAmountReqDto filter) {
        return this.saleOrderDas.queryAmountInfo(filter);
    }

    @Override
    public Integer queryCountByCustomerId(String customerId) {
        return this.saleOrderDas.queryCountByCustomerId(customerId);
    }
}

