/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.ApportionTradeTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.CalculateStorageStatusEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.DeliveryResultOrderTypeEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.IsApportionEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.IsVerifyApportionEnum;
import com.dtyunxi.tcbj.api.dto.request.ApportionOrgReqDto;
import com.dtyunxi.tcbj.api.dto.request.DeliveryResultOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogicInventorySnapReqDto;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeApportionReqDto;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.TransferOrderReqDto;
import com.dtyunxi.tcbj.api.dto.response.DeliveryResultOrderDetailRespDto;
import com.dtyunxi.tcbj.api.dto.response.DeliveryResultOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeApportionRespDto;
import com.dtyunxi.tcbj.api.dto.response.StorageLogicInventoryRespDto;
import com.dtyunxi.tcbj.api.dto.response.TransferOrderRespDto;
import com.dtyunxi.tcbj.api.dto.storageCharge.SyncApportionDataDto;
import com.dtyunxi.tcbj.api.vo.LogicWarehouseReceiveRecordVo;
import com.dtyunxi.tcbj.biz.dto.ChargeApportionDateConfVo;
import com.dtyunxi.tcbj.biz.service.IDeliveryResultOrderService;
import com.dtyunxi.tcbj.biz.service.IStorageChargeApportionService;
import com.dtyunxi.tcbj.biz.service.IStorageChargeDetailService;
import com.dtyunxi.tcbj.biz.service.ITransferOrderService;
import com.dtyunxi.tcbj.biz.service.impl.StorageChargeHelper;
import com.dtyunxi.tcbj.biz.utils.DateUtils;
import com.dtyunxi.tcbj.dao.das.FinStorageContractDas;
import com.dtyunxi.tcbj.dao.das.LogicInventorySnapDas;
import com.dtyunxi.tcbj.dao.das.StorageChargeApportionDas;
import com.dtyunxi.tcbj.dao.das.StorageChargeApportionDetailDas;
import com.dtyunxi.tcbj.dao.eo.LogicInventorySnapEo;
import com.dtyunxi.tcbj.dao.eo.StorageChargeApportionDetailEo;
import com.dtyunxi.tcbj.dao.eo.StorageChargeApportionEo;
import com.dtyunxi.tcbj.dao.eo.StorageChargeDetailEo;
import com.dtyunxi.tcbj.dao.mapper.LogicInventorySnapMapper;
import com.dtyunxi.tcbj.dao.mapper.StorageChargeApportionMapper;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class StorageChargeApportionServiceImpl
implements IStorageChargeApportionService {
    private final Logger LOGGER = LoggerFactory.getLogger(IStorageChargeApportionService.class);
    private static final String CHARGE_APPORTION_DATE_CONF = "CHARGE_APPORTION_DATE_CONF";
    @Resource
    private StorageChargeApportionDas storageChargeApportionDas;
    @Resource
    private StorageChargeApportionDetailDas storageChargeApportionDetailDas;
    @Resource
    private StorageChargeApportionMapper storageChargeApportionMapper;
    @Resource
    private IStorageChargeDetailService storageChargeDetailService;
    @Resource
    private StorageChargeHelper storageChargeHelper;
    @Resource
    private ITransferOrderService transferOrderService;
    @Resource
    private IDeliveryResultOrderService deliveryResultOrderService;
    @Resource
    private IContext context;
    @Resource
    private FinStorageContractDas finStorageContractDas;
    @Autowired
    private IPcpDictApi pcpDictApi;
    @Resource
    private LogicInventorySnapMapper logicInventorySnapMapper;
    @Resource
    private LogicInventorySnapDas logicInventorySnapDas;

    @Override
    public Long addStorageChargeApportion(StorageChargeApportionReqDto addReqDto) {
        StorageChargeApportionEo storageChargeApportionEo = new StorageChargeApportionEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)storageChargeApportionEo);
        this.storageChargeApportionDas.insert((BaseEo)storageChargeApportionEo);
        return storageChargeApportionEo.getId();
    }

    @Override
    public void modifyStorageChargeApportion(StorageChargeApportionReqDto modifyReqDto) {
        StorageChargeApportionEo storageChargeApportionEo = new StorageChargeApportionEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)storageChargeApportionEo);
        this.storageChargeApportionDas.updateSelective((BaseEo)storageChargeApportionEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStorageChargeApportion(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.storageChargeApportionDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public StorageChargeApportionRespDto queryById(Long id) {
        StorageChargeApportionEo storageChargeApportionEo = (StorageChargeApportionEo)this.storageChargeApportionDas.selectByPrimaryKey(id);
        StorageChargeApportionRespDto storageChargeApportionRespDto = new StorageChargeApportionRespDto();
        DtoHelper.eo2Dto((BaseEo)storageChargeApportionEo, (BaseVo)storageChargeApportionRespDto);
        return storageChargeApportionRespDto;
    }

    @Override
    public PageInfo<StorageChargeApportionRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        StorageChargeApportionReqDto storageChargeApportionReqDto = (StorageChargeApportionReqDto)JSON.parseObject((String)filter, StorageChargeApportionReqDto.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!ObjectUtils.isEmpty((Object)storageChargeApportionReqDto.getStartRecordMonth()) && !ObjectUtils.isEmpty((Object)storageChargeApportionReqDto.getEndRecordMonth())) {
            queryWrapper.nested(all -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)all.nested(c -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)c.and(i -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.ge((Object)"start_record_month", (Object)storageChargeApportionReqDto.getStartRecordMonth())).le((Object)"end_record_month", (Object)storageChargeApportionReqDto.getEndRecordMonth());
                    });
                })).or()).nested(c -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)c.and(i -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.le((Object)"start_record_month", (Object)storageChargeApportionReqDto.getStartRecordMonth())).ge((Object)"end_record_month", (Object)storageChargeApportionReqDto.getStartRecordMonth());
                    });
                })).or()).nested(c -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)c.and(i -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.le((Object)"start_record_month", (Object)storageChargeApportionReqDto.getEndRecordMonth())).ge((Object)"end_record_month", (Object)storageChargeApportionReqDto.getEndRecordMonth());
                    });
                });
            });
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeApportionReqDto.getPhysicsWarehouseCode())) {
            queryWrapper.eq((Object)"physics_warehouse_code", (Object)storageChargeApportionReqDto.getPhysicsWarehouseCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)storageChargeApportionReqDto.getPhysicsWarehouseCodeList())) {
            queryWrapper.in((Object)"physics_warehouse_code", (Collection)storageChargeApportionReqDto.getPhysicsWarehouseCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeApportionReqDto.getOpLongCode())) {
            queryWrapper.like((Object)"op_long_code", (Object)("%" + storageChargeApportionReqDto.getOpLongCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeApportionReqDto.getItemName())) {
            queryWrapper.like((Object)"item_name", (Object)("%" + storageChargeApportionReqDto.getItemName() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeApportionReqDto.getBatch())) {
            queryWrapper.like((Object)"batch", (Object)("%" + storageChargeApportionReqDto.getBatch() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)storageChargeApportionReqDto.getBelongOrgName())) {
            queryWrapper.like((Object)"belong_org_name", (Object)("%" + storageChargeApportionReqDto.getBelongOrgName() + "%"));
        }
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"is_apportion", (Object)IsApportionEnum.NOT_APPORTION.getKey());
        queryWrapper.orderByDesc((Object)"create_time");
        IPage iPage = this.storageChargeApportionMapper.selectPage((IPage)new Page((long)pageNum.intValue(), (long)pageSize.intValue()), (Wrapper)queryWrapper);
        PageInfo dtoPageInfo = new PageInfo();
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)iPage.getRecords(), dtoList, StorageChargeApportionRespDto.class);
        dtoPageInfo.setList(dtoList);
        dtoPageInfo.setPageSize(Integer.parseInt(String.valueOf(iPage.getSize())));
        dtoPageInfo.setPageNum(Integer.parseInt(String.valueOf(iPage.getCurrent())));
        dtoPageInfo.setPages(Integer.parseInt(String.valueOf(iPage.getPages())));
        dtoPageInfo.setTotal(iPage.getTotal());
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncStorageChargeApportionData(Date recordDate) {
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.pcpDictApi.queryByCode(CHARGE_APPORTION_DATE_CONF));
        this.LOGGER.info("[\u4ed3\u50a8\u8d39\u7528\u5206\u644a\u62bd\u53d6\u6570\u636e],\u8bb0\u8d26\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4\u914d\u7f6e:{}", (Object)JSON.toJSONString((Object)dictDto));
        if (dictDto == null || StringUtils.isBlank((CharSequence)dictDto.getValue())) {
            this.LOGGER.info("[\u4ed3\u50a8\u8d39\u7528\u5206\u644a\u62bd\u53d6\u6570\u636e],\u4ed3\u50a8\u5206\u644a\u660e\u7ec6\uff0c\u8bb0\u8d26\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4\u914d\u7f6e\u4e3a\u7a7a");
            return;
        }
        ChargeApportionDateConfVo vo = (ChargeApportionDateConfVo)((Object)JSON.parseObject((String)dictDto.getValue(), ChargeApportionDateConfVo.class));
        Date apportionEndTime = DateUtil.addDays((Date)recordDate, (int)vo.getEndDay());
        Date apportionStartTime = DateUtil.addDays((Date)recordDate, (int)vo.getStartDay());
        this.LOGGER.info("\u83b7\u53d6\u5f53\u524d\u5468\u671f\u533a\u95f4 apportionStartTime:{} apportionEndTime:{} ", (Object)DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)apportionStartTime), (Object)DateUtil.formatDate((DatePattern)DatePattern.DATE_PATTERN, (Date)apportionEndTime));
        SyncApportionDataDto deliveryResultDto = new SyncApportionDataDto(apportionStartTime, Arrays.asList(this.storageChargeHelper.getPropertyRightOrganizationIds().split(",")), Arrays.asList(this.storageChargeHelper.getPhysicsWarehouseCodes().split(",")));
        this.LOGGER.info("\u83b7\u53d6\u5f53\u524d\u5468\u671f\u5165\u5e93\u7ed3\u679c\u5355 params:{}", (Object)JSON.toJSONString((Object)deliveryResultDto));
        List<LogicWarehouseReceiveRecordVo> logicWarehouseApportionRecordList = this.storageChargeApportionMapper.queryLogicWarehouseReceiveRecord(deliveryResultDto);
        if (CollectionUtils.isEmpty((Collection)logicWarehouseApportionRecordList)) {
            return;
        }
        if (CollectionUtils.isEmpty(logicWarehouseApportionRecordList = this.filterData(logicWarehouseApportionRecordList))) {
            return;
        }
        List itemCodes = logicWarehouseApportionRecordList.stream().map(c -> c.getOpLongCode()).distinct().collect(Collectors.toList());
        List batchs = logicWarehouseApportionRecordList.stream().map(c -> c.getBatch()).distinct().collect(Collectors.toList());
        SyncApportionDataDto deliveryResultAllDto = new SyncApportionDataDto(DateUtil.addDays((Date)apportionStartTime, (int)1), apportionEndTime, itemCodes, batchs, Arrays.asList(this.storageChargeHelper.getPropertyRightOrganizationIds().split(",")), Arrays.asList(this.storageChargeHelper.getPhysicsWarehouseCodes().split(",")));
        List logicWarehouseReceiveRecordList = this.storageChargeApportionMapper.queryLogicWarehouseReceiveRecord(deliveryResultAllDto);
        SyncApportionDataDto inventoryDto = new SyncApportionDataDto(itemCodes, batchs, Arrays.asList(this.storageChargeHelper.getPropertyRightOrganizationIds().split(",")), Arrays.asList(this.storageChargeHelper.getPhysicsWarehouseCodes().split(",")));
        inventoryDto.setStatisticalTime(apportionEndTime);
        List storageLogicInventoryRespDtos = this.storageChargeApportionMapper.queryLogicInventoryBySnap(inventoryDto);
        if (CollectionUtils.isEmpty((Collection)storageLogicInventoryRespDtos)) {
            this.LOGGER.info("\u4ed3\u50a8\u5feb\u7167\u4e2d\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u5e93\u5b58\u5feb\u7167\uff0c\u5219\u5546\u54c1\u5e93\u5b58\u4e3a0 \uff01\uff01\uff01");
            return;
        }
        List<StorageChargeApportionEo> storageChargeApportionEos = this.calculateApportionList(apportionEndTime, apportionStartTime, logicWarehouseApportionRecordList, logicWarehouseReceiveRecordList, storageLogicInventoryRespDtos);
        int result = this.storageChargeApportionDas.insertBatch(storageChargeApportionEos);
        Assert.isTrue((result > 0 ? 1 : 0) != 0, (String)"0001", (String)"\u6279\u91cf\u63d2\u5165\u5206\u644a\u6570\u636e\u5931\u8d25\uff01\uff01\uff01");
    }

    private List<LogicWarehouseReceiveRecordVo> filterData(List<LogicWarehouseReceiveRecordVo> list) {
        ArrayList vos = Lists.newArrayList();
        list.forEach(i -> {
            String physicsWarehouseCode = i.getPhysicsWarehouseCode();
            if (StringUtils.isBlank((CharSequence)physicsWarehouseCode)) {
                return;
            }
            Date inDeliveryTime = i.getInDeliveryTime();
            Integer count = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.finStorageContractDas.filter().eq((Object)"is_cancel", (Object)0)).ne((Object)"charge_mode", (Object)1)).eq((Object)"warehouse_code", (Object)physicsWarehouseCode)).last(String.format(" and '%s' %s", DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)inDeliveryTime), "BETWEEN  valid_start_time and valid_end_time"))).count();
            if (count > 0) {
                return;
            }
            vos.add(i);
        });
        return vos;
    }

    private List<StorageChargeApportionEo> calculateApportionList(Date apportionEndTime, Date apportionStartTime, List<LogicWarehouseReceiveRecordVo> logicWarehouseApportionRecordList, List<LogicWarehouseReceiveRecordVo> logicWarehouseReceiveRecordVoList, List<StorageLogicInventoryRespDto> storageLogicInventoryRespDtos) {
        Map<Long, List<LogicWarehouseReceiveRecordVo>> apportionReceiveRecordMap = logicWarehouseApportionRecordList.stream().collect(Collectors.groupingBy(c -> c.getBelongOrgId()));
        Map<Long, List<LogicWarehouseReceiveRecordVo>> receiveRecordMap = logicWarehouseReceiveRecordVoList.stream().collect(Collectors.groupingBy(c -> c.getBelongOrgId()));
        Map<Long, List<StorageLogicInventoryRespDto>> logicInventoryRespDtoMap = storageLogicInventoryRespDtos.stream().collect(Collectors.groupingBy(c -> c.getBelongOrgId()));
        ArrayList resultList = Lists.newArrayList();
        apportionReceiveRecordMap.forEach((k, v) -> {
            Map<String, List<LogicWarehouseReceiveRecordVo>> apportionReceiveMap = v.stream().collect(Collectors.groupingBy(c -> c.getPhysicsWarehouseCode() + c.getLogicWarehouseCode() + c.getOpLongCode() + c.getBatch()));
            Map<String, List<LogicWarehouseReceiveRecordVo>> collect = ((List)receiveRecordMap.getOrDefault(k, Lists.newArrayList())).stream().collect(Collectors.groupingBy(c -> c.getPhysicsWarehouseCode() + c.getLogicWarehouseCode() + c.getOpLongCode() + c.getBatch()));
            Map<String, StorageLogicInventoryRespDto> logicInventoryMap = ((List)logicInventoryRespDtoMap.getOrDefault(k, Lists.newArrayList())).stream().collect(Collectors.toMap(k1 -> k1.getPhysicsWarehouseCode() + k1.getLogicWarehouseCode() + k1.getOpLongCode() + k1.getBatch(), val1 -> val1, (k1, k2) -> k2));
            logicInventoryMap.forEach((key, val) -> {
                if (apportionReceiveMap.keySet().contains(key)) {
                    int sum = ((List)apportionReceiveMap.get(key)).stream().mapToInt(c -> c.getInventoryNum()).sum();
                    List orDefault = collect.getOrDefault(key, Lists.newArrayList());
                    int receiveSum = orDefault.stream().mapToInt(c -> c.getInventoryNum()).sum();
                    int result = val.getInventoryNum() - receiveSum;
                    this.LOGGER.info("\u5904\u7406\u7269\u7406\u4ed3\u3010{}\u3011=> \u903b\u8f91\u4ed3\u3010{}\u3011 => \u5546\u54c1\u7f16\u7801\u3010{}\u3011 => \u6279\u6b21\u3010{}\u3011=> \u5373\u65f6\u5e93\u5b58\u5feb\u7167\uff1a{} \u8fd1\u5341\u56db\u5929\u5165\u5e93\u603b\u6570\uff1a{} \u7b2c\u524d\u5341\u4e94\u5929\u5165\u5e93\u603b\u6570\uff1a{} ", new Object[]{val.getPhysicsWarehouseCode(), val.getLogicWarehouseCode(), val.getOpLongCode(), val.getBatch(), val.getInventoryNum(), receiveSum, sum});
                    if (result > 0) {
                        if (sum - result > 0) {
                            resultList.add(this.createStorageChargeApportion(apportionEndTime, apportionStartTime, (StorageLogicInventoryRespDto)val, result));
                        } else {
                            resultList.add(this.createStorageChargeApportion(apportionEndTime, apportionStartTime, (StorageLogicInventoryRespDto)val, sum));
                        }
                    }
                }
            });
        });
        return resultList;
    }

    private StorageChargeApportionEo createStorageChargeApportion(Date apportionEndTime, Date apportionStartTime, StorageLogicInventoryRespDto val, int result) {
        StorageChargeApportionEo storageChargeApportionEo = new StorageChargeApportionEo(apportionStartTime, apportionEndTime, val.getPhysicsWarehouseCode(), val.getPhysicsWarehouseName(), val.getLogicWarehouseCode(), val.getLogicWarehouseName(), val.getOpLongCode(), val.getItemName(), val.getBatch(), Integer.valueOf(result), val.getZhTrayNum(), val.getBigRatio(), val.getVolume(), StorageChargeHelper.getSupport(result, val.getBigRatio(), val.getZhTrayNum()), val.getInDeliveryTime(), val.getBelongOrgId(), val.getBelongOrgName(), null);
        return storageChargeApportionEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertBatch(List<StorageChargeApportionEo> storageChargeApportionEos) {
        if (CollectionUtils.isNotEmpty(storageChargeApportionEos)) {
            int result = this.storageChargeApportionDas.insertBatch(storageChargeApportionEos);
            Assert.isTrue((result > 0 ? 1 : 0) != 0, (String)"0001", (String)"\u6279\u91cf\u5206\u644a\u6570\u636e\u5931\u8d25");
        }
    }

    @Override
    public List<StorageChargeApportionRespDto> queryStorageChargeApportionList(StorageChargeApportionReqDto storageChargeApportionReqDto) {
        StorageChargeApportionEo storageChargeApportionEo = new StorageChargeApportionEo();
        DtoHelper.dto2Eo((BaseVo)storageChargeApportionReqDto, (BaseEo)storageChargeApportionEo);
        storageChargeApportionEo.setOrderByDesc("in_delivery_time");
        this.LOGGER.info("queryStorageChargeApportionList\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)storageChargeApportionEo));
        List storageChargeApportion = this.storageChargeApportionDas.select((BaseEo)storageChargeApportionEo);
        ArrayList dtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)storageChargeApportion, (Collection)dtoList, StorageChargeApportionRespDto.class);
        return dtoList;
    }

    @Override
    public List<StorageChargeApportionReqDto> verifyStorageChargeApportion(Date dateTime) {
        StorageChargeApportionReqDto storageChargeApportionReqDto = new StorageChargeApportionReqDto();
        storageChargeApportionReqDto.setEndRecordMonth(DateUtil.addDays((Date)dateTime, (int)-16));
        storageChargeApportionReqDto.setIsVerify(IsVerifyApportionEnum.IS_VERIFY.getKey());
        List<StorageChargeApportionRespDto> dtoList = this.queryStorageChargeApportionList(storageChargeApportionReqDto);
        ArrayList resultList = Lists.newArrayList();
        List<String> tradeOrderTypes = Arrays.asList(this.storageChargeHelper.getTransferOrderTypes().split(","));
        this.LOGGER.info("\u8c03\u62e8\u5355\u7c7b\u578b\uff1a{} => \u5185\u90e8\u4ea4\u6613\u8ba2\u5355", (Object)JSON.toJSONString(tradeOrderTypes));
        for (StorageChargeApportionRespDto c : dtoList) {
            BigDecimal reduce = this.verifyApportion(DateUtil.addDays((Date)c.getEndRecordMonth(), (int)1), DateUtil.addDays((Date)dateTime, (int)-1), tradeOrderTypes, c, IsVerifyApportionEnum.IS_VERIFY);
            if (reduce.compareTo(BigDecimal.ZERO) <= 0) continue;
            StorageChargeApportionReqDto target = new StorageChargeApportionReqDto();
            CubeBeanUtils.copyProperties((Object)target, (Object)c, (String[])new String[0]);
            target.setId(null);
            target.setStartRecordMonth(DateUtil.addDays((Date)c.getEndRecordMonth(), (int)1));
            target.setEndRecordMonth(DateUtil.addDays((Date)dateTime, (int)-1));
            target.setInventoryNum(Integer.valueOf(reduce.intValue()));
            resultList.add(target);
        }
        return resultList;
    }

    @Override
    public List<StorageChargeApportionReqDto> queryTimeRangeStorageChargeApportion(Date startDate, Date endDate) {
        this.LOGGER.info("\u83b7\u53d6\u67d0\u65f6\u95f4\u8303\u56f4\u5185\u5f85\u4ed3\u50a8\u5206\u644a\u7684\u6570\u636e\uff1a{}\uff0c{}", (Object)startDate.toString(), (Object)endDate.toString());
        List<String> orgIds = Arrays.asList(this.storageChargeHelper.getPropertyRightOrganizationIds().split(","));
        List storageChargeApportionReqList = this.logicInventorySnapMapper.queryTimeRangeStorageChargeApportion(startDate, endDate, orgIds);
        ArrayList<StorageChargeApportionReqDto> reqDtoList = new ArrayList<StorageChargeApportionReqDto>();
        if (CollectionUtils.isNotEmpty((Collection)storageChargeApportionReqList)) {
            this.LOGGER.info("\u5206\u644a\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)storageChargeApportionReqList));
            storageChargeApportionReqList.forEach(s -> {
                if (s.getBigRatio() != null && s.getZhTrayNum() != null && s.getBigRatio() > 0 && s.getZhTrayNum() > 0 && s.getInventoryNum() > 0) {
                    int i = new BigDecimal(s.getInventoryNum()).divide(new BigDecimal(s.getZhTrayNum()).multiply(new BigDecimal(s.getBigRatio())), RoundingMode.HALF_UP).intValue();
                    s.setSupport(Integer.valueOf(i));
                }
                this.splitConsecutiveDate((StorageChargeApportionReqDto)s).forEach(split -> {
                    StorageChargeApportionReqDto dto = new StorageChargeApportionReqDto();
                    BeanUtils.copyProperties((Object)s, (Object)dto);
                    dto.setStartRecordMonth(split.getStartRecordMonth());
                    dto.setEndRecordMonth(split.getEndRecordMonth());
                    reqDtoList.add(dto);
                });
            });
        }
        return reqDtoList;
    }

    private List<StorageChargeApportionReqDto> splitConsecutiveDate(StorageChargeApportionReqDto reqDto) {
        this.LOGGER.info("\u62c6\u5206\u975e\u8fde\u7eed\u65e5\u671f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        ArrayList<StorageChargeApportionReqDto> resultList = new ArrayList<StorageChargeApportionReqDto>();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String[] dateList = reqDto.getRecordMonthStr().split(",");
            if (dateList.length == 1) {
                resultList.add(reqDto);
                this.LOGGER.info("\u62c6\u5206\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(resultList));
                return resultList;
            }
            Date start = null;
            Date end = null;
            for (String date : dateList) {
                if (ObjectUtils.isEmpty(start)) {
                    start = sdf.parse(date);
                    end = sdf.parse(date);
                    continue;
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime(end);
                cal.add(5, 1);
                if (cal.getTime().getTime() == sdf.parse(date).getTime()) {
                    end = sdf.parse(date);
                    continue;
                }
                StorageChargeApportionReqDto dto = new StorageChargeApportionReqDto();
                dto.setStartRecordMonth(start);
                dto.setEndRecordMonth(end);
                resultList.add(dto);
                start = sdf.parse(date);
                end = sdf.parse(date);
            }
            StorageChargeApportionReqDto dto = new StorageChargeApportionReqDto();
            dto.setStartRecordMonth(start);
            dto.setEndRecordMonth(end);
            resultList.add(dto);
        }
        catch (Exception e) {
            this.LOGGER.error("\u62c6\u5206\u975e\u8fde\u7eed\u65e5\u671f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            this.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        this.LOGGER.info("\u62c6\u5206\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(resultList));
        return resultList;
    }

    @Override
    public BigDecimal verifyApportion(Date outStartTime, Date outEndTime, List<String> tradeOrderTypes, StorageChargeApportionRespDto c, IsVerifyApportionEnum isVerifyApportionEnum) {
        TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
        transferOrderReqDto.setOutStartTime(outStartTime);
        transferOrderReqDto.setOutEndTime(outEndTime);
        transferOrderReqDto.setOutLogicWarehouseCode(c.getLogicWarehouseCode());
        transferOrderReqDto.setOutOrganizationId(c.getBelongOrgId());
        List<TransferOrderRespDto> transferOrderRespDtos = this.transferOrderService.queryByTransferOrderReqDto(transferOrderReqDto);
        BigDecimal inventoryNum = new BigDecimal(c.getInventoryNum());
        if (CollectionUtils.isEmpty(transferOrderRespDtos)) {
            return inventoryNum;
        }
        List collect = transferOrderRespDtos.stream().filter(dto -> tradeOrderTypes.contains(dto.getType()) && dto.getOrderStatus().equals("finish")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            Map<String, List<DeliveryResultOrderDetailRespDto>> detailMap;
            List orDefault;
            DeliveryResultOrderReqDto deliveryResultOrderReqDto = new DeliveryResultOrderReqDto();
            deliveryResultOrderReqDto.setOrderType(DeliveryResultOrderTypeEnum.DELIVERY.getKey());
            deliveryResultOrderReqDto.setRelevanceNos(collect.stream().map(transferOrderRespDto -> transferOrderRespDto.getTransferOrderNo()).collect(Collectors.toList()));
            List<DeliveryResultOrderRespDto> deliveryResultOrderRespDtos = this.deliveryResultOrderService.queryDeliveryResultOrder(deliveryResultOrderReqDto);
            List deliveryResultOrderDetailRespDtos = deliveryResultOrderRespDtos.stream().map(deliveryResultOrderRespDto -> deliveryResultOrderRespDto.getResultOrderDetailRespDtoList()).flatMap(Collection::stream).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(deliveryResultOrderDetailRespDtos) && !CollectionUtils.isEmpty((Collection)(orDefault = (List)(detailMap = deliveryResultOrderDetailRespDtos.stream().collect(Collectors.groupingBy(detail -> detail.getBatch() + detail.getSkuCode()))).getOrDefault(c.getBatch() + c.getOpLongCode(), null)))) {
                BigDecimal reduce = orDefault.stream().map(detail -> detail.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add);
                inventoryNum = inventoryNum.subtract(reduce);
            }
        }
        if (isVerifyApportionEnum.equals((Object)IsVerifyApportionEnum.IS_VERIFY)) {
            StorageChargeApportionEo storageChargeApportion = new StorageChargeApportionEo();
            CubeBeanUtils.copyProperties((Object)storageChargeApportion, (Object)c, (String[])new String[0]);
            storageChargeApportion.setIsVerify(IsVerifyApportionEnum.NOT_VERIFY.getKey());
            int updateResult = this.storageChargeApportionDas.update((BaseEo)storageChargeApportion);
            Assert.isTrue((updateResult > 0 ? 1 : 0) != 0, (String)"0002", (String)"\u6279\u91cf\u4fee\u6539\u5206\u644a\u6570\u636e\u5931\u8d25");
        }
        return inventoryNum;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void storageChargeApportion(StorageChargeApportionReqDto storageChargeApportionReqDto) {
        this.LOGGER.info("\u4ed3\u50a8\u8d27\u6743\u5206\u644a params:{}", (Object)JSON.toJSONString((Object)storageChargeApportionReqDto));
        if (ObjectUtils.isEmpty((Object)storageChargeApportionReqDto.getId())) {
            throw new BizException("-1", "\u8bf7\u6c42ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StorageChargeApportionEo storageChargeApportionEo = (StorageChargeApportionEo)this.storageChargeApportionDas.selectByPrimaryKey(storageChargeApportionReqDto.getId());
        storageChargeApportionReqDto.setOpLongCode(storageChargeApportionEo.getOpLongCode());
        storageChargeApportionReqDto.setBatch(storageChargeApportionEo.getBatch());
        storageChargeApportionReqDto.setBelongOrgId(storageChargeApportionEo.getBelongOrgId());
        storageChargeApportionReqDto.setBelongOrgName(storageChargeApportionEo.getBelongOrgName());
        storageChargeApportionReqDto.setPhysicsWarehouseCode(storageChargeApportionEo.getPhysicsWarehouseCode());
        storageChargeApportionReqDto.setPhysicsWarehouseName(storageChargeApportionEo.getPhysicsWarehouseName());
        storageChargeApportionReqDto.setStartRecordMonth(storageChargeApportionEo.getStartRecordMonth());
        storageChargeApportionReqDto.setEndRecordMonth(storageChargeApportionEo.getEndRecordMonth());
        storageChargeApportionReqDto.setSupport(storageChargeApportionEo.getSupport());
        storageChargeApportionReqDto.setInventoryNum(storageChargeApportionEo.getInventoryNum());
        this.verifyParams(storageChargeApportionReqDto);
        StorageChargeApportionEo storageChargeApportion = this.queryStorageChargeApportion(storageChargeApportionReqDto);
        if (Objects.equals(IsApportionEnum.IS_APPORTION.getKey(), storageChargeApportion.getIsApportion())) {
            throw new BizException("\u5206\u644a\u6570\u636e\u5df2\u5b8c\u6210\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c");
        }
        List<StorageChargeApportionDetailEo> apportionDetailEos = this.buildApportionDetail(this.context.userName(), storageChargeApportionReqDto, storageChargeApportion);
        int result = this.storageChargeApportionDetailDas.insertBatch(apportionDetailEos);
        Assert.isTrue((result > 0 ? 1 : 0) != 0, (String)"0002", (String)"\u6279\u91cf\u63d2\u5165\u5206\u644a\u660e\u7ec6\u5931\u8d25");
        storageChargeApportion.setIsApportion(IsApportionEnum.IS_APPORTION.getKey());
        int updateResult = this.storageChargeApportionDas.update((BaseEo)storageChargeApportion);
        Assert.isTrue((updateResult > 0 ? 1 : 0) != 0, (String)"0002", (String)"\u6279\u91cf\u4fee\u6539\u5206\u644a\u6570\u636e\u5931\u8d25");
        List<StorageChargeDetailEo> storageChargeDetailEos = apportionDetailEos.stream().map(c -> this.buildStorageDetail(DateUtil.parseDate((String)storageChargeApportionReqDto.getBillTime(), (String)"yyyy-MM"), (StorageChargeApportionDetailEo)c, storageChargeApportion.getEndRecordMonth(), storageChargeApportion.getStartRecordMonth())).flatMap(Collection::stream).collect(Collectors.toList());
        this.storageChargeDetailService.insertBatch(storageChargeDetailEos);
        StorageChargeDetailReqDto reqDto = new StorageChargeDetailReqDto();
        reqDto.setWarehouseCode(storageChargeApportionEo.getPhysicsWarehouseCode());
        reqDto.setOpLongCode(storageChargeApportionEo.getOpLongCode());
        reqDto.setBatch(storageChargeApportionEo.getBatch());
        reqDto.setStorageStartTime(storageChargeApportionEo.getStartRecordMonth());
        reqDto.setStorageEndTime(storageChargeApportionEo.getEndRecordMonth());
        this.storageChargeDetailService.updateStorageDetailSupport(reqDto);
    }

    private List<StorageChargeDetailEo> buildStorageDetail(Date billTime, StorageChargeApportionDetailEo apportionDetailEos, Date endRecordMonth, Date startRecordMonth) {
        this.LOGGER.info("\u751f\u6210\u4ed3\u50a8\u660e\u7ec6buildStorageDetail\uff1a{}\uff0c{}\uff0c{}", new Object[]{JSON.toJSONString((Object)apportionDetailEos), startRecordMonth, endRecordMonth});
        ArrayList storageChargeDetailList = Lists.newArrayList();
        LogicInventorySnapReqDto reqDto = new LogicInventorySnapReqDto();
        reqDto.setLongCode(apportionDetailEos.getOpLongCode());
        reqDto.setBatch(apportionDetailEos.getBatch());
        reqDto.setWarehouseCode(apportionDetailEos.getApportionLogicWarehouseCode());
        reqDto.setStatisticalTimeStarter(startRecordMonth.toString());
        reqDto.setStatisticalTimeEnd(endRecordMonth.toString());
        this.LOGGER.info("buildStorageDetail\u83b7\u53d6\u5e93\u5b58\u5feb\u7167\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List logicInventorySnapEos = this.logicInventorySnapDas.queryListExt(reqDto);
        Map<Object, Object> logicInventorySnapMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)logicInventorySnapEos)) {
            logicInventorySnapMap = logicInventorySnapEos.stream().collect(Collectors.toMap(LogicInventorySnapEo::getStatisticalTime, Function.identity(), (k1, k2) -> k1));
        }
        this.LOGGER.info("buildStorageDetail\u83b7\u53d6\u5e93\u5b58\u5feb\u7167\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(logicInventorySnapMap));
        while (startRecordMonth.getTime() <= endRecordMonth.getTime()) {
            this.LOGGER.info("\u5904\u7406\u5929\u6570\uff1a{}", (Object)JSON.toJSONString((Object)startRecordMonth));
            HashSet<String> exceptionInfoSet = StorageChargeHelper.verifyStorageDetailException(apportionDetailEos.getZhTrayNum(), apportionDetailEos.getVolume(), apportionDetailEos.getBigRatio());
            LogicInventorySnapEo logicInventorySnapEo = (LogicInventorySnapEo)logicInventorySnapMap.get(startRecordMonth);
            if (ObjectUtils.isEmpty((Object)logicInventorySnapEo)) {
                logicInventorySnapEo = new LogicInventorySnapEo();
            }
            this.LOGGER.info("\u5bf9\u5e94\u5feb\u7167\uff1a{}", (Object)JSON.toJSONString((Object)logicInventorySnapEo));
            BigDecimal organizationSupport = BigDecimal.ZERO;
            if (!ObjectUtils.isEmpty((Object)logicInventorySnapEo.getDayTotalBoard()) && !ObjectUtils.isEmpty((Object)logicInventorySnapEo.getDayTotalBalance())) {
                BigDecimal divide = new BigDecimal(apportionDetailEos.getApportionNum()).divide(logicInventorySnapEo.getDayTotalBalance(), 0, 4);
                organizationSupport = divide.multiply(new BigDecimal(logicInventorySnapEo.getDayTotalBoard()));
            }
            StorageChargeDetailEo storageChargeDetailEo = new StorageChargeDetailEo(startRecordMonth, billTime, apportionDetailEos.getWarehouseCode(), apportionDetailEos.getWarehouseName(), apportionDetailEos.getOpLongCode(), apportionDetailEos.getItemName(), apportionDetailEos.getBatch(), apportionDetailEos.getApportionLogicWarehouseCode(), apportionDetailEos.getApportionLogicWarehouseName(), apportionDetailEos.getBelongOrgId(), apportionDetailEos.getBelongOrgName(), apportionDetailEos.getApportionOrgId(), apportionDetailEos.getApportionOrgName(), ApportionTradeTypeEnum.APPORTION_TRADE.getKey(), apportionDetailEos.getZhTrayNum(), apportionDetailEos.getBigRatio(), organizationSupport, apportionDetailEos.getApportionNum(), logicInventorySnapEo.getDayTotalBoard(), Integer.valueOf(apportionDetailEos.getApportionSupport().setScale(0, 0).intValue()), apportionDetailEos.getApportionNum(), JSON.toJSONString(exceptionInfoSet), CalculateStorageStatusEnum.UN_FINISH.getKey());
            storageChargeDetailList.add(storageChargeDetailEo);
            startRecordMonth = DateUtil.addDays((Date)startRecordMonth, (int)1);
        }
        return storageChargeDetailList;
    }

    private void verifyParams(StorageChargeApportionReqDto storageChargeApportionReqDto) {
        Assert.notNull((Object)storageChargeApportionReqDto.getStartRecordMonth(), (String)"0001", (String)"\u5206\u644a\u65f6\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)storageChargeApportionReqDto.getEndRecordMonth(), (String)"0001", (String)"\u5206\u644a\u65f6\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)storageChargeApportionReqDto.getPhysicsWarehouseCode(), (String)"0001", (String)"\u7269\u7406\u4ed3\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)storageChargeApportionReqDto.getOpLongCode(), (String)"0001", (String)"\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)storageChargeApportionReqDto.getBatch(), (String)"0001", (String)"\u5546\u54c1\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)storageChargeApportionReqDto.getBelongOrgId(), (String)"0001", (String)"\u8d27\u54c1\u5f52\u5c5e\u6743\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)storageChargeApportionReqDto.getApportionOrgReqDtoList(), (String)"0001", (String)"\u5206\u644a\u5e93\u5b58\u7ec4\u7ec7\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)storageChargeApportionReqDto.getBillTime(), (String)"0001", (String)"\u8d26\u5355\u7edf\u8ba1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        int sum = storageChargeApportionReqDto.getApportionOrgReqDtoList().stream().mapToInt(ApportionOrgReqDto::getApportionNum).sum();
        Assert.isTrue((sum == storageChargeApportionReqDto.getInventoryNum() ? 1 : 0) != 0, (String)"0001", (String)"\u5206\u644a\u6570\u91cf\u4e0d\u76f8\u7b49");
    }

    private StorageChargeApportionEo queryStorageChargeApportion(StorageChargeApportionReqDto storageChargeApportionReqDto) {
        StorageChargeApportionEo storageChargeApportionEo = new StorageChargeApportionEo();
        DtoHelper.dto2Eo((BaseVo)storageChargeApportionReqDto, (BaseEo)storageChargeApportionEo);
        storageChargeApportionEo.setBelongOrgName("");
        StorageChargeApportionEo storageChargeApportion = (StorageChargeApportionEo)this.storageChargeApportionDas.selectOne((BaseEo)storageChargeApportionEo);
        this.verifyApportion(storageChargeApportion);
        return storageChargeApportion;
    }

    private List<StorageChargeApportionDetailEo> buildApportionDetail(String apportionOperator, StorageChargeApportionReqDto storageChargeApportionReqDto, StorageChargeApportionEo storageChargeApportionEo) {
        List<StorageChargeApportionDetailEo> collect = storageChargeApportionReqDto.getApportionOrgReqDtoList().stream().map(apportion -> {
            StorageChargeApportionDetailEo storageChargeApportionDetailEo = new StorageChargeApportionDetailEo(DateUtils.getMaxMonthDate(DateUtil.parseDate((String)storageChargeApportionReqDto.getBillTime(), (String)"yyyy-MM")), DateUtil.parseDate((String)storageChargeApportionReqDto.getBillTime(), (String)"yyyy-MM"), storageChargeApportionEo.getPhysicsWarehouseCode(), storageChargeApportionEo.getPhysicsWarehouseName(), storageChargeApportionEo.getOpLongCode(), storageChargeApportionEo.getItemName(), storageChargeApportionEo.getBatch(), storageChargeApportionReqDto.getStartRecordMonth(), storageChargeApportionReqDto.getEndRecordMonth(), storageChargeApportionEo.getInventoryNum(), apportion.getApportionNum(), BigDecimal.ZERO, storageChargeApportionReqDto.getBelongOrgId(), storageChargeApportionReqDto.getBelongOrgName(), apportion.getLogicWarehouseCode(), apportion.getLogicWarehouseName(), apportionOperator, storageChargeApportionEo.getBigRatio(), storageChargeApportionEo.getZhTrayNum(), storageChargeApportionEo.getVolume(), apportion.getApportionOrgId(), apportion.getApportionOrgName());
            storageChargeApportionDetailEo.setApportionId(storageChargeApportionDetailEo.getApportionId());
            return storageChargeApportionDetailEo;
        }).collect(Collectors.toList());
        this.calculateSupport(storageChargeApportionEo, collect);
        return collect;
    }

    private void calculateSupport(StorageChargeApportionEo storageChargeApportionEo, List<StorageChargeApportionDetailEo> collect) {
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal inventoryNum = new BigDecimal(storageChargeApportionEo.getInventoryNum());
        BigDecimal support = new BigDecimal(storageChargeApportionEo.getSupport());
        for (int i = 0; i < collect.size(); ++i) {
            StorageChargeApportionDetailEo storageChargeApportionDetailEo = collect.get(i);
            if (i != collect.size() - 1) {
                BigDecimal apportionNum = new BigDecimal(storageChargeApportionDetailEo.getApportionNum());
                BigDecimal apportionSupport = apportionNum.divide(inventoryNum.multiply(support), 6, 1);
                total = total.add(apportionSupport);
                storageChargeApportionDetailEo.setApportionSupport(apportionSupport);
                continue;
            }
            storageChargeApportionDetailEo.setApportionSupport(support.subtract(total));
        }
    }

    private void verifyApportion(StorageChargeApportionEo storageChargeApportion) {
        Assert.notNull((Object)storageChargeApportion, (String)"0001", (String)"\u5f53\u524d\u5206\u644a\u65f6\u95f4\u6bb5\u4e0d\u5b58\u5728\u5206\u644a\u6570\u636e\uff01\uff01\uff01");
    }
}

