/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.constant.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.CsLogicWarehouseQualityEnum;
import com.dtyunxi.tcbj.api.dto.constant.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.tcbj.api.dto.request.InventoryComparisonReportAddReqDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryComparisonReqDto;
import com.dtyunxi.tcbj.api.dto.response.InventoryComparisonReportRespDto;
import com.dtyunxi.tcbj.biz.service.IInventoryComparisonReportService;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalOutQimenWmsApi;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.InventoryQueryRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.response.InventoryQueryResponseDto;
import com.dtyunxi.tcbj.dao.das.InventoryComparisonReportDas;
import com.dtyunxi.tcbj.dao.das.WmsBalanceReportDas;
import com.dtyunxi.tcbj.dao.eo.InventoryComparisonReportEo;
import com.dtyunxi.tcbj.dao.eo.WmsBalanceReportEo;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.enums.DictEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.qimen.api.request.InventoryQueryRequest;
import com.qimen.api.response.InventoryQueryResponse;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class InventoryComparisonReportServiceImpl
implements IInventoryComparisonReportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryComparisonReportServiceImpl.class);
    @Resource
    private InventoryComparisonReportDas inventoryComparisonReportDas;
    @Resource
    private WmsBalanceReportDas wmsBalanceReportDas;
    @Resource
    private IExternalOutQimenWmsApi externalOutQimenWmsApi;
    @Resource
    private IPcpDictApi pcpDictApi;

    @Override
    public PageInfo<InventoryComparisonReportRespDto> queryInventoryReportComparisonReport(InventoryComparisonReqDto dto) {
        DictDto dictDto1;
        List codes;
        LOGGER.info("\u5e93\u5b58\u5bf9\u6bd4\u660e\u7ec6\u62a5\u8868\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (!ObjectUtils.isEmpty((Object)dto.getLogicalWarehouseFilter()) && dto.getLogicalWarehouseFilter() == 1 && !CollectionUtil.isEmpty((Collection)(codes = JSON.parseArray((String)(dictDto1 = (DictDto)RestResponseHelper.extractData((RestResponse)this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", DictEnum.LOGICAL_WAREHOUSE_FILTER.getCode()))).getValue(), String.class)))) {
            dto.setLogicalWarehouseCodeList(codes);
        }
        PageInfo pageInfo = this.inventoryComparisonReportDas.queryInventoryReportComparisonReport(dto);
        List dtoList = pageInfo.getList();
        dtoList.forEach(o -> {
            if (StringUtils.isNotBlank((CharSequence)o.getWarehouseClassify())) {
                o.setWarehouseClassifyName(Optional.ofNullable(CsWarehouseClassifyEnum.getDescByCode((String)o.getWarehouseClassify())).orElse(o.getWarehouseClassify()));
            }
            if (StringUtils.isNotBlank((CharSequence)o.getWarehouseQuality())) {
                o.setWarehouseQualityName(Optional.ofNullable(CsLogicWarehouseQualityEnum.getDescByCode((String)o.getWarehouseQuality())).orElse(o.getWarehouseQuality()));
            }
        });
        if (!ObjectUtils.isEmpty((Object)dto.getLogicalWarehouseFilter()) && dto.getLogicalWarehouseFilter() == 1) {
            dtoList.forEach(o -> {
                if (!ObjectUtils.isEmpty((Object)o.getPcpEas()) && BigDecimalUtils.eqZero((BigDecimal)o.getPcpEas()).booleanValue()) {
                    o.setDiff(Integer.valueOf(0));
                    return;
                }
                o.setDiff(Integer.valueOf(1));
            });
        }
        pageInfo.setList(dtoList);
        return pageInfo;
    }

    private ExtQueryChainWrapper<InventoryComparisonReportEo> buildFilter(InventoryComparisonReqDto dto) {
        DictDto dictDto1;
        List codes;
        ExtQueryChainWrapper filter = this.inventoryComparisonReportDas.filter();
        if (!ObjectUtils.isEmpty((Object)dto.getStatisticsTimeStart())) {
            filter.ge((Object)"statistics_time", (Object)dto.getStatisticsTimeStart());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getStatisticsTimeEnd())) {
            filter.le((Object)"statistics_time", (Object)dto.getStatisticsTimeEnd());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getGoodsLongCode())) {
            filter.like((Object)"long_code", (Object)dto.getGoodsLongCode());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getGoodsName())) {
            filter.like((Object)"cargo_name", (Object)dto.getGoodsName());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getBatch())) {
            filter.like((Object)"batch", (Object)dto.getBatch());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getLogicalWarehouseCode())) {
            filter.like((Object)"warehouse_code", (Object)dto.getLogicalWarehouseCode());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getLogicalWarehouseName())) {
            filter.like((Object)"warehouse_name", (Object)dto.getLogicalWarehouseName());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getCargoRightName())) {
            filter.like((Object)"organization_name", (Object)dto.getCargoRightName());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getDiff())) {
            filter.eq((Object)"diff", (Object)dto.getDiff());
        }
        if (!ObjectUtils.isEmpty((Object)dto.getPCPAndEASDiff()) && dto.getPCPAndEASDiff() == 1) {
            filter.ne((Object)"pcp_eas", (Object)0);
        }
        if (!ObjectUtils.isEmpty((Object)dto.getPCPAndEASDiff()) && dto.getPCPAndEASDiff() == 0) {
            filter.eq((Object)"pcp_eas", (Object)0);
        }
        if (!ObjectUtils.isEmpty((Object)dto.getPCPAndWMSDiff()) && dto.getPCPAndWMSDiff() == 1) {
            filter.ne((Object)"pcp_wms", (Object)0);
        }
        if (!ObjectUtils.isEmpty((Object)dto.getEASAndWMSDiff()) && dto.getEASAndWMSDiff() == 1) {
            filter.ne((Object)"eas_wms", (Object)0);
        }
        if (!ObjectUtils.isEmpty((Object)dto.getLogicalWarehouseFilter()) && dto.getLogicalWarehouseFilter() == 1 && !CollectionUtil.isEmpty((Collection)(codes = JSON.parseArray((String)(dictDto1 = (DictDto)RestResponseHelper.extractData((RestResponse)this.pcpDictApi.queryByGroupCodeAndCode("COMMON_CONFIG", DictEnum.LOGICAL_WAREHOUSE_FILTER.getCode()))).getValue(), String.class)))) {
            filter.notIn((Object)"warehouse_code", (Collection)codes);
        }
        filter.eq(dto.getVersion() != null, (Object)"version", (Object)dto.getVersion());
        filter.and(qr -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)qr.ne((Object)"balance", (Object)0)).or()).ne((Object)"eas_num", (Object)0)).or()).ne((Object)"wms_num", (Object)0);
        });
        filter.orderByDesc((Object)"id");
        return filter;
    }

    @Override
    public int initComparisonData() {
        return this.inventoryComparisonReportDas.initComparisonData();
    }

    @Override
    public int updateBatch(List<InventoryComparisonReportAddReqDto> inventoryComparisonReqDtos) {
        inventoryComparisonReqDtos.forEach(r -> this.inventoryComparisonReportDas.updateSelective((BaseEo)BeanUtil.copyProperties((Object)r, InventoryComparisonReportEo.class, (String[])new String[0])));
        return 0;
    }

    @Override
    public void addWmsReport(InventoryQueryResponseDto inventoryQueryResponseDto) {
        if (CollectionUtil.isEmpty((Collection)inventoryQueryResponseDto.getItems())) {
            return;
        }
        List dtoItems = inventoryQueryResponseDto.getItems();
        ArrayList<WmsBalanceReportEo> eoList = new ArrayList<WmsBalanceReportEo>();
        for (InventoryQueryResponse.Item item : dtoItems) {
            WmsBalanceReportEo eo = new WmsBalanceReportEo();
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            String date = DateUtil.formatDate((Date)calendar.getTime());
            eo.setStatisticsTime((Date)DateUtil.parseDate((CharSequence)date));
            eo.setItemCode(item.getItemCode());
            eo.setBatch(item.getProduceCode());
            eo.setQuantity(BigDecimal.valueOf(Optional.ofNullable(item.getQuantity()).orElse(0L)));
            eo.setLogicWarehouseCode(item.getBatchCode());
            eo.setPhysicsWarehouseCode(item.getWarehouseCode());
            eoList.add(eo);
        }
        this.wmsBalanceReportDas.insertBatch(eoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void executeJob() {
        LOGGER.info("\u7edf\u8ba1\u5e93\u5b58\u5bf9\u6bd4\u62a5\u8868\u8c03\u5ea6\u5f00\u59cb\uff01");
        SimpleDateFormat df = new SimpleDateFormat(DatePattern.DATE_PATTERN.getPattern());
        Date dayBegin = com.dtyunxi.cube.utils.DateUtil.addDays((Date)com.dtyunxi.cube.utils.DateUtil.getDayBegin(), (int)-1);
        String statisticsTime = df.format(dayBegin);
        InventoryComparisonReportEo inventoryComparisonReportEo = new InventoryComparisonReportEo();
        Date date = null;
        try {
            date = df.parse(statisticsTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        inventoryComparisonReportEo.setStatisticsTime(date);
        int count = this.inventoryComparisonReportDas.count((BaseEo)inventoryComparisonReportEo);
        if (count > 0) {
            return;
        }
        this.inventoryComparisonReportDas.initComparisonData();
        int pageNum = 1;
        int pageSize = 200;
        boolean flag = true;
        while (flag) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
            PageInfo reportEoPageInfo = ((ExtQueryChainWrapper)this.inventoryComparisonReportDas.filter().eq((Object)"statistics_time", (Object)statisticsTime)).page(Integer.valueOf(pageNum), Integer.valueOf(pageSize));
            if (ObjectUtils.isEmpty((Object)reportEoPageInfo.getList())) break;
            List list = reportEoPageInfo.getList();
            HashMap map = new HashMap();
            list.forEach(item -> map.put(item.getLongCode() + item.getWarehouseCode(), item));
            ArrayList criteriaList = new ArrayList();
            list.forEach(item -> {
                InventoryQueryRequest.Criteria criteria = new InventoryQueryRequest.Criteria();
                criteria.setItemCode(item.getLongCode());
                criteria.setWarehouseCode(item.getWarehouseCode());
                criteriaList.add(criteria);
            });
            InventoryQueryRequestDto dto = new InventoryQueryRequestDto();
            dto.setCriteriaList(criteriaList);
            RestResponse inventoryQuery = this.externalOutQimenWmsApi.inventoryQuery(dto);
            if (!ObjectUtils.isEmpty((Object)inventoryQuery.getData()) && !ObjectUtils.isEmpty((Object)((InventoryQueryResponseDto)inventoryQuery.getData()).getItems())) {
                List items = ((InventoryQueryResponseDto)inventoryQuery.getData()).getItems();
                items.forEach(item -> {
                    InventoryComparisonReportEo eo = (InventoryComparisonReportEo)map.get(item.getItemCode() + item.getWarehouseCode());
                    eo.setWmsNum(BigDecimal.valueOf(item.getQuantity()));
                    eo.setPcpWms(this.diffNum(eo.getBalance(), eo.getWmsNum()));
                    eo.setEasWms(this.diffNum(eo.getEasNum(), eo.getWmsNum()));
                    eo.setPcpEas(this.diffNum(eo.getBalance(), eo.getEasNum()));
                    BigDecimal diffNum = new BigDecimal(0);
                    boolean diff = eo.getPcpEas().compareTo(diffNum) != 0 || eo.getPcpWms().compareTo(diffNum) != 0 || eo.getEasWms().compareTo(diffNum) != 0;
                    eo.setDiff(Integer.valueOf(diff ? 1 : 0));
                    this.inventoryComparisonReportDas.update((BaseEo)eo);
                });
            }
            flag = pageNum != reportEoPageInfo.getNavigateLastPage();
            ++pageNum;
        }
        LOGGER.info("\u7edf\u8ba1\u5e93\u5b58\u5bf9\u6bd4\u62a5\u8868\u8c03\u5ea6\u7ed3\u675f\uff01");
    }

    private BigDecimal diffNum(BigDecimal a, BigDecimal b) {
        if ((a = Optional.ofNullable(a).orElse(BigDecimal.ZERO)).compareTo(b = Optional.ofNullable(b).orElse(BigDecimal.ZERO)) == 0) {
            return new BigDecimal(0);
        }
        if (a.compareTo(b) < 0) {
            return b.subtract(a);
        }
        if (a.compareTo(b) > 0) {
            return a.subtract(b);
        }
        return new BigDecimal(0);
    }
}

