/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.api.dto.SaleOrderMergeDataDto;
import com.dtyunxi.tcbj.api.dto.SaleOrderMergeDataMonitorDto;
import com.dtyunxi.tcbj.biz.service.ISaleOrderMergeDataService;
import com.dtyunxi.tcbj.biz.utils.NoGreateUtil;
import com.dtyunxi.tcbj.dao.das.SaleOrderMergeDataDas;
import com.dtyunxi.tcbj.dao.das.SaleOrderMergeDataDetailDas;
import com.dtyunxi.tcbj.dao.eo.SaleOrderMergeDataDetailEo;
import com.dtyunxi.tcbj.dao.eo.SaleOrderMergeDataEo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SaleOrderMergeDataServiceImpl
implements ISaleOrderMergeDataService {
    private static final Logger logger = LoggerFactory.getLogger(SaleOrderMergeDataServiceImpl.class);
    private final List<String> saleOrderTypeList = Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.AGENCY_ORDER.getType(), SaleOrderTypeEnum.PRE_SALE_ORDER.getType(), SaleOrderTypeEnum.INTERNAL_DISTRIBUTION.getType(), SaleOrderTypeEnum.SECONDARY_DISTRIBUTION.getType(), SaleOrderTypeEnum.INTEGRAL_ORDER.getType(), SaleOrderTypeEnum.REPLENISHMENT_ORDER.getType(), SaleOrderTypeEnum.CUSTOMER_REFUNDING_ORDER.getType(), SaleOrderTypeEnum.COMPENSATION_ORDER.getType(), SaleOrderTypeEnum.QUALITY_REFUNDING_ORDER.getType(), SaleOrderTypeEnum.REPLENISH_ORDER.getType(), SaleOrderTypeEnum.OTHER_OUT_STOCK.getType()});
    @Resource
    private SaleOrderMergeDataDas saleOrderMergeDataDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private SaleOrderMergeDataDetailDas saleOrderMergeDataDetailDas;
    @Resource
    private NoGreateUtil noGreateUtil;

    @Override
    public void addBatch(List<SaleOrderMergeDataDto> dtoList) {
        logger.info("\u9500\u552e\u5355\u5408\u5355\u6570\u636e\u63a5\u53e3\u6279\u91cf\u65b0\u589e\uff1a{}", (Object)JSON.toJSONString(dtoList));
        List eoList = BeanUtil.copyToList(dtoList, SaleOrderMergeDataEo.class);
        for (SaleOrderMergeDataEo dataEo : eoList) {
            List<String> saleOrderList = Arrays.asList(dataEo.getSaleOrder().split(","));
            boolean ifHav = false;
            for (String saleOrder2 : saleOrderList) {
                List dataEoList = ((ExtQueryChainWrapper)this.saleOrderMergeDataDas.filter().like((Object)"sale_order", (Object)saleOrder2)).list();
                if (!CollectionUtil.isNotEmpty((Collection)dataEoList)) continue;
                ifHav = true;
                break;
            }
            if (ifHav) {
                logger.info("\u9500\u552e\u5355\u5df2\u7ecf\u5b58\u5728\uff1a" + saleOrderList.toString());
                continue;
            }
            this.saleOrderMergeDataDas.insert((BaseEo)dataEo);
            List dataDetailEoList = saleOrderList.stream().map(saleOrder -> {
                SaleOrderMergeDataDetailEo detailEo = new SaleOrderMergeDataDetailEo();
                detailEo.setMergeId(dataEo.getId());
                detailEo.setMergeOrder(dataEo.getMergeOrder());
                detailEo.setSaleOrder(saleOrder);
                return detailEo;
            }).collect(Collectors.toList());
            this.saleOrderMergeDataDetailDas.insertBatch(dataDetailEoList);
            this.sendPushJXC(dataEo.getMergeOrder(), dataEo.getPlatformOrder(), dataEo.getSaleOrder());
        }
    }

    private void sendPushJXC(String mergeOrder, String platformOrder, String saleOrder) {
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)mergeOrder);
        logger.info("\u53d1\u9001\u63a8\u9001\u8fdb\u9500\u5b58MQ\uff1a{}\uff0c{}\uff0c{}", new Object[]{mergeOrder, platformOrder, saleOrder});
        this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", "MERGE_PUSH_JXC_TAG", (Object)messageVo);
    }

    @Override
    public void buildSaleOrderMergeData(SaleOrderMergeDataDto dto) {
        logger.info("\u6784\u5efa\u9500\u552e\u5355\u5408\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        dto.setTagCode("YPH");
        dto.setSaleOrderTypeList(this.saleOrderTypeList);
        List saleOrderMergeDataDtoList = this.saleOrderMergeDataDas.queryNotMergeOrder(dto);
        if (CollectionUtil.isEmpty((Collection)saleOrderMergeDataDtoList)) {
            logger.info("\u65e0\u5355\u636e\u9700\u5904\u7406");
        }
        Map<String, List<SaleOrderMergeDataDto>> dataDtoMap = saleOrderMergeDataDtoList.stream().collect(Collectors.groupingBy(g -> g.getIfTag() + "_" + g.getPlatformOrder() + "_" + g.getPhysicsWarehouseCode()));
        ArrayList<SaleOrderMergeDataDto> resultList = new ArrayList<SaleOrderMergeDataDto>();
        for (Map.Entry<String, List<SaleOrderMergeDataDto>> entry : dataDtoMap.entrySet()) {
            logger.info("\u904d\u5386key\uff1a{}", (Object)entry.getKey());
            List<SaleOrderMergeDataDto> value = entry.getValue();
            SaleOrderMergeDataDto firstData = value.get(0);
            List isBlankConsignmentNo = value.stream().map(SaleOrderMergeDataDto::getConsignmentNo).filter(StringUtils::isBlank).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(isBlankConsignmentNo)) {
                logger.info("\u6258\u8fd0\u5355\u4e3a\u7a7a\uff0c\u4e0d\u751f\u6210");
                continue;
            }
            List isBlankPhysicsWarehouseCode = value.stream().map(SaleOrderMergeDataDto::getPhysicsWarehouseCode).filter(StringUtils::isBlank).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(isBlankPhysicsWarehouseCode)) {
                logger.info("\u7269\u7406\u4ed3\u4e3a\u7a7a\uff0c\u4e0d\u751f\u6210");
                continue;
            }
            Map<String, List<SaleOrderMergeDataDto>> consignmentNoGroupMap = value.stream().collect(Collectors.groupingBy(g -> g.getConsignmentNo()));
            consignmentNoGroupMap.forEach((k, v) -> {
                SaleOrderMergeDataDto dto1 = (SaleOrderMergeDataDto)v.get(0);
                String mergeOrder = this.noGreateUtil.generateSaleOrderMergeNo();
                logger.info("\u751f\u4ea7\u5408\u5355\u53f7\uff1a{}", (Object)mergeOrder);
                dto1.setMergeOrder(mergeOrder);
                dto1.setSaleOrder(v.stream().map(SaleOrderMergeDataDto::getSaleOrder).collect(Collectors.joining(",")));
                resultList.add(dto1);
            });
        }
        if (CollectionUtil.isEmpty(resultList)) {
            logger.info("\u65e0\u7b26\u5408\u5408\u5e76\u7684\u5355\u636e");
            return;
        }
        this.addBatch(resultList);
    }

    @Override
    public void updateSaleOrderMergeData(SaleOrderMergeDataDto dto) {
        logger.info("\u66f4\u65b0\u9500\u552e\u5355\u5408\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        SaleOrderMergeDataEo saleOrderMergeDataEo = (SaleOrderMergeDataEo)this.saleOrderMergeDataDas.selectByPrimaryKey(dto.getId());
        AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)saleOrderMergeDataEo), (String)"\u627e\u4e0d\u5230\u6570\u636e\u66f4\u65b0");
        BeanUtil.copyProperties((Object)dto, (Object)saleOrderMergeDataEo, (String[])new String[]{"id", "create_time", "create_person"});
        this.saleOrderMergeDataDas.updateSelective((BaseEo)saleOrderMergeDataEo);
    }

    @Override
    public PageInfo<SaleOrderMergeDataDto> queryPage(SaleOrderMergeDataDto dto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u9500\u552e\u5355\u5408\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.saleOrderMergeDataDas.filter().eq(ObjectUtil.isNotEmpty((Object)dto.getId()), (Object)"id", (Object)dto.getId())).eq(StringUtils.isNotBlank((CharSequence)dto.getPlatformOrder()), (Object)"platform_order", (Object)dto.getPlatformOrder())).eq(StringUtils.isNotBlank((CharSequence)dto.getMergeOrder()), (Object)"merge_order", (Object)dto.getMergeOrder())).like(StringUtils.isNotBlank((CharSequence)dto.getSaleOrder()), (Object)"sale_order", (Object)dto.getSaleOrder())).eq(StringUtils.isNotBlank((CharSequence)dto.getConsignmentNo()), (Object)"consignment_no", (Object)dto.getConsignmentNo())).page(dto.getPageNum(), dto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List saleOrderMergeDataDtoList = BeanUtil.copyToList((Collection)eoPageInfo.getList(), SaleOrderMergeDataDto.class);
        dtoPageInfo.setList(saleOrderMergeDataDtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<SaleOrderMergeDataMonitorDto> queryMonitorPageInfo(SaleOrderMergeDataMonitorDto dto) {
        logger.info("\u67e5\u8be2\u9500\u552e\u5408\u5e76\u63a8\u9001\u76d1\u63a7\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        dto.setOrderTypes(this.saleOrderTypeList);
        return this.saleOrderMergeDataDas.queryMonitorList(dto);
    }

    @Override
    public List<SaleOrderMergeDataDto> querySaleOrderMergeDataList(SaleOrderMergeDataDto dto) {
        logger.info("\u5217\u8868\u67e5\u8be2\u9500\u552e\u5355\u5408\u5355\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        List eoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.saleOrderMergeDataDas.filter().in(CollectionUtil.isNotEmpty((Collection)dto.getPlatformOrderList()), (Object)"platform_order", (Collection)dto.getPlatformOrderList())).eq(StringUtils.isNotBlank((CharSequence)dto.getPlatformOrder()), (Object)"platform_order", (Object)dto.getPlatformOrder())).eq(StringUtils.isNotBlank((CharSequence)dto.getMergeOrder()), (Object)"merge_order", (Object)dto.getMergeOrder())).list();
        return BeanUtil.copyToList((Collection)eoList, SaleOrderMergeDataDto.class);
    }
}

