/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.impl;

import com.aliyun.openservices.shade.com.google.common.base.Objects;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.tcbj.api.dto.response.RelShareInventoryRespDto;
import com.dtyunxi.tcbj.biz.service.IVirtualInventoryService;
import com.dtyunxi.tcbj.dao.das.LogicInventoryDas;
import com.dtyunxi.tcbj.dao.eo.CsLogicInventoryTotalEo;
import com.dtyunxi.tcbj.dao.eo.InventorySharedEo;
import com.dtyunxi.tcbj.dao.eo.InventorySharedWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.LogicWarehouseEo;
import com.dtyunxi.tcbj.dao.eo.VirtualWarehouseEo;
import com.dtyunxi.tcbj.dao.mapper.CsLogicInventoryTotalMapper;
import com.dtyunxi.tcbj.dao.mapper.InventorySharedMapper;
import com.dtyunxi.tcbj.dao.mapper.InventorySharedWarehouseMapper;
import com.dtyunxi.tcbj.dao.mapper.LogicWarehouseMapper;
import com.dtyunxi.tcbj.dao.mapper.VirtualWarehouseMapper;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VirtualInventoryServiceImpl
implements IVirtualInventoryService {
    private static final Logger log = LoggerFactory.getLogger(VirtualInventoryServiceImpl.class);
    @Autowired
    VirtualWarehouseMapper virtualWarehouseMapper;
    @Autowired
    InventorySharedMapper inventorySharedMapper;
    @Autowired
    InventorySharedWarehouseMapper inventorySharedWarehouseMapper;
    @Autowired
    private LogicInventoryDas logicInventoryDas;
    @Autowired
    LogicWarehouseMapper logicWarehouseMapper;
    @Autowired
    CsLogicInventoryTotalMapper csLogicInventoryTotalMapper;

    @Override
    public List<RelShareInventoryRespDto> queryRelLogicInventory(String virtualWarehouseCode, String cargoCode) {
        AssertUtil.assertNotBlank((String)virtualWarehouseCode, (String)"\u4f9b\u8d27\u4ed3\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotBlank((String)cargoCode, (String)"\u8d27\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List virtualWarehouseEos = this.virtualWarehouseMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)virtualWarehouseCode)).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtil.assertNotEmpty((Collection)virtualWarehouseEos, (String)"\u4f9b\u8d27\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        if (virtualWarehouseEos.size() > 1) {
            throw new BizException("\u4f9b\u8d27\u4ed3\u4ed3\u7f16\u7801\u4e0d\u552f\u4e00");
        }
        VirtualWarehouseEo virtualWarehouseEo = (VirtualWarehouseEo)virtualWarehouseEos.get(0);
        List inventorySharedEos = this.inventorySharedMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"virtual_warehouse_code", (Object)virtualWarehouseCode)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (null == inventorySharedEos) {
            inventorySharedEos = Lists.newArrayList();
        }
        List<Object> logicWarehouseCodes = Lists.newArrayList();
        List inventorySharedWarehouseEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)inventorySharedEos)) {
            List shareCodes = inventorySharedEos.stream().map(InventorySharedEo::getSharedCode).collect(Collectors.toList());
            inventorySharedWarehouseEos = this.inventorySharedWarehouseMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"shared_code", shareCodes)).eq((Object)"status", (Object)"enable")).eq((Object)"dr", (Object)YesNoHelper.NO));
            if (null == inventorySharedWarehouseEos) {
                inventorySharedWarehouseEos = Lists.newArrayList();
            }
            logicWarehouseCodes = inventorySharedWarehouseEos.stream().map(InventorySharedWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)logicWarehouseCodes)) {
            return Lists.newArrayList();
        }
        List logicWarehouseEos = this.logicWarehouseMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_code", (Collection)logicWarehouseCodes)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)logicWarehouseEos)) {
            return Lists.newArrayList();
        }
        List logicInventoryTotalEos = this.csLogicInventoryTotalMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_code", (Collection)logicWarehouseCodes)).eq((Object)"sku_code", (Object)cargoCode)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (null == logicInventoryTotalEos) {
            logicInventoryTotalEos = Lists.newArrayList();
        }
        ArrayList relShareInventoryRespList = Lists.newArrayList();
        for (LogicWarehouseEo logicWarehouseEo : logicWarehouseEos) {
            InventorySharedEo inventorySharedEo;
            InventorySharedWarehouseEo inventorySharedWarehouseEo;
            RelShareInventoryRespDto dto = new RelShareInventoryRespDto();
            BigDecimal shareInventory = BigDecimal.ZERO;
            CsLogicInventoryTotalEo logicInventoryTotalEo = logicInventoryTotalEos.stream().filter(o -> Objects.equal((Object)o.getWarehouseId(), (Object)logicWarehouseEo.getId())).findFirst().orElse(null);
            if (null != logicInventoryTotalEo && null != (inventorySharedWarehouseEo = (InventorySharedWarehouseEo)inventorySharedWarehouseEos.stream().filter(o -> StringUtils.equals((String)o.getWarehouseCode(), (String)logicWarehouseEo.getWarehouseCode())).findFirst().orElse(null)) && null != inventorySharedWarehouseEo.getSharedCode() && null != (inventorySharedEo = (InventorySharedEo)inventorySharedEos.stream().filter(o -> StringUtils.equals((String)o.getSharedCode(), (String)inventorySharedWarehouseEo.getSharedCode())).findFirst().orElse(null))) {
                BigDecimal supplyInventory = BigDecimalUtils.subtract((BigDecimal)logicInventoryTotalEo.getBalance(), (BigDecimal)BigDecimalUtils.subtract((BigDecimal)logicInventoryTotalEo.getPreempt(), (BigDecimal)logicInventoryTotalEo.getAllocate()));
                shareInventory = BigDecimalUtils.multiply((BigDecimal)supplyInventory, (BigDecimal)BigDecimalUtils.divide((BigDecimal)inventorySharedEo.getSharedNumerical(), (BigDecimal)BigDecimalUtils.ONE_HUNDRED)).setScale(0, RoundingMode.DOWN);
            }
            dto.setId(logicWarehouseEo.getId());
            dto.setShareWarehouseCode(logicWarehouseEo.getWarehouseCode());
            dto.setShareWarehouseName(logicWarehouseEo.getWarehouseName());
            dto.setShareWarehouseType("to_virtual");
            dto.setShareWarehouseTypeName("\u903b\u8f91\u4ed3");
            dto.setCargoCode(cargoCode);
            dto.setReceiveWarehouseCode(virtualWarehouseEo.getWarehouseCode());
            dto.setBalance(shareInventory);
            dto.setPreempt(BigDecimal.ZERO);
            dto.setAvailable(BigDecimal.ZERO);
            relShareInventoryRespList.add(dto);
        }
        return relShareInventoryRespList;
    }

    @Override
    public List<RelShareInventoryRespDto> queryModelLogicInventory(String virtualWarehouseCode, String cargoCode) {
        AssertUtil.assertNotBlank((String)virtualWarehouseCode, (String)"\u4f9b\u8d27\u4ed3\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.assertNotBlank((String)cargoCode, (String)"\u8d27\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List virtualWarehouseEos = this.virtualWarehouseMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)virtualWarehouseCode)).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtil.assertNotEmpty((Collection)virtualWarehouseEos, (String)"\u4f9b\u8d27\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        if (virtualWarehouseEos.size() > 1) {
            throw new BizException("\u4f9b\u8d27\u4ed3\u4ed3\u7f16\u7801\u4e0d\u552f\u4e00");
        }
        VirtualWarehouseEo virtualWarehouseEo = (VirtualWarehouseEo)virtualWarehouseEos.get(0);
        List inventorySharedEos = this.inventorySharedMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"virtual_warehouse_code", (Object)virtualWarehouseCode)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (null == inventorySharedEos) {
            inventorySharedEos = Lists.newArrayList();
        }
        List<Object> logicWarehouseCodes = Lists.newArrayList();
        List inventorySharedWarehouseEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)inventorySharedEos)) {
            List shareCodes = inventorySharedEos.stream().map(InventorySharedEo::getSharedCode).collect(Collectors.toList());
            inventorySharedWarehouseEos = this.inventorySharedWarehouseMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"shared_code", shareCodes)).eq((Object)"status", (Object)"enable")).eq((Object)"dr", (Object)YesNoHelper.NO));
            if (null == inventorySharedWarehouseEos) {
                inventorySharedWarehouseEos = Lists.newArrayList();
            }
            logicWarehouseCodes = inventorySharedWarehouseEos.stream().map(InventorySharedWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)logicWarehouseCodes)) {
            return Lists.newArrayList();
        }
        List logicWarehouseEos = this.logicWarehouseMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_code", (Collection)logicWarehouseCodes)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)logicWarehouseEos)) {
            return Lists.newArrayList();
        }
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDas.filter().in((Object)"warehouse_code", (Collection)logicWarehouseCodes)).eq((Object)"sku_code", (Object)cargoCode)).eq((Object)"dr", (Object)YesNoHelper.NO)).list();
        Map<String, Double> availableMap = eos.stream().collect(Collectors.groupingBy(r -> r.getWarehouseCode(), Collectors.summingDouble(r -> r.getAvailable().doubleValue())));
        Map<String, Double> preemptMap = eos.stream().collect(Collectors.groupingBy(r -> r.getWarehouseCode(), Collectors.summingDouble(r -> r.getPreempt().doubleValue())));
        Map<String, Double> balanceMap = eos.stream().collect(Collectors.groupingBy(r -> r.getWarehouseCode(), Collectors.summingDouble(r -> r.getBalance().doubleValue())));
        List logicInventoryTotalEos = this.csLogicInventoryTotalMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_code", (Collection)logicWarehouseCodes)).eq((Object)"sku_code", (Object)cargoCode)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (null == logicInventoryTotalEos) {
            logicInventoryTotalEos = Lists.newArrayList();
        }
        ArrayList relShareInventoryRespList = Lists.newArrayList();
        for (LogicWarehouseEo logicWarehouseEo : logicWarehouseEos) {
            InventorySharedEo inventorySharedEo;
            InventorySharedWarehouseEo inventorySharedWarehouseEo;
            String key = logicWarehouseEo.getWarehouseCode();
            RelShareInventoryRespDto dto = new RelShareInventoryRespDto();
            BigDecimal shareInventory = BigDecimal.ZERO;
            BigDecimal available = BigDecimal.ZERO;
            BigDecimal preempt = BigDecimal.ZERO;
            CsLogicInventoryTotalEo logicInventoryTotalEo = logicInventoryTotalEos.stream().filter(o -> Objects.equal((Object)o.getWarehouseId(), (Object)logicWarehouseEo.getId())).findFirst().orElse(null);
            if (null != logicInventoryTotalEo && null != (inventorySharedWarehouseEo = (InventorySharedWarehouseEo)inventorySharedWarehouseEos.stream().filter(o -> StringUtils.equals((String)o.getWarehouseCode(), (String)logicWarehouseEo.getWarehouseCode())).findFirst().orElse(null)) && null != inventorySharedWarehouseEo.getSharedCode() && null != (inventorySharedEo = (InventorySharedEo)inventorySharedEos.stream().filter(o -> StringUtils.equals((String)o.getSharedCode(), (String)inventorySharedWarehouseEo.getSharedCode())).findFirst().orElse(null)) && availableMap.containsKey(key)) {
                available = BigDecimal.valueOf(availableMap.get(key));
                preempt = BigDecimal.valueOf(preemptMap.get(key));
                shareInventory = BigDecimal.valueOf(balanceMap.get(key));
            }
            dto.setId(logicWarehouseEo.getId());
            dto.setShareWarehouseCode(logicWarehouseEo.getWarehouseCode());
            dto.setShareWarehouseName(logicWarehouseEo.getWarehouseName());
            dto.setShareWarehouseType("to_virtual");
            dto.setShareWarehouseTypeName("\u903b\u8f91\u4ed3");
            dto.setCargoCode(cargoCode);
            dto.setReceiveWarehouseCode(virtualWarehouseEo.getWarehouseCode());
            dto.setBalance(shareInventory);
            dto.setPreempt(preempt);
            dto.setAvailable(available);
            relShareInventoryRespList.add(dto);
        }
        return relShareInventoryRespList;
    }
}

