/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.schedule;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeApportionReqDto;
import com.dtyunxi.tcbj.biz.service.IStorageChargeApportionService;
import com.dtyunxi.tcbj.dao.eo.StorageChargeApportionEo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="storageApportDataScheduled")
@Scope(value="prototype")
public class StorageApportDataScheduled
extends SingleTupleScheduleEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageApportDataScheduled.class);
    @Resource
    private IStorageChargeApportionService storageChargeApportionService;

    public void before(TaskMsg taskMsg) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
    }

    public boolean execute(TaskMsg taskMsg) {
        LOGGER.info("\u751f\u6210\u4ed3\u50a8\u660e\u7ec6\u5206\u644a\u6570\u636e");
        try {
            Date date = StringUtils.isNotBlank((CharSequence)taskMsg.getContent()) ? com.dtyunxi.util.DateUtil.parse((String)taskMsg.getContent(), (String)"yyyy-MM-dd") : DateUtil.getDayBegin((Date)new Date());
            List<StorageChargeApportionReqDto> storageChargeApportionReqDtos = this.storageChargeApportionService.queryTimeRangeStorageChargeApportion(this.getMonthBeforeLastFirstDay(date), this.getMonthBeforeLastLastDay(date));
            if (CollectionUtils.isNotEmpty(storageChargeApportionReqDtos)) {
                LOGGER.info("\u63d2\u5165\u5206\u644a\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(storageChargeApportionReqDtos));
                ArrayList storageChargeApportionEos = Lists.newArrayList();
                DtoHelper.dtoList2EoList(storageChargeApportionReqDtos, (Collection)storageChargeApportionEos, StorageChargeApportionEo.class);
                this.storageChargeApportionService.insertBatch(storageChargeApportionEos);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4ed3\u50a8\u8d39\u7528\u5206\u644a\u7ef4\u5ea6\u6821\u9a8c\u6570\u636e\u5f02\u5e38");
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }

    private Date getMonthBeforeLastFirstDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, -1);
        c.set(5, 1);
        return c.getTime();
    }

    private Date getMonthBeforeLastLastDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, -1);
        c.set(5, c.getActualMaximum(5));
        return c.getTime();
    }
}

