/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.apiimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IFinLogisticsReportApi;
import com.dtyunxi.tcbj.api.dto.request.AgainCalculateReqDto;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportEditReqDto;
import com.dtyunxi.tcbj.api.dto.request.FinLogisticsReportReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticOperateReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticStatisticReqDto;
import com.dtyunxi.tcbj.biz.service.IFinLogisticDetailService;
import com.dtyunxi.tcbj.biz.service.IFinLogisticsReportService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="IFinLogisticsReportApi")
public class FinLogisticsReportApiImpl
implements IFinLogisticsReportApi {
    private static final Logger logger = LoggerFactory.getLogger(FinLogisticsReportApiImpl.class);
    @Resource
    private IFinLogisticsReportService finLogisticsReportService;
    @Resource
    private IFinLogisticDetailService finLogisticDetailService;

    public RestResponse<Long> addFinLogisticsReport(FinLogisticsReportReqDto addReqDto) {
        return new RestResponse((Object)this.finLogisticsReportService.addFinLogisticsReport(addReqDto));
    }

    public RestResponse<Void> modifyFinLogisticsReport(FinLogisticsReportReqDto modifyReqDto) {
        this.finLogisticsReportService.modifyFinLogisticsReport(modifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeFinLogisticsReport(String ids, Long instanceId) {
        this.finLogisticsReportService.removeFinLogisticsReport(ids, instanceId);
        return RestResponse.VOID;
    }

    public RestResponse<Long> pooledData(LogisticOperateReqDto reqDto) {
        return new RestResponse((Object)this.finLogisticsReportService.pooledData(reqDto));
    }

    public RestResponse<Void> resolutionData(LogisticOperateReqDto reqDto) {
        this.finLogisticsReportService.resolutionData(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> againCalculate(List<String> ids) {
        this.finLogisticsReportService.againCalculate(ids);
        return RestResponse.VOID;
    }

    public RestResponse<Void> statisticData(LogisticStatisticReqDto logisticStatisticReqDto) {
        if (StringUtils.isBlank((CharSequence)logisticStatisticReqDto.getStartTime()) || StringUtils.isBlank((CharSequence)logisticStatisticReqDto.getEndTime())) {
            throw new BizException("-1", "\u53c2\u6570\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.info("\u624b\u52a8\u751f\u6210\u7269\u6d41\u8d39\u7528\u62a5\u8868\uff1a{}", (Object)JSON.toJSONString((Object)logisticStatisticReqDto));
        this.finLogisticsReportService.deleteDetailAndReport(logisticStatisticReqDto);
        this.finLogisticsReportService.statisticDataNew(logisticStatisticReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> statisticDataOld(LogisticStatisticReqDto logisticStatisticReqDto) {
        if (StringUtils.isBlank((CharSequence)logisticStatisticReqDto.getStartTime()) || StringUtils.isBlank((CharSequence)logisticStatisticReqDto.getEndTime())) {
            throw new BizException("-1", "\u53c2\u6570\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        logger.info("\u624b\u52a8\u751f\u6210\u7269\u6d41\u8d39\u7528\u62a5\u8868\uff1a{}", (Object)JSON.toJSONString((Object)logisticStatisticReqDto));
        this.finLogisticsReportService.deleteDetailAndReport(logisticStatisticReqDto);
        this.finLogisticsReportService.statisticData(logisticStatisticReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> importLogisticsReport(List<FinLogisticsReportDto> reportDtoList) {
        this.finLogisticDetailService.importModifyData(reportDtoList);
        return RestResponse.VOID;
    }

    public RestResponse<Void> insertBatch(List<FinLogisticsReportDto> reportDtoList) {
        this.finLogisticDetailService.insertBatch(reportDtoList);
        return RestResponse.VOID;
    }

    public RestResponse<Void> againCalculate(AgainCalculateReqDto reqDto) {
        this.finLogisticsReportService.againCalculate(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> edit(FinLogisticsReportEditReqDto editReqDto) {
        this.finLogisticsReportService.edit(editReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> del(String ids) {
        this.finLogisticsReportService.del(ids);
        return RestResponse.VOID;
    }

    public RestResponse<Void> editAddress(FinLogisticsReportEditReqDto editAddress) {
        this.finLogisticsReportService.editAddress(editAddress);
        return RestResponse.VOID;
    }

    public RestResponse<Integer> updatePlaceStatus(FeeReportPlaceUpdateReqDto updateReqDto) {
        return new RestResponse((Object)this.finLogisticsReportService.updatePlaceStatus(updateReqDto));
    }

    public RestResponse<Void> generateLogisticStatisticDataForDailyDeliveryReport(LogisticStatisticReqDto logisticStatisticReqDto) {
        this.finLogisticsReportService.generateLogisticStatisticDataForDailyDeliveryReport(logisticStatisticReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateSpecial(FinLogisticDetailReqDto reqDto) {
        this.finLogisticsReportService.updateSpecial(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Long> updOrIns(FinLogisticDetailReqDto reqDto) {
        return new RestResponse((Object)this.finLogisticsReportService.updOrIns(reqDto));
    }
}

