/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.biz.service.query.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.tcbj.api.dto.request.CustomerCompanyExtDto;
import com.dtyunxi.tcbj.api.dto.request.StoreSearchReqDto;
import com.dtyunxi.tcbj.api.dto.response.ItBrandDto;
import com.dtyunxi.tcbj.api.dto.response.StoreSearchRespDto;
import com.dtyunxi.tcbj.biz.service.query.IStoreSearchService;
import com.dtyunxi.tcbj.dao.das.StoreSearchDas;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreCategoryCodeEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import liquibase.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IStoreSearchServiceImpl
implements IStoreSearchService {
    private static final Logger logger = LoggerFactory.getLogger(IStoreSearchServiceImpl.class);
    @Resource
    private StoreSearchDas storeSearchDas;

    @Override
    public PageInfo<StoreSearchRespDto> queryStoreListSearch(StoreSearchReqDto reqDto) {
        logger.info("\u836f\u5e97\u67e5\u8be2\uff0c{}", (Object)JSONObject.toJSONString((Object)reqDto));
        if (ObjectUtils.isEmpty((Object)reqDto.getOrgId())) {
            String orgId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
            if (ObjectUtils.isEmpty((Object)orgId)) {
                throw new BizException("-1", "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7");
            }
            reqDto.setOrgId(Long.valueOf(orgId));
        }
        logger.info("\u5f53\u524d\u7ec4\u7ec7id\uff1a{}", (Object)reqDto.getOrgId());
        List customerCompanyList = new ArrayList();
        CustomerCompanyExtDto customerCompanyParams = new CustomerCompanyExtDto();
        customerCompanyParams.setMerchantId(reqDto.getOrgId());
        if (ObjectUtils.isEmpty((Object)reqDto.getCustomerCode()) && ObjectUtils.isEmpty((Object)reqDto.getParentCustomerCode())) {
            customerCompanyList = this.storeSearchDas.queryCustomerCompanyList(customerCompanyParams);
        } else {
            List customerList;
            if (ObjectUtils.isNotEmpty((Object)reqDto.getCustomerCode())) {
                customerCompanyParams.setCustomerCode(reqDto.getCustomerCode());
                customerList = this.storeSearchDas.queryCustomerCompanyList(customerCompanyParams);
                if (CollectionUtils.isNotEmpty((Collection)customerList)) {
                    reqDto.setCustomerCompanyCreditCodes(customerList.stream().map(CustomerCompanyExtDto::getCreditCode).collect(Collectors.toList()));
                    customerCompanyList.addAll(customerList);
                } else {
                    logger.info("\u5ba2\u6237\u7f16\u53f7\uff0c\u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a");
                    return new PageInfo();
                }
            }
            if (ObjectUtils.isNotEmpty((Object)reqDto.getParentCustomerCode())) {
                customerCompanyParams.setCustomerCode(reqDto.getParentCustomerCode());
                customerList = this.storeSearchDas.queryCustomerCompanyList(customerCompanyParams);
                if (CollectionUtils.isNotEmpty((Collection)customerList)) {
                    reqDto.setParentCustomerCompanyCreditCodes(customerList.stream().map(CustomerCompanyExtDto::getCreditCode).collect(Collectors.toList()));
                    customerCompanyList.addAll(customerList);
                } else {
                    logger.info("\u4e0a\u7ea7\u5ba2\u6237\u7f16\u53f7\uff0c\u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a");
                    return new PageInfo();
                }
            }
        }
        Map<String, CustomerCompanyExtDto> customerCompanyMap = null;
        if (CollectionUtils.isNotEmpty(customerCompanyList)) {
            customerCompanyMap = customerCompanyList.stream().collect(Collectors.toMap(CustomerCompanyExtDto::getCreditCode, t -> t, (last, next) -> next));
        }
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        List storeSearchRespDtos = this.storeSearchDas.queryStoreListSearch2(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)storeSearchRespDtos) && ObjectUtils.isNotEmpty(customerCompanyMap)) {
            Map<String, CustomerCompanyExtDto> finalCustomerCompanyMap = customerCompanyMap;
            Map<String, String> brandMap = ((List)Optional.ofNullable(this.storeSearchDas.queryBrands()).orElse(new ArrayList())).stream().collect(Collectors.toMap(e -> e.getCode(), t -> t.getName(), (e1, e2) -> e1));
            storeSearchRespDtos.forEach(dto -> {
                CustomerCompanyExtDto customerCompanyExtDto;
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dto.getSocialCreditNum()) && ObjectUtils.isNotEmpty((Object)(customerCompanyExtDto = (CustomerCompanyExtDto)finalCustomerCompanyMap.get(dto.getSocialCreditNum())))) {
                    dto.setIfCustomer(Integer.valueOf(1));
                    dto.setCustomerCode(customerCompanyExtDto.getCustomerCode());
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)dto.getParentSocialCreditNum()) && ObjectUtils.isNotEmpty((Object)(customerCompanyExtDto = (CustomerCompanyExtDto)finalCustomerCompanyMap.get(dto.getParentSocialCreditNum())))) {
                    dto.setIfParentCustomer(Integer.valueOf(1));
                    dto.setParentCustomerCode(customerCompanyExtDto.getCustomerCode());
                }
                if (MapUtils.isNotEmpty((Map)brandMap) && StringUtils.isNotEmpty((String)dto.getBrand())) {
                    List<String> brandCodes = Arrays.asList(dto.getBrand().split(";"));
                    dto.setBrandCodes(brandCodes);
                    dto.setBrandNames(brandCodes.stream().map(g -> (String)brandMap.get(g)).collect(Collectors.joining(";")));
                }
                if (StoreCategoryCodeEnum.fromCode((String)dto.getStoreCategoryCode()) != null) {
                    dto.setStoreCategoryName(StoreCategoryCodeEnum.fromCode((String)dto.getStoreCategoryCode()).getName());
                }
            });
        }
        return new PageInfo(storeSearchRespDtos);
    }

    @Deprecated
    public PageInfo<StoreSearchRespDto> queryStoreListSearchDeprecated(StoreSearchReqDto reqDto) {
        logger.info("\u836f\u5e97\u67e5\u8be2\u641c\u7d22\u6761\u4ef6\uff0c{}", (Object)JSONObject.toJSONString((Object)reqDto));
        Long orgId = null;
        if (reqDto.getOrgId() != null) {
            orgId = reqDto.getOrgId();
        } else {
            logger.info("\u83b7\u53d6\u5934\u4fe1\u606f\u7ec4\u7ec7id\uff0c{}", (Object)ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid"));
            orgId = Long.valueOf(ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid"));
            reqDto.setOrgId(orgId);
        }
        logger.info("\u5f53\u524d\u5927B\u7ec4\u7ec7id\uff0c{}", (Object)orgId);
        List creditCodeList = this.storeSearchDas.queryCreditCodeByOrgId(orgId);
        if (CollectionUtils.isNotEmpty((Collection)creditCodeList)) {
            reqDto.setCreditCodeList(creditCodeList);
        }
        List customerCreditCodes = null;
        if (StringUtils.isNotEmpty((String)reqDto.getCustomerCode()) && CollectionUtils.isNotEmpty((Collection)creditCodeList)) {
            customerCreditCodes = this.storeSearchDas.queryCreditCodeByCustomerCode(reqDto.getCustomerCode(), creditCodeList);
            reqDto.setCustomerCreditCodes(customerCreditCodes);
        }
        List parentCustomerCreditCodes = null;
        if (StringUtils.isNotEmpty((String)reqDto.getParentCustomerCode()) && CollectionUtils.isNotEmpty((Collection)creditCodeList)) {
            parentCustomerCreditCodes = this.storeSearchDas.queryCreditCodeByCustomerCode(reqDto.getParentCustomerCode(), creditCodeList);
            reqDto.setParentCustomerCreditCodes(parentCustomerCreditCodes);
        }
        if ((StringUtils.isNotEmpty((String)reqDto.getCustomerCode()) || StringUtils.isNotEmpty((String)reqDto.getParentCustomerCode())) && CollectionUtils.isNotEmpty((Collection)customerCreditCodes) && CollectionUtils.isNotEmpty(parentCustomerCreditCodes)) {
            logger.info("\u6839\u636e\u5ba2\u6237\u7f16\u53f7\u3001\u4e0a\u7ea7\u5ba2\u6237\u7f16\u7801\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u4fe1\u7528\u4ee3\u7801");
            return null;
        }
        logger.info("\u836f\u5e97\u5217\u8868\u67e5\u8be2\u6761\u4ef6reqDto,{}", (Object)JSONObject.toJSONString((Object)reqDto));
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        List storeSearchRespDtos = this.storeSearchDas.queryStoreListSearch(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)storeSearchRespDtos)) {
            HashSet socialCreditNumList = new HashSet();
            storeSearchRespDtos.forEach(e -> {
                if (StringUtils.isNotEmpty((String)e.getSocialCreditNum())) {
                    socialCreditNumList.add(e.getSocialCreditNum());
                }
                if (StringUtils.isNotEmpty((String)e.getParentSocialCreditNum())) {
                    socialCreditNumList.add(e.getParentSocialCreditNum());
                }
            });
            Map<Object, Object> codeMap = new HashMap();
            if (CollectionUtils.isNotEmpty(socialCreditNumList)) {
                ArrayList socialCreditNums = new ArrayList(socialCreditNumList);
                reqDto.setSocialCreditNums(socialCreditNums);
                List storeSearchRespDtoList = this.storeSearchDas.queryCustomerCodeBySocialCreditNum(reqDto);
                if (CollectionUtils.isNotEmpty((Collection)storeSearchRespDtoList)) {
                    codeMap = storeSearchRespDtoList.stream().collect(Collectors.toMap(e -> e.getSocialCreditNum(), e -> e.getCustomerCode(), (a1, a2) -> a2));
                }
            }
            HashMap finalCodeMap = codeMap;
            Map<String, String> brandMap = ((List)Optional.ofNullable(this.storeSearchDas.queryBrands()).orElse(new ArrayList())).stream().collect(Collectors.toMap(e -> e.getCode(), t -> t.getName(), (e1, e2) -> e1));
            storeSearchRespDtos.forEach(e -> {
                if (StringUtils.isNotEmpty((String)e.getSocialCreditNum())) {
                    e.setCustomerCode((String)finalCodeMap.get(e.getSocialCreditNum()));
                }
                if (StringUtils.isNotEmpty((String)e.getParentSocialCreditNum())) {
                    e.setParentCustomerCode((String)finalCodeMap.get(e.getParentSocialCreditNum()));
                }
                if (MapUtils.isNotEmpty((Map)brandMap) && StringUtils.isNotEmpty((String)e.getBrand())) {
                    List<String> brandCodes = Arrays.asList(e.getBrand().split(";"));
                    e.setBrandCodes(brandCodes);
                    e.setBrandNames(brandCodes.stream().map(g -> (String)brandMap.get(g)).collect(Collectors.joining(";")));
                }
                if (StoreCategoryCodeEnum.fromCode((String)e.getStoreCategoryCode()) != null) {
                    e.setStoreCategoryName(StoreCategoryCodeEnum.fromCode((String)e.getStoreCategoryCode()).getName());
                }
            });
        }
        return new PageInfo(storeSearchRespDtos);
    }

    @Override
    public List<ItBrandDto> queryBrands() {
        return this.storeSearchDas.queryBrands();
    }
}

