/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.cache;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class PayCache {
    private static Logger logger = LoggerFactory.getLogger(PayCache.class);
    public static final String CACHE_PREFIX = "";
    public static final String PAY_CACHE_KEY = "pay:";
    public static final String PAYING_CACHE_KEY = "paying:";
    @Resource
    private ICacheService bizCacheService;
    @Value(value="${pay.cache.expire.seconds:2592000}")
    private Integer cacheExpireSeconds;
    @Value(value="${pay.status.expire.seconds:30}")
    private Integer payStatusExpireSeconds;

    public Boolean delCache(String orderId) {
        return this.bizCacheService.delCache(this.getCacheKey(orderId));
    }

    public String getCacheKey(String orderId) {
        Assert.notNull((Object)orderId, (String)"tradeNo must not null");
        return PAY_CACHE_KEY.concat(orderId);
    }

    public Boolean setPayingStatus(String orderId) {
        Long flag = this.bizCacheService.setnx(PAYING_CACHE_KEY.concat(orderId), "doing");
        if (Long.valueOf(1L).equals(flag)) {
            this.bizCacheService.expire(PAYING_CACHE_KEY.concat(orderId), this.payStatusExpireSeconds.intValue());
            return true;
        }
        return false;
    }

    public void delPayingSatuts(String orderId) {
        this.bizCacheService.delCache(PAYING_CACHE_KEY.concat(orderId));
    }

    public Boolean setPayingStatus(List<String> orderIdList) {
        Assert.notEmpty(orderIdList, (String)"orderIdList must not empty");
        if (orderIdList.size() == 1) {
            return this.setPayingStatus(orderIdList.get(0));
        }
        Boolean flag = true;
        for (String orderId : orderIdList) {
            if (this.setPayingStatus(orderId).booleanValue()) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private Long idGenerator(String key, Long value, Long timeout) {
        return this.bizCacheService.incrBy(key, value.longValue(), timeout.longValue());
    }
}

