/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.scheduled;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.center.settlement.biz.config.SettlementVerifyConfig;
import com.dtyunxi.tcbj.center.settlement.biz.constant.DingdingSender;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountRegisterRelationService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
public class SettlementAccountScheduled {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String RESULT_SETTLEACCOUTLOGOUT_LOCK = "RESULT_SETTLEACCOUTLOGOUT_LOCK";
    @Resource
    private DingdingSender dingdingSender;
    @Resource
    private ICacheService cacheService;
    @Resource
    private SettlementVerifyConfig settlementVerifyConfig;
    @Resource
    private ISettlementAccountRegisterRelationService relationService;

    public void logoutDealer() {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb-\u5927B\u7ed3\u7b97\u8d26\u6237\u6ce8\u9500-logoutDealer");
        boolean lockFlag = this.cacheService.setIfAbsent("RESULT_SETTLEACCOUTLOGOUT_LOCK", (Object)1, 200);
        if (lockFlag) {
            try {
                this.logger.info("\u5927B\u7ed3\u7b97\u8d26\u6237\u6ce8\u9500\u5b9a\u65f6\u5668\u542f\u52a8");
                this.relationService.logoutDealer();
            }
            catch (Exception e) {
                DingdingSender.SendDingDingMsgReqDto msgReqDto = new DingdingSender.SendDingDingMsgReqDto();
                msgReqDto.setRemindPhones(this.settlementVerifyConfig.getWftPayList());
                msgReqDto.setRemindType(1);
                msgReqDto.setSendMessage(this.getClass().getName() + ".logoutDealer\u3010\u5927B\u7ed3\u7b97\u8d26\u6237\u6ce8\u9500\u3011\u5931\u8d25\u539f\u56e0\u4e3a\uff1a" + e.getMessage());
                this.dingdingSender.sendMessage(msgReqDto);
                this.logger.error("\u3010\u5927B\u7ed3\u7b97\u8d26\u6237\u6ce8\u9500-logoutDealer\u9519\u8bef\u4fe1\u606f\u3011\uff1a" + e.getMessage(), (Throwable)e);
                throw e;
            }
            finally {
                this.cacheService.delCache("RESULT_SETTLEACCOUTLOGOUT_LOCK");
            }
        }
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f-\u5927B\u7ed3\u7b97\u8d26\u6237\u6ce8\u9500-logoutDealer");
    }
}

