/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.scheduled;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.tcbj.center.settlement.biz.constant.DingdingSender;
import com.dtyunxi.tcbj.center.settlement.biz.service.IWithdrawResultService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class WithdrawResultScheduled {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String WITHDRAW_LOCK_KEY = "WITHDRAW_LOCK_KEY";
    private static final String RESULT_WITHDRAW_LOCK_KEY = "RESULT_WITHDRAW_LOCK_KEY";
    @Resource
    private IWithdrawResultService withdrawResultService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private DingdingSender dingdingSender;

    public void doChangeWithdrawResult() {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        this.logger.info("\u89e6\u53d1\u5b9a\u65f6\u4efb\u52a1-doChangeWithdrawResult");
        Boolean lockFlag = this.cacheService.setIfAbsent(WITHDRAW_LOCK_KEY, (Object)1, 120);
        if (lockFlag.booleanValue()) {
            this.logger.info("\u3010\u63d0\u73b0/\u9000\u6c47\u3011\u67e5\u8be2\u63d0\u73b0\u7ed3\u679c\u5b9a\u65f6\u5668\u542f\u52a8");
            try {
                this.withdrawResultService.changeWithdrawResult();
            }
            catch (Exception e) {
                this.logger.error("\u3010\u67e5\u8be2\u63d0\u73b0\u7ed3\u679c\u3011\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
                this.dingdingSender.sendMessage("com.dtyunxi.tcbj.center.settlement.biz.scheduled.WithdrawResultScheduled.doChangeWithdrawResult\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38" + e.getMessage());
            }
            finally {
                this.cacheService.delCache(WITHDRAW_LOCK_KEY);
            }
        }
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f-doChangeWithdrawResult");
    }

    public void doChangeReturnWithdrawResult() {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        this.logger.info("\u89e6\u53d1\u5b9a\u65f6\u4efb\u52a1-doChangeReturnWithdrawResult");
        Boolean lockFlag = this.cacheService.setIfAbsent(RESULT_WITHDRAW_LOCK_KEY, (Object)1, 120);
        if (lockFlag.booleanValue()) {
            try {
                this.logger.info("\u3010\u63d0\u73b0/\u9000\u6c47\u3011\u67e5\u8be2\u9000\u6c47\u60c5\u51b5\u5b9a\u65f6\u5668\u542f\u52a8");
                this.withdrawResultService.reexchangeBalance();
            }
            catch (Exception e) {
                this.logger.error("\u3010\u67e5\u8be2\u9000\u6c47\u7ed3\u679c\u3011\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
                this.dingdingSender.sendMessage("com.dtyunxi.tcbj.center.settlement.biz.scheduled.WithdrawResultScheduled.doChangeReturnWithdrawResult\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38" + e.getMessage());
            }
            finally {
                this.cacheService.delCache(RESULT_WITHDRAW_LOCK_KEY);
            }
        }
        this.logger.info("\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f-doChangeReturnWithdrawResult");
    }
}

