/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.CupSplitAmountReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.CupTradeFlowRecordReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.CupTradeFlowRecordRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.QuerySplitLogAmountRespDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.settlement.api.exception.SettlementExceptionCode;
import com.dtyunxi.tcbj.center.settlement.biz.config.CupFtpConfig;
import com.dtyunxi.tcbj.center.settlement.biz.service.ICupTradeFlowService;
import com.dtyunxi.tcbj.center.settlement.biz.utils.FtpUtil;
import com.dtyunxi.tcbj.center.settlement.biz.vo.CupTradeFlowExcelVo;
import com.dtyunxi.tcbj.center.settlement.dao.das.CupTradeFlowRecordDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.CupTradeFlowRecordEo;
import com.dtyunxi.tcbj.center.settlement.dao.mapper.CupTradeFlowRecordMapper;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class CupTradeFlowServiceImpl
implements ICupTradeFlowService {
    private final Logger logger = LoggerFactory.getLogger(CupTradeFlowServiceImpl.class);
    @Resource
    private CupTradeFlowRecordDas cupTradeFlowRecordDas;
    @Resource
    private CupFtpConfig cupFtpConfig;
    @Resource
    private CupTradeFlowRecordMapper cupTradeFlowRecordMapper;

    @Override
    public PageInfo<CupTradeFlowRecordRespDto> queryRecordPage(CupTradeFlowRecordReqDto reqDto) {
        this.logger.info("\u94f6\u8054\u4ea4\u6613\u6d41\u6c34\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        CupTradeFlowRecordEo paramsEo = new CupTradeFlowRecordEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)paramsEo);
        PageInfo eoPageInfo = this.cupTradeFlowRecordDas.selectPage((BaseEo)paramsEo);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)eoPageInfo.getList())) {
            DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CupTradeFlowRecordRespDto.class);
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void syncTradeFLow(Date date) {
        AssertUtils.notEmpty((Object)date, (SettlementExceptionCode)SettlementExceptionCode.ARGS_NOT_EMPTY);
        this.logger.info("\u540c\u6b65\u94f6\u8054\u4ea4\u6613\u6d41\u6c34\u8bb0\u5f55\uff1a{}", (Object)date);
        String fileName = this.cupFtpConfig.fileName(date);
        List<CupTradeFlowExcelVo> list = this.parseFLowFile(fileName);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (CollectionUtil.isNotEmpty(list)) {
            this.logger.info("\u6d41\u6c34\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString(list));
            CupTradeFlowRecordEo deleteEo = new CupTradeFlowRecordEo();
            deleteEo.setFileName(fileName);
            this.logger.info("\u5148\u5220\u9664\u4e45\u7684\u6d41\u6c34\uff1a{}", (Object)JSON.toJSONString((Object)deleteEo));
            this.cupTradeFlowRecordDas.logicDelete((BaseEo)deleteEo);
            List eoList = list.stream().map(vo -> {
                CupTradeFlowRecordEo eo = new CupTradeFlowRecordEo();
                BeanUtils.copyProperties((Object)vo, (Object)eo);
                if (null != vo.getTradeDate()) {
                    eo.setTradeDate(dateFormat.format(vo.getTradeDate()));
                }
                return eo;
            }).collect(Collectors.toList());
            this.cupTradeFlowRecordDas.insertBatch(eoList);
            return;
        }
        this.logger.info("\u65e0\u8bb0\u5f55\u4fe1\u606f");
    }

    @Override
    public List<CupTradeFlowExcelVo> parseFLowFile(String fileName) {
        this.logger.info("\u83b7\u53d6\u94f6\u8054\u4ea4\u6613\u6d41\u6c34\u6587\u4ef6\u5e76\u89e3\u6790\uff1a{}", (Object)fileName);
        InputStream inputStream = FtpUtil.getFile(this.cupFtpConfig.getUrl(), this.cupFtpConfig.getUsername(), this.cupFtpConfig.getPassword(), fileName);
        ImportParams params = new ImportParams();
        params.setTitleRows(2);
        try {
            ExcelImportResult objectExcelImportResult = ExcelImportUtil.importExcelMore((InputStream)inputStream, CupTradeFlowExcelVo.class, (ImportParams)params);
            List<CupTradeFlowExcelVo> list = new ArrayList<CupTradeFlowExcelVo>();
            CubeBeanUtils.copyCollection(list, (Collection)objectExcelImportResult.getList(), CupTradeFlowExcelVo.class);
            list = this.clearEmptyExcelImportResult(list);
            list.forEach(l -> l.setFileName(fileName));
            List<CupTradeFlowExcelVo> list2 = list;
            return list2;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BizException("-1", "parseFLowFile\u89e3\u6790\u6587\u4ef6\u5f02\u5e38");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                this.logger.error("\u6d41\u5173\u95ed\u5f02\u5e38");
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private List<CupTradeFlowExcelVo> clearEmptyExcelImportResult(List<CupTradeFlowExcelVo> list) {
        return list.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getFlowNo())).collect(Collectors.toList());
    }

    @Override
    public List<QuerySplitLogAmountRespDto> cupSplitAmount(CupSplitAmountReqDto reqDto) {
        return this.cupTradeFlowRecordMapper.cupSplitAmount(reqDto);
    }
}

