/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.tcbj.api.query.ISplitOrderQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.constant.ArrivalUploadStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeBalanceTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.TradeBaseResponse;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.AccountOptReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.ShareBenefitBaseDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.TradeSettlementFlowReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.biz.config.DelayRoutingConfig;
import com.dtyunxi.tcbj.center.settlement.biz.constant.SettlementTradeEntireStatusEnum;
import com.dtyunxi.tcbj.center.settlement.biz.service.IShareBenefitService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ITradeSettlementFlowService;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.PaySettlementHelperAbstract;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.SettlementAccountOptService;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementArrivalUploadDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.TradeSettlementFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SettlementArrivalUploadEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.dtyunxi.vo.BaseVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderShareBenefitService
extends PaySettlementHelperAbstract<ShareBenefitBaseDto> {
    private Logger logger = LoggerFactory.getLogger(OrderShareBenefitService.class);
    @Resource
    private ITradeSettlementFlowService tradeSettlementFlowService;
    @Resource
    private SettlementAccountOptService settlementAccountOptService;
    @Resource
    private TradeSettlementFlowDas tradeSettlementFlowDas;
    @Resource
    private IShareBenefitService shareBenefitService;
    @Resource
    private ILockService lockService;
    @Resource
    private SettlementArrivalUploadDas settlementArrivalUploadDas;
    @Resource
    private ISplitOrderQueryApi splitOrderQueryApi;
    @Resource
    private DelayRoutingConfig delayRoutingConfig;

    @Override
    public TradeBaseResponse<ShareBenefitBaseDto> executeProcess(ShareBenefitBaseDto dto) {
        this.logger.info("\u5df2\u5f03\u7528\uff01");
        return null;
    }

    @Override
    public TradeBaseResponse<ShareBenefitBaseDto> checkAndBuild(ShareBenefitBaseDto dto) {
        this.logger.info("\u3010\u5206\u8d26\u670d\u52a1\u3011checkAndBuild\uff0c\u5728\u7ebf\u652f\u4ed8\u5206\u8d26\uff0c\u6821\u9a8c\u548c\u6784\u5efa\u5206\u652f\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        TradeSettlementFlowReqDto createTradeFlow = new TradeSettlementFlowReqDto();
        createTradeFlow.setOptAccountNo(dto.getFormerTradeFlow().getSettlementAccountNo());
        createTradeFlow.setOptAccountName(dto.getFormerTradeFlow().getSettlementAccountName());
        createTradeFlow.setOptAccountType(dto.getFormerTradeFlow().getSettlementAccountType());
        createTradeFlow.setSettlementAccountNo(dto.getFormerTradeFlow().getSettlementAccountNo());
        createTradeFlow.setSettlementAccountName(dto.getFormerTradeFlow().getSettlementAccountName());
        createTradeFlow.setSettlementAccountType(dto.getFormerTradeFlow().getSettlementAccountType());
        createTradeFlow.setOptTradeNo(dto.getOrderNo());
        BigDecimal amount = dto.getFormerTradeFlow().getLaunchTradeAmount().add(dto.getFormerTradeFlow().getTradePoundage()).subtract(dto.getFormerTradeFlow().getTradePayParnterPoundage());
        createTradeFlow.setLaunchTradeAmount(amount);
        createTradeFlow.setTradeAmount(createTradeFlow.getLaunchTradeAmount());
        createTradeFlow.setTradePoundage(dto.getFormerTradeFlow().getTradePoundage());
        createTradeFlow.setTradePoundageRate(dto.getFormerTradeFlow().getTradePoundageRate());
        createTradeFlow.setTradePayParnterPoundage(dto.getFormerTradeFlow().getTradePayParnterPoundage());
        createTradeFlow.setTradePayParnterRate(dto.getFormerTradeFlow().getTradePayParnterRate());
        createTradeFlow.setPaymentUploadFlowId(dto.getFormerTradeFlow().getPaymentUploadFlowId());
        createTradeFlow.setRoutingTimer(this.delayRoutingConfig.calculateStartRoutingDate(dto.getRequestTime()));
        dto.setTradeFlowParam(createTradeFlow);
        return new TradeBaseResponse((Object)dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TradeBaseResponse<ShareBenefitBaseDto> before(ShareBenefitBaseDto dto) {
        this.logger.info("\u3010\u5206\u8d26\u670d\u52a1\u3011before\uff0c\u521b\u5efa\u5206\u8d26\u4ea4\u6613\uff0c\u51bb\u7ed3\u5728\u9014\u6b3e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        dto.getTradeFlowParam().setTradeType(SettlementFlowTradeTypeEnum.ROUTING.getCode());
        dto.getTradeFlowParam().setTradeStatus(SettlementFlowTradeStatusEnum.CREATED.getCode());
        dto.getTradeFlowParam().setTradeEntireStatus(SettlementTradeEntireStatusEnum.NOTSTART.getCode());
        TradeSettlementFlowEo tradeFlow = super.createTradeFlow(dto);
        TradeSettlementFlowRespDto respDto = new TradeSettlementFlowRespDto();
        DtoHelper.eo2Dto((BaseEo)tradeFlow, (BaseVo)respDto);
        dto.setTradeFlow(respDto);
        ArrayList<SettlementAccountFlowRespDto> accountFlowList = new ArrayList<SettlementAccountFlowRespDto>();
        AccountOptReqDto orderAmountFreeze = new AccountOptReqDto();
        orderAmountFreeze.setAccountNo(dto.getTradeFlow().getSettlementAccountNo());
        orderAmountFreeze.setAccountFlowType(SettlementAccountFlowTypeEnum.SALES_SETTLE.getCode());
        orderAmountFreeze.setChangeBalance(dto.getFormerTradeFlow().getLaunchTradeAmount());
        orderAmountFreeze.setChangeType(SettlementAccountFlowChangeTypeEnum.EXPENSE.getCode());
        orderAmountFreeze.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.ROUTE_BALANCE.getCode());
        orderAmountFreeze.setLinkedTradeNo(tradeFlow.getTradeNo());
        orderAmountFreeze.setLinkedParentTradeNo(tradeFlow.getParentTradeNo());
        orderAmountFreeze.setRouteFrozen(orderAmountFreeze.getChangeBalance());
        orderAmountFreeze.setType(Integer.valueOf(1));
        accountFlowList.add(this.settlementAccountOptService.optAccountFrozen(orderAmountFreeze));
        if (ObjectUtils.isNotEmpty((Object)dto.getFormerTradeFlow().getTradePoundage()) && dto.getFormerTradeFlow().getTradePoundage().compareTo(BigDecimal.ZERO) > 0) {
            AccountOptReqDto feeAmountFreeze = new AccountOptReqDto();
            feeAmountFreeze.setAccountNo(dto.getTradeFlow().getSettlementAccountNo());
            feeAmountFreeze.setAccountFlowType(SettlementAccountFlowTypeEnum.CLIENT_FEE_SETTLE.getCode());
            feeAmountFreeze.setChangeBalance(dto.getFormerTradeFlow().getTradePoundage());
            feeAmountFreeze.setChangeType(SettlementAccountFlowChangeTypeEnum.EXPENSE.getCode());
            feeAmountFreeze.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.ROUTE_BALANCE.getCode());
            feeAmountFreeze.setLinkedTradeNo(tradeFlow.getTradeNo());
            feeAmountFreeze.setLinkedParentTradeNo(tradeFlow.getParentTradeNo());
            feeAmountFreeze.setRouteFrozen(feeAmountFreeze.getChangeBalance());
            feeAmountFreeze.setType(Integer.valueOf(1));
            accountFlowList.add(this.settlementAccountOptService.optAccountFrozen(feeAmountFreeze));
        }
        dto.setOptAccountFlowList(accountFlowList);
        return new TradeBaseResponse((Object)dto);
    }

    @Override
    public TradeBaseResponse<ShareBenefitBaseDto> run(ShareBenefitBaseDto dto) {
        this.logger.info("\u3010\u5206\u8d26\u670d\u52a1\u3011run\uff0c\u4fee\u6539\u5206\u8d26\u4ea4\u6613\u4e3a\u53d7\u7406\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (StringUtils.isEmpty((CharSequence)dto.getFormerTradeFlow().getPaymentUploadFlowId())) {
            this.shareBenefitService.uploadPayShareBenefit(dto.getFormerTradeFlow());
            return new TradeBaseResponse((Object)dto);
        }
        TradeSettlementFlowEo updateTradeAccept = new TradeSettlementFlowEo();
        updateTradeAccept.setId(dto.getTradeFlow().getId());
        updateTradeAccept.setTradeStatus(SettlementFlowTradeStatusEnum.ACCEPT.getCode());
        super.updateTradeFlow(updateTradeAccept);
        return new TradeBaseResponse((Object)dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TradeBaseResponse<ShareBenefitBaseDto> after(ShareBenefitBaseDto dto) {
        this.logger.info("\u3010\u5206\u8d26\u670d\u52a1\u3011after\uff0c\u4fee\u6539\u5206\u8d26\u4ea4\u6613\u4e3a\u5b8c\u6210\uff0c\u66f4\u65b0\u8d26\u6237\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        TradeSettlementFlowRespDto updateTradeSuccess = new TradeSettlementFlowRespDto();
        updateTradeSuccess.setId(dto.getTradeFlow().getId());
        updateTradeSuccess.setTradeStatus(SettlementFlowTradeStatusEnum.SUCCESS.getCode());
        updateTradeSuccess.setTradeEntireStatus(SettlementTradeEntireStatusEnum.COMPLETE.getCode());
        updateTradeSuccess.setTradeEntireSucTime(new Date());
        super.updateTradeFlow(updateTradeSuccess, SettlementFlowTradeStatusEnum.ACCEPT.getCode());
        dto.getOptAccountFlowList().forEach(flow -> {
            AccountOptReqDto releaseAmount = new AccountOptReqDto();
            releaseAmount.setChangTime(new Date());
            releaseAmount.setAccountFlowNoId(flow.getId());
            releaseAmount.setAccountNo(flow.getAccountNo());
            releaseAmount.setRouteFrozen(flow.getChangeBalance());
            releaseAmount.setRouteBalance(flow.getChangeBalance());
            releaseAmount.setType(Integer.valueOf(-1));
            this.settlementAccountOptService.optAccountUpdate(releaseAmount);
        });
        AccountOptReqDto addOrderAmount = new AccountOptReqDto();
        addOrderAmount.setAccountNo(dto.getTradeFlow().getSettlementAccountNo());
        addOrderAmount.setAccountFlowType(SettlementAccountFlowTypeEnum.SALES_SETTLE.getCode());
        addOrderAmount.setChangeBalance(dto.getFormerTradeFlow().getLaunchTradeAmount());
        addOrderAmount.setChangeType(SettlementAccountFlowChangeTypeEnum.INCOME.getCode());
        addOrderAmount.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.BALANCE.getCode());
        addOrderAmount.setLinkedTradeNo(dto.getTradeFlow().getTradeNo());
        addOrderAmount.setLinkedParentTradeNo(dto.getTradeFlow().getParentTradeNo());
        addOrderAmount.setBalance(addOrderAmount.getChangeBalance());
        addOrderAmount.setType(Integer.valueOf(1));
        this.settlementAccountOptService.optAccountFinish(addOrderAmount);
        if (ObjectUtils.isNotEmpty((Object)dto.getFormerTradeFlow().getTradePayParnterPoundage()) && dto.getFormerTradeFlow().getTradePayParnterPoundage().compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal total = dto.getFormerTradeFlow().getTradePayParnterPoundage().subtract(dto.getFormerTradeFlow().getTradePoundage());
            this.logger.info("\u5546\u5bb6\u627f\u62c5\u624b\u7eed\u8d39\uff1a{}", (Object)JSON.toJSONString((Object)total));
            if (total.compareTo(BigDecimal.ZERO) > 0) {
                AccountOptReqDto reduceFeeAmount = new AccountOptReqDto();
                reduceFeeAmount.setAccountNo(dto.getTradeFlow().getSettlementAccountNo());
                reduceFeeAmount.setAccountFlowType(SettlementAccountFlowTypeEnum.BUSINESS_FEE.getCode());
                reduceFeeAmount.setChangeBalance(total);
                reduceFeeAmount.setChangeType(SettlementAccountFlowChangeTypeEnum.EXPENSE.getCode());
                reduceFeeAmount.setChangeBalanceType(SettlementAccountFlowChangeBalanceTypeEnum.BALANCE.getCode());
                reduceFeeAmount.setLinkedTradeNo(dto.getTradeFlow().getTradeNo());
                reduceFeeAmount.setLinkedParentTradeNo(dto.getTradeFlow().getParentTradeNo());
                reduceFeeAmount.setBalance(reduceFeeAmount.getChangeBalance());
                reduceFeeAmount.setType(Integer.valueOf(-1));
                this.settlementAccountOptService.optAccountFinish(reduceFeeAmount);
            }
        }
        try {
            SettlementArrivalUploadEo createEo = new SettlementArrivalUploadEo();
            createEo.setAccountNo(dto.getTradeFlow().getOptAccountNo());
            createEo.setLinkedTradeNo(dto.getTradeFlow().getTradeNo());
            createEo.setUploadStatus(ArrivalUploadStatusEnum.SUCCESS.getCode());
            this.settlementArrivalUploadDas.insert((BaseEo)createEo);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

