/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeBalanceTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowChangeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SettlementAccountFlowParamReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.SettlementAccountFlowReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.TradeSettlementFlowReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountFlowService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ITradeSettlementFlowService;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SettlementAccountFlowEo;
import com.dtyunxi.tcbj.center.settlement.dao.vo.SettlementAccountFlowVo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SettlementAccountFlowServiceImpl
implements ISettlementAccountFlowService {
    private Logger logger = LoggerFactory.getLogger(SettlementAccountFlowServiceImpl.class);
    @Resource
    private SettlementAccountFlowDas settlementAccountFlowDas;
    @Resource
    private ITradeSettlementFlowService tradeSettlementFlowService;

    @Override
    public Long addSettlementAccountFlow(SettlementAccountFlowReqDto addReqDto) {
        SettlementAccountFlowEo settlementAccountFlowEo = new SettlementAccountFlowEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)settlementAccountFlowEo);
        this.settlementAccountFlowDas.insert((BaseEo)settlementAccountFlowEo);
        return settlementAccountFlowEo.getId();
    }

    @Override
    public void modifySettlementAccountFlow(SettlementAccountFlowReqDto modifyReqDto) {
        SettlementAccountFlowEo settlementAccountFlowEo = new SettlementAccountFlowEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)settlementAccountFlowEo);
        this.settlementAccountFlowDas.updateSelective((BaseEo)settlementAccountFlowEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSettlementAccountFlow(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.settlementAccountFlowDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SettlementAccountFlowRespDto queryById(Long id) {
        SettlementAccountFlowEo settlementAccountFlowEo = (SettlementAccountFlowEo)this.settlementAccountFlowDas.selectByPrimaryKey(id);
        SettlementAccountFlowRespDto settlementAccountFlowRespDto = new SettlementAccountFlowRespDto();
        DtoHelper.eo2Dto((BaseEo)settlementAccountFlowEo, (BaseVo)settlementAccountFlowRespDto);
        return settlementAccountFlowRespDto;
    }

    @Override
    public PageInfo<SettlementAccountFlowRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SettlementAccountFlowReqDto settlementAccountFlowReqDto = (SettlementAccountFlowReqDto)JSON.parseObject((String)filter, SettlementAccountFlowReqDto.class);
        SettlementAccountFlowEo settlementAccountFlowEo = new SettlementAccountFlowEo();
        DtoHelper.dto2Eo((BaseVo)settlementAccountFlowReqDto, (BaseEo)settlementAccountFlowEo);
        PageInfo eoPageInfo = this.settlementAccountFlowDas.selectPage((BaseEo)settlementAccountFlowEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SettlementAccountFlowRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<SettlementAccountFlowRespDto> queryPageByAccount(SettlementAccountFlowParamReqDto dto) {
        SettlementAccountFlowVo flowVo = new SettlementAccountFlowVo();
        flowVo.setAccountFlowStatus(dto.getAccountFlowStatus());
        flowVo.setAccountNo(dto.getAccountNo());
        flowVo.setChangeBalanceType(dto.getChangeBalanceType());
        flowVo.setChangeType(dto.getChangeType());
        flowVo.setAccountFlowType(dto.getAccountFlowType());
        flowVo.setOptTradeNo(dto.getOptTradeNo());
        if (ObjectUtils.isNotEmpty((Object)dto.getChangeTimeStart()) && ObjectUtils.isNotEmpty((Object)dto.getChangeTimeEnd())) {
            flowVo.setChangeTimeStart(dto.getChangeTimeStart());
            flowVo.setChangeTimeEnd(dto.getChangeTimeEnd());
        }
        PageInfo settlementAccountFlowVoPageInfo = this.settlementAccountFlowDas.queryPageByAccount(flowVo, dto.getPageNum(), dto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)settlementAccountFlowVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)settlementAccountFlowVoPageInfo.getList(), SettlementAccountFlowRespDto.class);
        for (SettlementAccountFlowRespDto respDto : dtoList) {
            respDto.setAccountFlowTypeStr(SettlementAccountFlowTypeEnum.getName((String)respDto.getAccountFlowType()));
            respDto.setAccountFlowStatusStr(SettlementAccountFlowStatusEnum.getName((String)respDto.getAccountFlowStatus()));
            respDto.setChangeTypeStr(SettlementAccountFlowChangeTypeEnum.getName((Integer)respDto.getChangeType()));
            respDto.setChangeBalanceTypeStr(SettlementAccountFlowChangeBalanceTypeEnum.getName((String)respDto.getChangeBalanceType()));
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public SettlementAccountFlowRespDto queryDetail(SettlementAccountFlowReqDto dto) {
        SettlementAccountFlowEo accountFlowParam = new SettlementAccountFlowEo();
        if (ObjectUtils.isNotEmpty((Object)dto.getId())) {
            accountFlowParam.setId(dto.getId());
        }
        SettlementAccountFlowEo accountFlowEo = (SettlementAccountFlowEo)this.settlementAccountFlowDas.selectOne((BaseEo)accountFlowParam);
        SettlementAccountFlowRespDto accountFlowRespDto = new SettlementAccountFlowRespDto();
        DtoHelper.eo2Dto((BaseEo)accountFlowEo, (BaseVo)accountFlowRespDto);
        accountFlowRespDto.setAccountFlowTypeStr(SettlementAccountFlowTypeEnum.getName((String)accountFlowRespDto.getAccountFlowType()));
        accountFlowRespDto.setAccountFlowStatusStr(SettlementAccountFlowStatusEnum.getName((String)accountFlowRespDto.getAccountFlowStatus()));
        accountFlowRespDto.setChangeBalanceTypeStr(SettlementAccountFlowChangeBalanceTypeEnum.getName((String)accountFlowRespDto.getChangeBalanceType()));
        accountFlowRespDto.setChangeTypeStr(SettlementAccountFlowChangeTypeEnum.getName((Integer)accountFlowRespDto.getChangeType()));
        TradeSettlementFlowReqDto flowReqDto = new TradeSettlementFlowReqDto();
        flowReqDto.setParentTradeNo(accountFlowRespDto.getLinkedParentTradeNo());
        flowReqDto.setTradeNo(accountFlowRespDto.getLinkedTradeNo());
        List<TradeSettlementFlowRespDto> list = this.tradeSettlementFlowService.queryList(flowReqDto);
        accountFlowRespDto.setTradeFlowList(list);
        return accountFlowRespDto;
    }

    @Override
    public List<SettlementAccountFlowRespDto> queryListByTradeFlow(String tradeNo, String parentTradeNo) {
        this.logger.info("\u83b7\u53d6\u4ea4\u6613\u6d41\u6c34\u5bf9\u5e94\u7684\u8d26\u6237\u53d8\u52a8\u6d41\u6c34\uff1a{}=={}", (Object)tradeNo, (Object)parentTradeNo);
        if (StringUtils.isBlank((CharSequence)tradeNo) && StringUtils.isBlank((CharSequence)parentTradeNo)) {
            throw new BizException("-1", "\u53c2\u6570\u8bf7\u6c42\u5f02\u5e38");
        }
        SettlementAccountFlowEo params = new SettlementAccountFlowEo();
        if (StringUtils.isNotBlank((CharSequence)tradeNo)) {
            params.setLinkedTradeNo(tradeNo);
        }
        if (StringUtils.isNotBlank((CharSequence)parentTradeNo)) {
            params.setLinkedParentTradeNo(parentTradeNo);
        }
        List select = this.settlementAccountFlowDas.select((BaseEo)params);
        ArrayList<SettlementAccountFlowRespDto> list = new ArrayList<SettlementAccountFlowRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, list, SettlementAccountFlowRespDto.class);
        return list;
    }
}

