/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountFlowStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementAccountStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.AccountOptReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRespDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.settlement.api.exception.SettlementExceptionCode;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountService;
import com.dtyunxi.tcbj.center.settlement.biz.utils.TradeUtil;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.SettlementAccountFlowEo;
import com.dtyunxi.tcbj.center.settlement.dao.vo.SettlementAccountVo;
import com.dtyunxi.vo.BaseVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SettlementAccountOptService {
    private Logger logger = LoggerFactory.getLogger(SettlementAccountOptService.class);
    public static final int ADD = 1;
    public static final int DEDUCT = -1;
    @Resource
    private ISettlementAccountService settlementAccountService;
    @Resource
    private SettlementAccountDas settlementAccountDas;
    @Resource
    private SettlementAccountFlowDas settlementAccountFlowDas;

    @Transactional(rollbackFor={Exception.class})
    public String optAccountFinish(AccountOptReqDto dto) {
        this.logger.info("\u64cd\u4f5c\u8d26\u6237\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (ObjectUtils.isEmpty((Object)dto)) {
            throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
        }
        this.checkCommonParam(dto);
        SettlementAccountRespDto accountRespDto = this.settlementAccountService.queryByAccountNo(dto.getAccountNo());
        this.checkAccountStatus(accountRespDto);
        this.checkAccountFlowRepeat(dto, accountRespDto);
        SettlementAccountVo accountVo = new SettlementAccountVo();
        accountVo.setId(accountRespDto.getId());
        accountVo.setBalance(dto.getBalance());
        accountVo.setRouteBalance(dto.getRouteBalance());
        int i = 0;
        i = dto.getType() == 1 ? this.settlementAccountDas.addBalance(accountVo) : this.settlementAccountDas.deductBalance(accountVo);
        if (i != 1) {
            throw new BizException(SettlementExceptionCode.UPDATE_ACCOUNT_FAIL.getCode(), SettlementExceptionCode.UPDATE_ACCOUNT_FAIL.getMsg());
        }
        if (dto.getChangTime() == null) {
            dto.setChangTime(new Date());
        }
        SettlementAccountRespDto account = this.settlementAccountService.queryByAccountNo(dto.getAccountNo());
        SettlementAccountFlowEo flow = this.createFlow(dto, account, SettlementAccountFlowStatusEnum.SUCCESS.getCode(), account.getBalance(), account.getRouteBalance());
        return flow.getAccountFlowNo();
    }

    private void checkAccountStatus(SettlementAccountRespDto accountRespDto) {
        if (!accountRespDto.getAccountStatus().equals(SettlementAccountStatusEnum.ENABLED.getCode())) {
            throw new BizException("-1", "\u8d26\u6237\u72b6\u6001\u5f02\u5e38");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public SettlementAccountFlowRespDto optAccountFrozen(AccountOptReqDto dto) {
        this.logger.info("\u64cd\u4f5c\u8d26\u6237\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (ObjectUtils.isEmpty((Object)dto)) {
            throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
        }
        this.checkCommonParam(dto);
        SettlementAccountRespDto accountRespDto = this.settlementAccountService.queryByAccountNo(dto.getAccountNo());
        this.checkAccountStatus(accountRespDto);
        this.checkAccountFlowRepeat(dto, accountRespDto);
        SettlementAccountVo accountVo = new SettlementAccountVo();
        accountVo.setId(accountRespDto.getId());
        accountVo.setFrozen(dto.getFrozen());
        accountVo.setRouteFrozen(dto.getRouteFrozen());
        int i = 0;
        i = dto.getType() == 1 ? this.settlementAccountDas.addBalance(accountVo) : this.settlementAccountDas.deductBalance(accountVo);
        if (i != 1) {
            throw new BizException("-1", "\u64cd\u4f5c\u8d26\u6237\u91d1\u989d\u5f02\u5e38");
        }
        SettlementAccountRespDto account = this.settlementAccountService.queryByAccountNo(dto.getAccountNo());
        SettlementAccountFlowEo flow = this.createFlow(dto, account, SettlementAccountFlowStatusEnum.CREATED.getCode(), account.getBalance(), account.getRouteBalance());
        SettlementAccountFlowRespDto respDto = new SettlementAccountFlowRespDto();
        DtoHelper.eo2Dto((BaseEo)flow, (BaseVo)respDto);
        return respDto;
    }

    @Transactional(rollbackFor={Exception.class})
    public int rollbackAmount(AccountOptReqDto dto) {
        AssertUtils.notBlank((String)dto.getAccountNo(), (String)"accountNo \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.logger.info("\u64cd\u4f5c\u8d26\u6237\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        SettlementAccountRespDto accountRespDto = this.settlementAccountService.queryByAccountNo(dto.getAccountNo());
        this.checkAccountStatus(accountRespDto);
        AssertUtils.notNull((Object)accountRespDto, (String)String.format("accountNo=%s \u8d26\u6237\u4e0d\u5b58\u5728\uff01", dto.getAccountNo()));
        SettlementAccountVo accountVo = new SettlementAccountVo();
        accountVo.setId(accountRespDto.getId());
        accountVo.setFrozen(dto.getFrozen());
        accountVo.setRouteFrozen(dto.getRouteFrozen());
        int i = 0;
        i = dto.getType() == 1 ? this.settlementAccountDas.addBalance(accountVo) : this.settlementAccountDas.deductBalance(accountVo);
        if (i != 1) {
            throw new BizException("-1", "\u64cd\u4f5c\u8d26\u6237\u91d1\u989d\u5f02\u5e38");
        }
        return i;
    }

    @Transactional(rollbackFor={Exception.class})
    public void optAccountUpdate(AccountOptReqDto dto) {
        this.logger.info("\u64cd\u4f5c\u8d26\u6237\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        if (ObjectUtils.isEmpty((Object)dto.getAccountFlowNoId())) {
            throw new BizException("-1", "\u53c2\u6570\u8bf7\u6c42\u5f02\u5e38\uff0c\u8d26\u6237\u6d41\u6c34ID\u5fc5\u4f20");
        }
        if (ObjectUtils.isEmpty((Object)dto.getAccountNo())) {
            throw new BizException("-1", "\u53c2\u6570\u8bf7\u6c42\u5f02\u5e38\uff0c\u8d26\u6237no\u5fc5\u4f20");
        }
        SettlementAccountRespDto accountRespDto = this.settlementAccountService.queryByAccountNo(dto.getAccountNo());
        this.checkAccountStatus(accountRespDto);
        SettlementAccountVo accountVo = new SettlementAccountVo();
        accountVo.setId(accountRespDto.getId());
        accountVo.setAccountNo(dto.getAccountNo());
        accountVo.setBalance(dto.getBalance());
        accountVo.setFrozen(dto.getFrozen());
        accountVo.setRouteBalance(dto.getRouteBalance());
        accountVo.setRouteFrozen(dto.getRouteFrozen());
        int i = 0;
        i = dto.getType() == 1 ? this.settlementAccountDas.addBalance(accountVo) : this.settlementAccountDas.deductBalance(accountVo);
        if (i != 1) {
            throw new BizException("-1", "\u64cd\u4f5c\u8d26\u6237\u91d1\u989d\u5f02\u5e38");
        }
        SettlementAccountRespDto account = this.settlementAccountService.queryByAccountNo(dto.getAccountNo());
        SettlementAccountFlowEo accountFlowEo = new SettlementAccountFlowEo();
        accountFlowEo.setId(dto.getAccountFlowNoId());
        accountFlowEo.setAccountFlowStatus(SettlementAccountFlowStatusEnum.SUCCESS.getCode());
        if (StringUtils.isNotEmpty((CharSequence)dto.getAccountFlowStatus())) {
            accountFlowEo.setAccountFlowStatus(dto.getAccountFlowStatus());
        }
        accountFlowEo.setAfterBalance(account.getBalance());
        accountFlowEo.setAfterRouteBalance(account.getRouteBalance());
        if (dto.getChangTime() == null) {
            accountFlowEo.setChangeTime(new Date());
        } else {
            accountFlowEo.setChangeTime(dto.getChangTime());
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.ne((String)"account_flow_status", (Object)SettlementAccountFlowStatusEnum.SUCCESS.getCode()));
        accountFlowEo.setSqlFilters(sqlFilters);
        int j = this.settlementAccountFlowDas.updateSelective((BaseEo)accountFlowEo);
        if (j != 1) {
            throw new BizException("-1", "\u64cd\u4f5c\u8d26\u6237\u6d41\u6c34\u66f4\u65b0\u5f02\u5e38");
        }
    }

    private void checkAccountFlowRepeat(AccountOptReqDto dto, SettlementAccountRespDto accountRespDto) {
        SettlementAccountFlowEo accountFlowEo = new SettlementAccountFlowEo();
        accountFlowEo.setLinkedParentTradeNo(dto.getLinkedParentTradeNo());
        accountFlowEo.setLinkedTradeNo(dto.getLinkedTradeNo());
        accountFlowEo.setChangeBalanceType(dto.getChangeBalanceType());
        accountFlowEo.setAccountFlowType(dto.getAccountFlowType());
        accountFlowEo.setAccountNo(accountRespDto.getAccountNo());
        SettlementAccountFlowEo accountFlow = (SettlementAccountFlowEo)this.settlementAccountFlowDas.selectOne((BaseEo)accountFlowEo);
        if (accountFlow != null) {
            throw new BizException("-1", "\u6d41\u6c34\u91cd\u590d\u63d2\u5165");
        }
    }

    private SettlementAccountFlowEo createFlow(AccountOptReqDto dto, SettlementAccountRespDto account, String flowStatus, BigDecimal afterBalance, BigDecimal afterRouteBalance) {
        SettlementAccountFlowEo accountFlowEo = new SettlementAccountFlowEo();
        accountFlowEo.setAccountFlowNo(TradeUtil.generateAccountFlowNo());
        accountFlowEo.setAccountFlowType(dto.getAccountFlowType());
        accountFlowEo.setAccountFlowStatus(flowStatus);
        accountFlowEo.setAccountNo(account.getAccountNo());
        accountFlowEo.setAccountName(account.getAccountName());
        accountFlowEo.setAccountType(account.getAccountType());
        accountFlowEo.setChangeBalance(dto.getChangeBalance());
        accountFlowEo.setAfterBalance(afterBalance);
        accountFlowEo.setAfterRouteBalance(afterRouteBalance);
        accountFlowEo.setChangeType(dto.getChangeType());
        accountFlowEo.setChangeBalanceType(dto.getChangeBalanceType());
        accountFlowEo.setLinkedTradeNo(dto.getLinkedTradeNo());
        accountFlowEo.setLinkedParentTradeNo(dto.getLinkedParentTradeNo());
        accountFlowEo.setChangeTime(dto.getChangTime());
        accountFlowEo.setWithdramCardId(dto.getWithdramCardId());
        accountFlowEo.setWithdramCardJson(dto.getWithdramCardJson());
        this.settlementAccountFlowDas.insert((BaseEo)accountFlowEo);
        return accountFlowEo;
    }

    private void checkCommonParam(AccountOptReqDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getLinkedParentTradeNo())) {
            throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
        }
        if (dto.getChangeType() == null) {
            throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
        }
        if (StringUtils.isEmpty((CharSequence)dto.getChangeBalanceType())) {
            throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
        }
        if (StringUtils.isEmpty((CharSequence)dto.getAccountFlowType())) {
            throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
        }
        if (StringUtils.isEmpty((CharSequence)dto.getAccountNo())) {
            throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
        }
        if (ObjectUtils.isEmpty((Object)dto.getChangeBalance()) || dto.getChangeBalance().compareTo(BigDecimal.ZERO) <= 0) {
            throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
        }
        if (ObjectUtils.isEmpty((Object)dto.getBalance()) && ObjectUtils.isEmpty((Object)dto.getFrozen()) && ObjectUtils.isEmpty((Object)dto.getRouteBalance()) && ObjectUtils.isEmpty((Object)dto.getRouteFrozen())) {
            throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
        }
        if (ObjectUtils.isEmpty((Object)dto.getType())) {
            throw new BizException(SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getCode(), SettlementExceptionCode.REQUEST_PARAMS_EXCEPTION.getMsg());
        }
    }
}

