/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.IPaymentCheckOrderApi;
import com.dtyunxi.tcbj.api.ISplitOrderApi;
import com.dtyunxi.tcbj.api.dto.request.CiticTransStateQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.SplitOrderAddReqDto;
import com.dtyunxi.tcbj.api.dto.request.SplitOrderClearReqDto;
import com.dtyunxi.tcbj.api.dto.response.CiticTransStateQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.SplitOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.SystemCalendarRespDto;
import com.dtyunxi.tcbj.api.enums.citic.CiticBussTransTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticFeeTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticFundSourceEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticFundTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticPayTransTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticRspCodeEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticSplitDealStatusEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticSplitOrderResultEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticTransStateEnum;
import com.dtyunxi.tcbj.api.enums.citic.CiticTransTypeEnum;
import com.dtyunxi.tcbj.api.enums.citic.SystemCalendarTypeEnum;
import com.dtyunxi.tcbj.api.query.ICiticQueryApi;
import com.dtyunxi.tcbj.api.query.ISplitOrderQueryApi;
import com.dtyunxi.tcbj.api.query.ISystemCalendarQueryApi;
import com.dtyunxi.tcbj.center.settlement.api.constant.PaymentWayEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.TradeSettlementCloseStatusTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.TradeBaseResponse;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.ShareBenefitBaseDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.ShareBenefitReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.TradeSettlementFlowReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.TransferBaseDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SettlementAccountRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.TradeSettlementFlowRespDto;
import com.dtyunxi.tcbj.center.settlement.api.exception.AssertUtils;
import com.dtyunxi.tcbj.center.settlement.api.exception.SettlementExceptionCode;
import com.dtyunxi.tcbj.center.settlement.biz.constant.DingdingSender;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountFlowService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ISettlementAccountService;
import com.dtyunxi.tcbj.center.settlement.biz.service.IShareBenefitService;
import com.dtyunxi.tcbj.center.settlement.biz.service.ITradeSettlementFlowService;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.OrderShareBenefitService;
import com.dtyunxi.tcbj.center.settlement.biz.service.impl.TransferService;
import com.dtyunxi.tcbj.center.settlement.biz.utils.DateUtil;
import com.dtyunxi.tcbj.center.settlement.biz.utils.TradeUtil;
import com.dtyunxi.tcbj.center.settlement.dao.das.SettlementAccountFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.TradeSettlementFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.dtyunxi.tcbj.center.settlement.dao.vo.QueryTradeSettlementFlowVo;
import com.dtyunxi.vo.BaseVo;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ShareBenefitServiceImpl
implements IShareBenefitService {
    private Logger logger = LoggerFactory.getLogger(ShareBenefitServiceImpl.class);
    @Resource
    private ISplitOrderApi splitOrderApi;
    @Resource
    private ISettlementAccountService settlementAccountService;
    @Resource
    private OrderShareBenefitService shareBenefitService;
    @Resource
    private TradeSettlementFlowDas tradeSettlementFlowDas;
    @Resource
    private TransferService transferService;
    @Resource
    private ICiticQueryApi citicQueryApi;
    @Resource
    private SettlementAccountFlowDas settlementAccountFlowDas;
    @Resource
    private ISplitOrderQueryApi splitOrderQueryApi;
    @Resource
    private ILockService lockService;
    @Resource
    private OrderShareBenefitService orderShareBenefitService;
    @Resource
    private IPaymentCheckOrderApi paymentCheckOrderApi;
    @Resource
    private DingdingSender dingdingSender;
    @Resource
    private ITradeSettlementFlowService tradeSettlementFlowService;
    @Resource
    private ISettlementAccountFlowService settlementAccountFlowService;
    @Resource
    private ISystemCalendarQueryApi systemCalendarQueryApi;

    @Override
    public String uploadPayShareBenefit(TradeSettlementFlowRespDto tradeFlow) {
        this.logger.info("\u4e0a\u4f20\u652f\u4ed8\u6e05\u5206\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)tradeFlow));
        SplitOrderAddReqDto splitOrderAddReqDto = this.buildSplitOrder(tradeFlow, tradeFlow, CiticPayTransTypeEnum.PAY.key, CiticBussTransTypeEnum.REAL_TIME_PAY.key);
        this.logger.info("\u6784\u5efa\u4e0a\u4f20\u652f\u4ed8\u6e05\u5206\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderAddReqDto));
        RestResponse response = this.splitOrderApi.addSplitOrder(splitOrderAddReqDto);
        this.logger.info("\u54cd\u5e94\u4e0a\u4f20\u652f\u4ed8\u6e05\u5206\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)response));
        if (ObjectUtils.isEmpty((Object)response.getData())) {
            throw new BizException("-1", "\u54cd\u5e94\u53c2\u6570\u5f02\u5e38");
        }
        this.updateTradeFlowUploadId(tradeFlow.getId(), ((Long)response.getData()).toString());
        return ((Long)response.getData()).toString();
    }

    @Override
    public String uploadRefundShareBenefit(TradeSettlementFlowRespDto payFlow, TradeSettlementFlowRespDto tradeFlow) {
        SplitOrderAddReqDto splitOrderAddReqDto = this.buildSplitOrder(tradeFlow, payFlow, CiticPayTransTypeEnum.RETURN.key, CiticBussTransTypeEnum.REAL_TIME_RETURN.key);
        this.logger.info("\u4e0a\u4f20\u9000\u6b3e\u6e05\u5206\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderAddReqDto));
        RestResponse response = this.splitOrderApi.addSplitOrder(splitOrderAddReqDto);
        this.logger.info("\u54cd\u5e94\u4e0a\u4f20\u9000\u6b3e\u6e05\u5206\u660e\u7ec6\uff1a{}", (Object)JSON.toJSONString((Object)response));
        if (ObjectUtils.isEmpty((Object)response.getData())) {
            throw new BizException("-1", "\u54cd\u5e94\u53c2\u6570\u5f02\u5e38");
        }
        this.updateTradeFlowUploadId(tradeFlow.getId(), ((Long)response.getData()).toString());
        return ((Long)response.getData()).toString();
    }

    @Override
    public void balancePayShareBenefitResult(String orderNo) {
    }

    @Override
    public void onlinePayShareBenefitResult(String orderNo) {
        TradeSettlementFlowEo flowEo = new TradeSettlementFlowEo();
        flowEo.setOptTradeNo(orderNo);
        flowEo.setTradeStatus(SettlementFlowTradeStatusEnum.ACCEPT.getCode());
        flowEo.setTradeType(SettlementFlowTradeTypeEnum.ROUTING.getCode());
        TradeSettlementFlowEo select = (TradeSettlementFlowEo)this.tradeSettlementFlowDas.selectOne((BaseEo)flowEo);
        if (ObjectUtils.isNotEmpty((Object)select) && !select.getTradeType().equals(PaymentWayEnum.WFT_ALIPLY_YE.getPayTypeCode())) {
            TradeSettlementFlowRespDto flowRespDto = new TradeSettlementFlowRespDto();
            DtoHelper.eo2Dto((BaseEo)select, (BaseVo)flowRespDto);
            ArrayList<TradeSettlementFlowRespDto> list = new ArrayList<TradeSettlementFlowRespDto>();
            list.add(flowRespDto);
            this.dealOnlinePayShareBenefitResult(list);
        }
        throw new BizException(SettlementExceptionCode.SEARCH_TRADE_FLOW_NOT.getCode(), SettlementExceptionCode.SEARCH_TRADE_FLOW_NOT.getMsg());
    }

    @Override
    public void pendingOnlineTrade(String orderNo) {
        TradeSettlementFlowEo flowEo = new TradeSettlementFlowEo();
        flowEo.setOptTradeNo(orderNo);
        List select = this.tradeSettlementFlowDas.select((BaseEo)flowEo);
        for (TradeSettlementFlowEo eo : select) {
            if (eo.getTradeType().equals(PaymentWayEnum.WFT_ALIPLY_YE.getPayTypeCode()) || !eo.getTradeType().equals(SettlementFlowTradeTypeEnum.PAY.getCode()) && !eo.getTradeType().equals(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode()) || !eo.getTradeStatus().equals(SettlementFlowTradeStatusEnum.CREATED.getCode()) && !eo.getTradeStatus().equals(SettlementFlowTradeStatusEnum.ACCEPT.getCode())) continue;
            TradeSettlementFlowRespDto respDto = new TradeSettlementFlowRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)respDto);
            ArrayList<TradeSettlementFlowRespDto> list = new ArrayList<TradeSettlementFlowRespDto>();
            list.add(respDto);
            this.dealPendingOnlineTrade(list);
            return;
        }
        throw new BizException(SettlementExceptionCode.SEARCH_TRADE_FLOW_NOT.getCode(), SettlementExceptionCode.SEARCH_TRADE_FLOW_NOT.getMsg());
    }

    @Override
    public void pendingUploadDetail(String orderNo, Integer type) {
        if (type == 1) {
            orderNo = TradeUtil.generateRefundNo(orderNo);
        }
        ArrayList<TradeSettlementFlowRespDto> flowList = new ArrayList<TradeSettlementFlowRespDto>();
        flowList.addAll(this.queryPendingUploadTradeFlow(orderNo));
        flowList.addAll(this.queryPendingUploadCloseTradeFlow(orderNo));
        if (CollectionUtil.isNotEmpty(flowList)) {
            this.dealPendingUploadDetail(flowList);
            return;
        }
        throw new BizException(SettlementExceptionCode.SEARCH_TRADE_FLOW_NOT.getCode(), SettlementExceptionCode.SEARCH_TRADE_FLOW_NOT.getMsg());
    }

    @Override
    public List<TradeSettlementFlowRespDto> queryPendingBalancePayTradeFlow() {
        return null;
    }

    @Override
    public List<TradeSettlementFlowRespDto> queryPendingOnlineTradeFlow() {
        return null;
    }

    @Override
    public void readyShareBenefit(Date dateStr, Integer ifCheck) {
        boolean b = true;
        if (ifCheck == 1) {
            b = this.checkFinishUploadDetailToReady(dateStr);
        }
        if (b) {
            SplitOrderClearReqDto reqDto = new SplitOrderClearReqDto();
            reqDto.setSplitDt(DateUtil.getTransDate(dateStr));
            RestResponse voidRestResponse = this.splitOrderApi.splitOrderClear(reqDto);
            if (!voidRestResponse.getResultCode().equals("0")) {
                throw new BizException("-1", voidRestResponse.getResultMsg());
            }
            return;
        }
        throw new BizException("-1", "\u68c0\u6d4b\u6709\u5c1a\u672a\u4e0a\u4f20\u6e05\u5206\u660e\u7ec6\u7684\u6d41\u6c34");
    }

    @Override
    public void dealBalancePayShareBenefitResult(List<TradeSettlementFlowRespDto> flowList) {
    }

    @Override
    public void dealOnlinePayShareBenefitResult(List<TradeSettlementFlowRespDto> flowList) {
    }

    @Override
    public void dealPendingOnlineTrade(List<TradeSettlementFlowRespDto> flowList) {
    }

    @Override
    public void dealPendingUploadDetail(List<TradeSettlementFlowRespDto> flowList) {
    }

    @Override
    public boolean checkFinishUploadDetailToReady(Date date) {
        this.logger.info("\u5f00\u59cb\u6267\u884c\u3010\u51c6\u5907\u6267\u884c\u6e05\u5206\u524d\u68c0\u6d4b\u662f\u5426\u6709\u672a\u4e0a\u4f20\u6e05\u5206\u660e\u7ec6\u3011\uff1a{}=={}", (Object)DateUtil.getTransDate(date), (Object)DateUtil.getTransTime(date));
        SimpleDateFormat startDateFormat = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        SimpleDateFormat startDateEnd = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add(SettlementFlowTradeTypeEnum.PAY.getCode());
        typeList.add(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode());
        SystemCalendarRespDto calendarBefore = this.getCalendarBefore(date);
        if (ObjectUtils.isEmpty((Object)calendarBefore) || ObjectUtils.isEmpty((Object)calendarBefore.getType())) {
            this.logger.info("\u627e\u4e0d\u5230\u8be5\u65e5\u671f\u7684\u65e5\u5386\u4fe1\u606f");
            return false;
        }
        if (SystemCalendarTypeEnum.C02.getCode().equals(calendarBefore.getType().toString())) {
            this.logger.info("\u4e0b\u4e00\u5929\u4e3a\u8282\u5047\u65e5\uff0c\u4e0d\u80fd\u6e05\u5206");
            return false;
        }
        ArrayList<Date> dateList = new ArrayList<Date>();
        if (CollectionUtil.isNotEmpty((Collection)calendarBefore.getHolidayList())) {
            dateList.addAll(calendarBefore.getHolidayList());
        }
        dateList.add(calendarBefore.getBeforeDate());
        QueryTradeSettlementFlowVo reqDto = new QueryTradeSettlementFlowVo();
        reqDto.setFinishDateList(dateList);
        reqDto.setTradeTypeList(typeList);
        reqDto.setNotTradePayType(PaymentWayEnum.WFT_ALIPLY_YE.getPayTypeCode());
        this.logger.info("\u83b7\u53d6\u9700\u8981\u4e0a\u4f20\u6e05\u5206\u7684\u4ea4\u6613\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List list = this.tradeSettlementFlowDas.queryTradeSettlementFlow(reqDto);
        if (CollectionUtil.isEmpty((Collection)list)) {
            this.logger.info("\u65e0\u9700\u4e0a\u4f20\u6e05\u5206\u660e\u7ec6\u7684\u4ea4\u6613\uff0c\u4e0d\u9700\u8981\u6267\u884c\u4e0a\u4f20\u6e05\u5206\u6587\u4ef6");
            return false;
        }
        for (TradeSettlementFlowEo trade : list) {
            if (trade.getTradeStatus().equals(SettlementFlowTradeStatusEnum.CREATED.getCode()) || trade.getTradeStatus().equals(SettlementFlowTradeStatusEnum.ACCEPT.getCode())) {
                this.logger.info("\u5b58\u5728\u5c1a\u672a\u5b8c\u6210\u7684\u5728\u7ebf\u4ea4\u6613\uff1a{}", (Object)JSON.toJSONString((Object)trade));
                return false;
            }
            if (!StringUtils.isEmpty((CharSequence)trade.getPaymentUploadFlowId())) continue;
            this.logger.info("\u5b58\u5728\u5c1a\u672a\u4e0a\u4f20\u6e05\u5206\u660e\u7ec6\u7684\u4ea4\u6613\uff1a{}", (Object)JSON.toJSONString((Object)trade));
            return false;
        }
        reqDto = new QueryTradeSettlementFlowVo();
        reqDto.setFinishDateList(dateList);
        reqDto.setTradeTypeList((List)Lists.newArrayList((Object[])new String[]{SettlementFlowTradeTypeEnum.PAY.getCode()}));
        reqDto.setNotTradePayType(PaymentWayEnum.WFT_ALIPLY_YE.getPayTypeCode());
        reqDto.setTradeStatus(SettlementFlowTradeStatusEnum.CLOSED.getCode());
        reqDto.setCloseStatusType(TradeSettlementCloseStatusTypeEnum.REPEAT.getCode());
        List closeFlowList = this.tradeSettlementFlowDas.queryTradeSettlementFlow(reqDto);
        if (CollectionUtil.isNotEmpty((Collection)closeFlowList)) {
            for (TradeSettlementFlowEo trade : closeFlowList) {
                if (!StringUtils.isEmpty((CharSequence)trade.getPaymentUploadFlowId())) continue;
                this.logger.info("\u5b58\u5728\u5c1a\u672a\u5df2\u5173\u95ed\u5374\u672a\u4e0a\u4f20\u6e05\u5206\u7684\u4ea4\u6613\uff1a{}", (Object)JSON.toJSONString((Object)trade));
                return false;
            }
        }
        this.logger.info("\u5b8c\u6210\u6267\u884c\u3010\u51c6\u5907\u6267\u884c\u6e05\u5206\u524d\u68c0\u6d4b\u662f\u5426\u6709\u672a\u4e0a\u4f20\u6e05\u5206\u660e\u7ec6\u3011\uff1a\u68c0\u6d4b\u5728\u7ebf\u4ea4\u6613\u603b\u6570\uff1a{}\uff1b\u5173\u95ed\u4ea4\u6613\u603b\u6570\uff1a{}", (Object)list.size(), (Object)closeFlowList.size());
        return true;
    }

    private SystemCalendarRespDto getCalendarBefore(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        SimpleDateFormat startDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return (SystemCalendarRespDto)RestResponseHelper.extractData((RestResponse)this.systemCalendarQueryApi.queryBeforeHolidayByDate(startDateFormat.format(calendar.getTime())));
    }

    @Override
    public List<TradeSettlementFlowRespDto> queryPendingUploadTradeFlow(String orderNo) {
        return null;
    }

    @Override
    public List<TradeSettlementFlowRespDto> queryPendingUploadCloseTradeFlow(String orderNo) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unifyShareBenefit(ShareBenefitReqDto dto) {
        Mutex mutex;
        block5: {
            this.logger.info("\u7edf\u4e00\u5206\u8d26\u53d1\u8d77\uff1a{}", (Object)JSON.toJSONString((Object)dto));
            mutex = null;
            try {
                mutex = this.lockService.lock("st_order_settlement_doing", dto.getOrderNo(), 10, 10, TimeUnit.SECONDS);
                TradeSettlementFlowEo queryRefundTradeParams = new TradeSettlementFlowEo();
                queryRefundTradeParams.setFormerOptOrderNo(dto.getOrderNo());
                queryRefundTradeParams.setTradeType(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode());
                List refundTradeList = this.tradeSettlementFlowDas.select((BaseEo)queryRefundTradeParams);
                refundTradeList.forEach(trade -> {
                    if (!trade.getTradeStatus().equals(SettlementFlowTradeStatusEnum.FAIL.getCode()) && !trade.getTradeStatus().equals(SettlementFlowTradeStatusEnum.CLOSED.getCode())) {
                        throw new BizException(SettlementExceptionCode.ORDER_REFUND_ING.getCode(), SettlementExceptionCode.ORDER_REFUND_ING.getMsg());
                    }
                });
                TradeSettlementFlowReqDto queryTradeParams = new TradeSettlementFlowReqDto();
                queryTradeParams.setOptTradeNo(dto.getOrderNo());
                List<TradeSettlementFlowRespDto> tradeFlowList = this.tradeSettlementFlowService.queryList(queryTradeParams);
                AssertUtils.notEmpty(tradeFlowList, (String)"\u627e\u4e0d\u5230\u4ea4\u6613\u8bb0\u5f55");
                TradeSettlementFlowRespDto payTradeFlow = null;
                for (TradeSettlementFlowRespDto trade2 : tradeFlowList) {
                    if (trade2.getTradeType().equals(SettlementFlowTradeTypeEnum.PAY.getCode()) && trade2.getTradeStatus().equals(SettlementFlowTradeStatusEnum.SUCCESS.getCode())) {
                        payTradeFlow = trade2;
                    }
                    if (!trade2.getTradeType().equals(SettlementFlowTradeTypeEnum.ROUTING.getCode()) || trade2.getTradeStatus().equals(SettlementFlowTradeStatusEnum.CLOSED.getCode()) || trade2.getTradeStatus().equals(SettlementFlowTradeStatusEnum.FAIL.getCode())) continue;
                    throw new BizException(SettlementExceptionCode.ORDER_ROUTING_ING.getCode(), SettlementExceptionCode.ORDER_ROUTING_ING.getMsg());
                }
                AssertUtils.notNull(payTradeFlow, (SettlementExceptionCode)SettlementExceptionCode.SEARCH_PAY_TRADE_FLOW_NOT);
                AssertUtils.notEmpty((String)payTradeFlow.getTradePayType(), (String)"\u652f\u4ed8\u4ea4\u6613\u5f02\u5e38\uff0c\u6ca1\u6709\u652f\u4ed8\u65b9\u5f0f");
                if (payTradeFlow.getTradePayType().equals(PaymentWayEnum.WFT_ALIPLY_YE.getPayTypeCode())) {
                    this.balancePayShareBenefit(dto, payTradeFlow);
                    break block5;
                }
                this.onLinePayShareBenefit(dto, payTradeFlow);
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
        }
        this.lockService.unlock(mutex);
    }

    @Override
    public void unifyShareBenefitException(Long id) {
        TradeSettlementFlowRespDto respDto = this.tradeSettlementFlowService.queryById(id);
        if (ObjectUtils.isEmpty((Object)respDto) || !respDto.getTradeStatus().equals(SettlementFlowTradeStatusEnum.CREATED.getCode())) {
            throw new BizException("-1", "\u5904\u7406\u5206\u8d26\u5f02\u5e38\u4ea4\u6613\uff0c\u4ea4\u6613\u6d41\u6c34\u5f02\u5e38");
        }
        TradeSettlementFlowRespDto payTrade = this.tradeSettlementFlowService.queryPayTrade(respDto.getTradeNo());
        if (ObjectUtils.isEmpty((Object)payTrade)) {
            throw new BizException("-1", "\u5904\u7406\u5206\u8d26\u5f02\u5e38\u4ea4\u6613\uff0c\u627e\u4e0d\u5230\u652f\u4ed8\u4ea4\u6613");
        }
        if (payTrade.getTradePayType().equals(PaymentWayEnum.WFT_ALIPLY_YE.getPayTypeCode())) {
            TransferBaseDto transferBaseDto = new TransferBaseDto();
            transferBaseDto.setTradeFlow(respDto);
            transferBaseDto.setFormerTradeFlow(payTrade);
            this.transferService.run(transferBaseDto);
        } else {
            ShareBenefitBaseDto shareBenefitBaseDto = new ShareBenefitBaseDto();
            shareBenefitBaseDto.setTradeFlow(respDto);
            shareBenefitBaseDto.setFormerTradeFlow(payTrade);
            this.orderShareBenefitService.run(shareBenefitBaseDto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unifyShareBenefitDispose(Long id) {
        Mutex mutex;
        block5: {
            TradeSettlementFlowRespDto routingTradeFlow;
            block4: {
                mutex = null;
                try {
                    mutex = this.lockService.lock("unifyShareBenefitDispose", id.toString(), 10, 10, TimeUnit.SECONDS);
                    this.logger.info("\u7edf\u4e00\u5206\u8d26\u7ed3\u679c\u5904\u7406\uff1a{}", (Object)id);
                    routingTradeFlow = this.tradeSettlementFlowService.queryById(id);
                    AssertUtils.notEmpty((Object)routingTradeFlow, (SettlementExceptionCode)SettlementExceptionCode.SEARCH_TRADE_FLOW_NOT);
                    if (routingTradeFlow.getTradeStatus().equals(SettlementFlowTradeStatusEnum.ACCEPT.getCode())) break block4;
                    this.logger.info("\u8be5\u5206\u8d26\u6821\u9a8c\u5df2\u7ecf\u5904\u7406\uff1a{}", (Object)JSON.toJSONString((Object)routingTradeFlow));
                }
                catch (Throwable throwable) {
                    this.lockService.unlock(mutex);
                    throw throwable;
                }
                this.lockService.unlock(mutex);
                return;
            }
            TradeSettlementFlowRespDto payTradeFlow = this.tradeSettlementFlowService.queryPayTrade(routingTradeFlow.getOptTradeNo());
            AssertUtils.notEmpty((Object)routingTradeFlow, (SettlementExceptionCode)SettlementExceptionCode.SEARCH_PAY_TRADE_FLOW_NOT);
            if (payTradeFlow.getTradePayType().equals(PaymentWayEnum.WFT_ALIPLY_YE.getPayTypeCode())) {
                this.balancePayShareBenefitDispose(routingTradeFlow, payTradeFlow);
                break block5;
            }
            this.onLinePayShareBenefitDispose(routingTradeFlow, payTradeFlow);
        }
        this.lockService.unlock(mutex);
    }

    @Override
    public String queryTransferResult(TradeSettlementFlowRespDto routingTradeFlow, TradeSettlementFlowRespDto payTradeFlow) {
        this.logger.info("\u67e5\u8be2\u5212\u8d26\u7ed3\u679c:{}=={}", (Object)JSON.toJSONString((Object)routingTradeFlow), (Object)JSON.toJSONString((Object)payTradeFlow));
        SettlementAccountRespDto optAccount = this.settlementAccountService.queryByAccountNo(payTradeFlow.getOptAccountNo());
        CiticTransStateQueryReqDto reqDto = new CiticTransStateQueryReqDto();
        reqDto.setOriReqSsn(routingTradeFlow.getTradePayTradeId());
        reqDto.setUserId(optAccount.getBindAccountNo());
        reqDto.setUserTransDt(DateUtil.getTransDate(routingTradeFlow.getUpdateTime()));
        reqDto.setBussId(routingTradeFlow.getTradeNo());
        reqDto.setBussSubId(routingTradeFlow.getTradeNo());
        reqDto.setTransType(CiticTransTypeEnum.PAY.key);
        this.logger.info("\u8bf7\u6c42\u67e5\u8be2\u5212\u8d26\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        CiticTransStateQueryResDto result = (CiticTransStateQueryResDto)RestResponseHelper.extractData((RestResponse)this.citicQueryApi.transStateQuery(reqDto));
        this.logger.info("\u8bf7\u6c42\u67e5\u8be2\u5212\u8d26\u7ed3\u679c\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString((Object)result));
        if (ObjectUtils.isEmpty((Object)result) || !result.getRspCode().equals(CiticRspCodeEnum.SUCCESS.key)) {
            this.logger.error("\u8bf7\u6c42\u83b7\u53d6\u4ea4\u6613\u7ed3\u679c\u5f02\u5e38\uff1a{}", (Object)result.getRspMsg());
            throw new BizException("-1", "\u83b7\u53d6\u4e2d\u4fe1\u5212\u8d26\u7ed3\u679c\u5f02\u5e38");
        }
        return result.getState();
    }

    @Override
    public void tradeClearing(SplitOrderClearReqDto splitOrderClearReqDto) {
        this.logger.info("\u6267\u884c\u6e05\u5206\u5c31\u7eea\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderClearReqDto));
        Date transDate = DateUtil.getTransDate(splitOrderClearReqDto.getSplitDt());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(transDate);
        calendar.add(5, 1);
        SimpleDateFormat startDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SystemCalendarRespDto respDto = (SystemCalendarRespDto)RestResponseHelper.extractData((RestResponse)this.systemCalendarQueryApi.queryBeforeHolidayByDate(startDateFormat.format(calendar.getTime())));
        if (ObjectUtils.isEmpty((Object)respDto) || ObjectUtils.isEmpty((Object)respDto.getType())) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u8be5\u65e5\u671f\u7684\u65e5\u5386\u4fe1\u606f\uff1a" + calendar.getTime());
        }
        if (SystemCalendarTypeEnum.C02.getCode().equals(respDto.getType().toString())) {
            this.logger.info("\u4e0b\u4e00\u5929\u4e3a\u8282\u5047\u65e5\uff0c\u4e0d\u80fd\u6e05\u5206");
            return;
        }
        splitOrderClearReqDto.setSplitDtSet(splitOrderClearReqDto.getSplitDt());
        if (CollectionUtil.isNotEmpty((Collection)respDto.getHolidayList())) {
            String dateStr = respDto.getHolidayList().stream().map(DateUtil::getTransDate).collect(Collectors.joining(","));
            dateStr = dateStr + "," + DateUtil.getTransDate(respDto.getBeforeDate());
            splitOrderClearReqDto.setSplitDtSet(dateStr);
        }
        RestResponse voidRestResponse = this.splitOrderApi.splitOrderClear(splitOrderClearReqDto);
        this.logger.info("\u6267\u884c\u6e05\u5206\u5c31\u7eea\u54cd\u5e94\uff1a{}", (Object)JSON.toJSONString((Object)voidRestResponse));
    }

    private void balancePayShareBenefit(ShareBenefitReqDto dto, TradeSettlementFlowRespDto payTradeFlow) {
        TransferBaseDto reqDto = new TransferBaseDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)dto, (String[])new String[0]);
        reqDto.setFormerTradeFlow(payTradeFlow);
        TradeBaseResponse<TransferBaseDto> checkAndBuildDto = this.transferService.checkAndBuild(reqDto);
        TradeBaseResponse<TransferBaseDto> before = this.transferService.before((TransferBaseDto)checkAndBuildDto.getRequestData());
        this.transferService.run((TransferBaseDto)before.getRequestData());
    }

    private void onLinePayShareBenefit(ShareBenefitReqDto dto, TradeSettlementFlowRespDto payTradeFlow) {
        ShareBenefitBaseDto baseDto = new ShareBenefitBaseDto();
        CubeBeanUtils.copyProperties((Object)baseDto, (Object)dto, (String[])new String[0]);
        baseDto.setFormerTradeFlow(payTradeFlow);
        TradeBaseResponse<ShareBenefitBaseDto> checkAndBuildResp = this.shareBenefitService.checkAndBuild(baseDto);
        TradeBaseResponse<ShareBenefitBaseDto> beforeResp = this.shareBenefitService.before((ShareBenefitBaseDto)checkAndBuildResp.getRequestData());
        this.shareBenefitService.run((ShareBenefitBaseDto)beforeResp.getRequestData());
    }

    private void balancePayShareBenefitDispose(TradeSettlementFlowRespDto routingTradeFlow, TradeSettlementFlowRespDto payTradeFlow) {
        this.logger.info("\u5904\u7406\u94b1\u5305\u652f\u4ed8\u5206\u8d26\u7ed3\u679c\u7ed3\u7b97\uff1a{}=={}", (Object)JSON.toJSONString((Object)routingTradeFlow), (Object)JSON.toJSONString((Object)payTradeFlow));
        String result = this.queryTransferResult(routingTradeFlow, payTradeFlow);
        if (result.equals(CiticTransStateEnum.SUCCEED.key)) {
            List<SettlementAccountFlowRespDto> accountFlowList = this.settlementAccountFlowService.queryListByTradeFlow(routingTradeFlow.getTradeNo(), routingTradeFlow.getParentTradeNo());
            AssertUtils.notEmpty(accountFlowList, (String)"\u627e\u4e0d\u5230\u54cd\u5e94\u7684\u6d41\u6c34");
            TransferBaseDto transferBaseDto = new TransferBaseDto();
            transferBaseDto.setTradeFlow(routingTradeFlow);
            transferBaseDto.setFormerTradeFlow(payTradeFlow);
            transferBaseDto.setOptAccountFlowList(accountFlowList);
            this.transferService.after(transferBaseDto);
            return;
        }
        if (result.equals(CiticTransStateEnum.FAIL.key)) {
            this.logger.error("\u83b7\u53d6\u94b1\u5305\u652f\u4ed8\u5206\u8d26\u5212\u8d26\u7ed3\u679c\u4e3a\u5931\u8d25");
            this.dingdingSender.sendMessage("com.dtyunxi.tcbj.center.settlement.biz.service.impl.ShareBenefitServiceImpl#balancePayShareBenefitDispose\uff0c\u83b7\u53d6\u94b1\u5305\u652f\u4ed8\u5206\u8d26\u5212\u8d26\u7ed3\u679c\u4e3a\u5931\u8d25");
        }
    }

    private void onLinePayShareBenefitDispose(TradeSettlementFlowRespDto routingTradeFlow, TradeSettlementFlowRespDto payTradeFlow) {
        this.logger.info("\u5904\u7406\u5728\u7ebf\u652f\u4ed8\u5206\u8d26\u7ed3\u679c\u7ed3\u7b97\uff1a{}=={}", (Object)JSON.toJSONString((Object)routingTradeFlow), (Object)JSON.toJSONString((Object)payTradeFlow));
        SplitOrderRespDto splitOrderRespDto = (SplitOrderRespDto)RestResponseHelper.extractData((RestResponse)this.splitOrderQueryApi.queryById(Long.valueOf(payTradeFlow.getPaymentUploadFlowId())));
        if (ObjectUtils.isNotEmpty((Object)splitOrderRespDto)) {
            if (splitOrderRespDto.getDealStatus().equals(CiticSplitDealStatusEnum.COMPLETE.key) && splitOrderRespDto.getDealResult().equals(CiticSplitOrderResultEnum.SUCCESS.key)) {
                List<SettlementAccountFlowRespDto> accountFlowList = this.settlementAccountFlowService.queryListByTradeFlow(routingTradeFlow.getTradeNo(), routingTradeFlow.getParentTradeNo());
                AssertUtils.notEmpty(accountFlowList, (String)"\u627e\u4e0d\u5230\u8d26\u6237\u6d41\u6c34");
                ShareBenefitBaseDto shareBenefitBaseDto = new ShareBenefitBaseDto();
                shareBenefitBaseDto.setTradeFlow(routingTradeFlow);
                shareBenefitBaseDto.setFormerTradeFlow(payTradeFlow);
                shareBenefitBaseDto.setOptAccountFlowList(accountFlowList);
                this.shareBenefitService.after(shareBenefitBaseDto);
                return;
            }
            this.logger.info("\u6e05\u5206\u7ed3\u679c\u5c1a\u672a\u5b8c\u6210\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderRespDto));
            return;
        }
        this.logger.error("\u83b7\u53d6\u6e05\u5206\u7ed3\u679c\u5f02\u5e38");
    }

    private SplitOrderAddReqDto buildSplitOrder(TradeSettlementFlowRespDto tradeFlow, TradeSettlementFlowRespDto formerFlow, String payTransTp, String bussTransTp) {
        SplitOrderAddReqDto splitOrderReqDto = new SplitOrderAddReqDto();
        SettlementAccountRespDto accountRespDto = this.settlementAccountService.queryByAccountNo(tradeFlow.getSettlementAccountNo());
        if (ObjectUtils.isEmpty((Object)accountRespDto) || StringUtils.isEmpty((CharSequence)accountRespDto.getBindAccountNo())) {
            throw new BizException("-1", "\u8d26\u6237\u5f02\u5e38");
        }
        splitOrderReqDto.setTransDt(this.getFormatDate(tradeFlow.getTradePayFinishTime()));
        splitOrderReqDto.setTransTm(this.getFormatTime(tradeFlow.getTradePayFinishTime()));
        splitOrderReqDto.setPayChannelSsn(formerFlow.getTradePayTradeChannelId());
        splitOrderReqDto.setFeeAmt(formerFlow.getTradePayParnterPoundage().toString());
        splitOrderReqDto.setUserId(accountRespDto.getBindAccountNo());
        splitOrderReqDto.setBussId(tradeFlow.getTradeNo());
        splitOrderReqDto.setPayNo(formerFlow.getTradePayTradeId());
        splitOrderReqDto.setBussSubId(tradeFlow.getTradeNo());
        splitOrderReqDto.setPayTransTp(payTransTp);
        splitOrderReqDto.setBussTransTp(bussTransTp);
        splitOrderReqDto.setFundSource(CiticFundSourceEnum.PAY_CHANNEL.key);
        splitOrderReqDto.setFeeTp(CiticFeeTypeEnum.USER_BEAR.key);
        splitOrderReqDto.setOrderAmt(tradeFlow.getTradeAmount().toString());
        splitOrderReqDto.setPayAmt(tradeFlow.getTradeAmount().toString());
        splitOrderReqDto.setDiscountAmt("0.00");
        splitOrderReqDto.setShareAmt("0.00");
        splitOrderReqDto.setAdvanceAmt("0.00");
        splitOrderReqDto.setFundTp(CiticFundTypeEnum.TRADE.key);
        return splitOrderReqDto;
    }

    private void updateTradeFlowUploadId(Long id, String paymentUploadFlowId) {
        if (ObjectUtils.isNotEmpty((Object)id) && StringUtils.isNotEmpty((CharSequence)paymentUploadFlowId)) {
            TradeSettlementFlowEo flowEo = new TradeSettlementFlowEo();
            flowEo.setId(id);
            flowEo.setPaymentUploadFlowId(paymentUploadFlowId);
            this.tradeSettlementFlowDas.updateSelective((BaseEo)flowEo);
            this.logger.info(">>>>>>>>>>\u4e0a\u4f20\u6e05\u5206\u660e\u7ec6\u6210\u529f\uff0c\u66f4\u65b0\u4ea4\u6613\u6d41\u6c34\u6210\u529f\uff1a{}" + flowEo.getTradeNo());
        }
    }

    private String getFormatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        return sdf.format(date);
    }

    private String getFormatTime(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
        return sdf.format(date);
    }
}

