/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.center.settlement.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.tcbj.api.ICiticApi;
import com.dtyunxi.tcbj.api.ISwiftpassFinanceFileApi;
import com.dtyunxi.tcbj.api.ISwiftpassFinanceFileDetailApi;
import com.dtyunxi.tcbj.api.dto.request.CiticAccountTransVerifyReqDto;
import com.dtyunxi.tcbj.api.dto.request.SwiftpassFinanceFileDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.CiticAccountTransDetailUnverifiedQueryResDto;
import com.dtyunxi.tcbj.api.dto.response.SwiftpassFinanceFileDetailRespDto;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.SettlementFlowTradeTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyBillTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyDealStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyFlagEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyResultEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifySuccessStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyTaskStatusEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyTaskTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.constant.VerifyTradePayTypeEnum;
import com.dtyunxi.tcbj.center.settlement.api.dto.request.VerifyTaskReqDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.SelectValueRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.VerifyFailCountRespDto;
import com.dtyunxi.tcbj.center.settlement.api.dto.response.VerifyTaskRespDto;
import com.dtyunxi.tcbj.center.settlement.biz.service.IVerifyBalanceDetailService;
import com.dtyunxi.tcbj.center.settlement.biz.service.IVerifyTaskService;
import com.dtyunxi.tcbj.center.settlement.biz.service.IVerifyTradeResultService;
import com.dtyunxi.tcbj.center.settlement.dao.das.TradeSettlementFlowDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.VerifyDealBillDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.VerifyTaskDas;
import com.dtyunxi.tcbj.center.settlement.dao.das.VerifyTradeResultDas;
import com.dtyunxi.tcbj.center.settlement.dao.eo.TradeSettlementFlowEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.VerifyDealBillEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.VerifyTaskEo;
import com.dtyunxi.tcbj.center.settlement.dao.eo.VerifyTradeResultEo;
import com.dtyunxi.tcbj.center.settlement.dao.mapper.VerifyTaskMapper;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VerifyTaskServiceImpl
implements IVerifyTaskService {
    @Resource
    private VerifyTaskDas verifyTaskDas;
    @Resource
    private VerifyTaskMapper verifyTaskMapper;
    @Resource
    private TradeSettlementFlowDas tradeSettlementFlowDas;
    @Resource
    private VerifyTradeResultDas verifyTradeResultDas;
    @Resource
    private ICiticApi citicApi;
    @Resource
    private VerifyDealBillDas dealBillDas;
    @Resource
    private ISwiftpassFinanceFileDetailApi swiftpassFileDetailApi;
    @Resource
    private IVerifyTradeResultService verifyTradeResultService;
    @Resource
    private IVerifyBalanceDetailService balanceDetailService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ISwiftpassFinanceFileApi financeFileApi;

    @Override
    public Long addVerifyTask(VerifyTaskReqDto addReqDto) {
        VerifyTaskEo verifyTaskEo = new VerifyTaskEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)verifyTaskEo);
        this.verifyTaskDas.insert((BaseEo)verifyTaskEo);
        return verifyTaskEo.getId();
    }

    @Override
    public void modifyVerifyTask(VerifyTaskReqDto modifyReqDto) {
        VerifyTaskEo verifyTaskEo = new VerifyTaskEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)verifyTaskEo);
        this.verifyTaskDas.updateSelective((BaseEo)verifyTaskEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeVerifyTask(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.verifyTaskDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public VerifyTaskRespDto queryById(Long id) {
        VerifyTaskEo verifyTaskEo = (VerifyTaskEo)this.verifyTaskDas.selectByPrimaryKey(id);
        VerifyTaskRespDto verifyTaskRespDto = new VerifyTaskRespDto();
        DtoHelper.eo2Dto((BaseEo)verifyTaskEo, (BaseVo)verifyTaskRespDto);
        return verifyTaskRespDto;
    }

    @Override
    public PageInfo<VerifyTaskRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        VerifyTaskReqDto verifyTaskReqDto = (VerifyTaskReqDto)JSON.parseObject((String)filter, VerifyTaskReqDto.class);
        VerifyTaskEo verifyTaskEo = new VerifyTaskEo();
        DtoHelper.dto2Eo((BaseVo)verifyTaskReqDto, (BaseEo)verifyTaskEo);
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((CharSequence)verifyTaskReqDto.getVerifyDateBegin())) {
            sqlFilterList.add(SqlFilter.ge((String)"verify_date", (Object)verifyTaskReqDto.getVerifyDateBegin().replace("-", "").substring(0, 8)));
        }
        if (StringUtils.isNotEmpty((CharSequence)verifyTaskReqDto.getVerifyDateEnd())) {
            sqlFilterList.add(SqlFilter.le((String)"verify_date", (Object)verifyTaskReqDto.getVerifyDateEnd().replace("-", "").substring(0, 8)));
        }
        verifyTaskEo.setSqlFilters(sqlFilterList);
        PageInfo eoPageInfo = this.verifyTaskDas.selectPage((BaseEo)verifyTaskEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, VerifyTaskRespDto.class);
        if (dtoList.size() > 0) {
            ListIterator iterator = dtoList.listIterator();
            while (iterator.hasNext()) {
                VerifyTaskRespDto dto = (VerifyTaskRespDto)iterator.next();
                dto.setVerifyDate(dto.getVerifyDate().substring(0, 4) + "-" + dto.getVerifyDate().substring(4, 6) + "-" + dto.getVerifyDate().substring(6, 8));
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public VerifyFailCountRespDto queryVerifyFailCount() {
        VerifyFailCountRespDto respDto = new VerifyFailCountRespDto();
        respDto.setWftPayNum(this.verifyTaskMapper.queryVerifyFailCount(VerifyTaskTypeEnum.WFT_PAY.getCode()));
        respDto.setWftTuikuanNum(this.verifyTaskMapper.queryVerifyFailCount(VerifyTaskTypeEnum.WFT_TUI_KUAN.getCode()));
        respDto.setDjbPayNum(this.verifyTaskMapper.queryVerifyFailCount(VerifyTaskTypeEnum.DJB_PAY.getCode()));
        respDto.setDjbTixianNum(this.verifyTaskMapper.queryVerifyFailCount(VerifyTaskTypeEnum.DJB_TI_XIAN.getCode()));
        respDto.setBillHasDeal(this.verifyTaskMapper.queryDealBillCount(VerifyDealStatusEnum.YES_DEAL.getCode()));
        respDto.setBillNoDeal(this.verifyTaskMapper.queryDealBillCount(VerifyDealStatusEnum.WAIT_DEAL.getCode()));
        return respDto;
    }

    @Override
    public List<SelectValueRespDto> querySelectValue(String type) {
        ArrayList<SelectValueRespDto> respDtoList = new ArrayList<SelectValueRespDto>();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (StringUtils.isNotEmpty((CharSequence)type)) {
                Class<?> clazz = loader.loadClass("com.dtyunxi.tcbj.center.settlement.api.constant." + type + "Enum");
                Method provideMap = clazz.getMethod("provideMap", new Class[0]);
                Map map = (Map)provideMap.invoke((Object)type, new Object[0]);
                for (Map.Entry entry : map.entrySet()) {
                    SelectValueRespDto dto = new SelectValueRespDto();
                    dto.setType(type);
                    dto.setCode((String)entry.getKey());
                    dto.setName((String)entry.getValue());
                    respDtoList.add(dto);
                }
            } else {
                ArrayList<String> enumList = new ArrayList<String>();
                enumList.add("VerifyBillType");
                enumList.add("VerifyDealStatus");
                enumList.add("VerifyFlag");
                enumList.add("VerifyResult");
                enumList.add("VerifySuccessStatus");
                enumList.add("VerifyTaskStatus");
                enumList.add("VerifyTaskType");
                for (String enumType : enumList) {
                    Class<?> clazz = loader.loadClass("com.dtyunxi.tcbj.center.settlement.api.constant." + enumType + "Enum");
                    Method provideMap = clazz.getMethod("provideMap", new Class[0]);
                    Map map = (Map)provideMap.invoke((Object)enumType, new Object[0]);
                    for (Map.Entry entry : map.entrySet()) {
                        SelectValueRespDto dto = new SelectValueRespDto();
                        dto.setType(enumType);
                        dto.setCode((String)entry.getKey());
                        dto.setName((String)entry.getValue());
                        respDtoList.add(dto);
                    }
                }
            }
        }
        catch (Exception e) {
            new BizException("7000001", type + "\u4e0b\u62c9\u503c\u6ca1\u6709\u88ab\u53d1\u73b0");
        }
        return respDtoList;
    }

    @Override
    public void verifyRecord() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        String verifyDate = format.format(cal.getTime());
        for (Object key : VerifyTaskTypeEnum.provideMap().keySet()) {
            Integer verifyType = Integer.valueOf((String)key);
            VerifyTaskEo searchTaskEo = new VerifyTaskEo();
            searchTaskEo.setVerifyDate(verifyDate);
            searchTaskEo.setVerifyType(verifyType);
            VerifyTaskEo taskEo = (VerifyTaskEo)this.verifyTaskDas.selectOne((BaseEo)searchTaskEo);
            if (taskEo != null) continue;
            taskEo = new VerifyTaskEo();
            taskEo.setVerifyDate(verifyDate);
            taskEo.setVerifyType(verifyType);
            taskEo.setTaskStatus(VerifyTaskStatusEnum.WAIT_DOING.getCode());
            taskEo.setRemark("\u5f85\u5bf9\u8d26");
            taskEo.setCiticVerifyNum(Integer.valueOf(0));
            taskEo.setZhongtaiVerifyNum(Integer.valueOf(0));
            taskEo.setSuccessNum(Integer.valueOf(0));
            taskEo.setFailNum(Integer.valueOf(0));
            taskEo.setDiffBalanceNum(Integer.valueOf(0));
            taskEo.setSuccessNum(Integer.valueOf(0));
            taskEo.setLongNum(Integer.valueOf(0));
            taskEo.setShortNum(Integer.valueOf(0));
            taskEo.setTaskNum(Integer.valueOf(0));
            this.verifyTaskDas.insert((BaseEo)taskEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void djbFlowVerifyByBankToZhongtai(CiticAccountTransDetailUnverifiedQueryResDto detailItemDto, VerifyTaskEo taskEo, String tradeType) throws Exception {
        Integer billType = 0;
        int successNum = 0;
        int failNum = 0;
        int diffBalanceNum = 0;
        int diffStatusNum = 0;
        int longNum = 0;
        VerifyTradeResultEo verifyResultEo = new VerifyTradeResultEo();
        TradeSettlementFlowEo flowSearchEo = new TradeSettlementFlowEo();
        flowSearchEo.setTradeType(tradeType);
        if (tradeType.equals(SettlementFlowTradeTypeEnum.ROUTING.getCode())) {
            flowSearchEo.setTradeNo(detailItemDto.getBussId());
        } else if (tradeType.equals(SettlementFlowTradeTypeEnum.WITHDRAW.getCode())) {
            flowSearchEo.setOptTradeNo(detailItemDto.getBussId());
        }
        List zhontaiFlowList = this.tradeSettlementFlowDas.select((BaseEo)flowSearchEo);
        TradeSettlementFlowEo zhontaiFlow = null;
        BigDecimal bankAmt = new BigDecimal(detailItemDto.getTransAmt());
        if (zhontaiFlowList != null && zhontaiFlowList.size() > 0) {
            zhontaiFlow = (TradeSettlementFlowEo)zhontaiFlowList.get(0);
            if (((TradeSettlementFlowEo)zhontaiFlowList.get(0)).getTradeStatus().equals(SettlementFlowTradeStatusEnum.SUCCESS.getCode())) {
                if (((TradeSettlementFlowEo)zhontaiFlowList.get(0)).getTradeAmount().compareTo(bankAmt) == 0) {
                    verifyResultEo.setVerifyStatus(VerifySuccessStatusEnum.SUCCESS.getCode());
                    verifyResultEo.setDealStatus(VerifyDealStatusEnum.NO_DEAL.getCode());
                    ++successNum;
                } else {
                    verifyResultEo.setVerifyStatus(VerifySuccessStatusEnum.FAIL.getCode());
                    verifyResultEo.setDealStatus(VerifyDealStatusEnum.WAIT_DEAL.getCode());
                    if (tradeType.equals(SettlementFlowTradeTypeEnum.ROUTING.getCode())) {
                        verifyResultEo.setVerifyResult(VerifyResultEnum.DJB_PAY_BALANCE_DIFF.getCode());
                        billType = VerifyBillTypeEnum.DJB_PAY_BALANCE_DIFF_DEAL.getCode();
                    } else if (tradeType.equals(SettlementFlowTradeTypeEnum.WITHDRAW.getCode())) {
                        verifyResultEo.setVerifyResult(VerifyResultEnum.DJB_WITHDRAW_BALANCE_DIFF.getCode());
                        billType = VerifyBillTypeEnum.DJB_WITHDRAW_BALANCE_DIFF_DEAL.getCode();
                    }
                    ++failNum;
                    ++diffBalanceNum;
                }
            } else {
                verifyResultEo.setVerifyStatus(VerifySuccessStatusEnum.FAIL.getCode());
                verifyResultEo.setDealStatus(VerifyDealStatusEnum.WAIT_DEAL.getCode());
                if (tradeType.equals(SettlementFlowTradeTypeEnum.ROUTING.getCode())) {
                    verifyResultEo.setVerifyResult(VerifyResultEnum.DJB_PAY_STATUS_ZHONGTAI_FAIL.getCode());
                    billType = VerifyBillTypeEnum.DJB_PAY_STATUS_ZHONGTAI_FAIL_DEAL.getCode();
                } else if (tradeType.equals(SettlementFlowTradeTypeEnum.WITHDRAW.getCode())) {
                    verifyResultEo.setVerifyResult(VerifyResultEnum.DJB_WITHDRAW_STATUS_ZHONGTAI_FAIL.getCode());
                    billType = VerifyBillTypeEnum.DJB_WITHDRAW_STATUS_ZHONGTAI_FAIL_DEAL.getCode();
                }
                ++failNum;
                ++diffStatusNum;
            }
        } else {
            verifyResultEo.setVerifyStatus(VerifySuccessStatusEnum.FAIL.getCode());
            verifyResultEo.setDealStatus(VerifyDealStatusEnum.WAIT_DEAL.getCode());
            if (tradeType.equals(SettlementFlowTradeTypeEnum.ROUTING.getCode())) {
                verifyResultEo.setVerifyResult(VerifyResultEnum.DJB_PAY_CHANGKUAN.getCode());
                billType = VerifyBillTypeEnum.DJB_PAY_CHANGKUAN_DEAL.getCode();
            } else if (tradeType.equals(SettlementFlowTradeTypeEnum.WITHDRAW.getCode())) {
                verifyResultEo.setVerifyResult(VerifyResultEnum.DJB_WITHDRAW_CHANGKUAN.getCode());
                billType = VerifyBillTypeEnum.DJB_WITHDRAW_CHANGKUAN_DEAL.getCode();
            }
            ++failNum;
            ++longNum;
        }
        verifyResultEo.setTaskId(taskEo.getId());
        if (tradeType.equals(SettlementFlowTradeTypeEnum.ROUTING.getCode())) {
            verifyResultEo.setVerifyType(VerifyTaskTypeEnum.DJB_PAY.getCode());
        } else if (tradeType.equals(SettlementFlowTradeTypeEnum.WITHDRAW.getCode())) {
            verifyResultEo.setVerifyType(VerifyTaskTypeEnum.DJB_TI_XIAN.getCode());
        }
        verifyResultEo.setVerifyDate(taskEo.getVerifyDate());
        if (zhontaiFlow != null) {
            verifyResultEo.setTradePayTradeId(zhontaiFlow.getTradePayTradeId());
            verifyResultEo.setLaunchTradeAmount(zhontaiFlow.getLaunchTradeAmount());
            verifyResultEo.setTradeAmount(zhontaiFlow.getTradeAmount());
            verifyResultEo.setZhongtaiVerifyStatus(SettlementFlowTradeStatusEnum.fromCode((String)zhontaiFlow.getTradeStatus()).getName());
            verifyResultEo.setZhongtaiApplyTime(zhontaiFlow.getCreateTime());
            verifyResultEo.setOrderNo(zhontaiFlow.getOptTradeNo());
        }
        verifyResultEo.setOptAccountName(detailItemDto.getUserName());
        verifyResultEo.setOptAccountNo(detailItemDto.getUserId());
        verifyResultEo.setSettlementAccountName(detailItemDto.getOanm());
        verifyResultEo.setSettlementAccountNo(detailItemDto.getGoac());
        verifyResultEo.setParentTradeNo(detailItemDto.getBussId());
        verifyResultEo.setTradePayTradeChannelId(detailItemDto.getUserSsn());
        verifyResultEo.setTradePaidAmount(bankAmt);
        verifyResultEo.setBankStatus(SettlementFlowTradeStatusEnum.SUCCESS.getName());
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        Date bankApplyTime = format.parse(detailItemDto.getTransDt() + detailItemDto.getTransTm());
        verifyResultEo.setBankApplyTime(bankApplyTime);
        String verifyResult = verifyResultEo.getVerifyResult();
        if (StringUtils.isNotEmpty((CharSequence)verifyResult)) {
            verifyResultEo.setVerifyResult(VerifyResultEnum.formCode((String)verifyResult).getName());
        }
        this.verifyTradeResultDas.insert((BaseEo)verifyResultEo);
        if (!billType.equals(0)) {
            VerifyDealBillEo dealBillEo = new VerifyDealBillEo();
            dealBillEo.setTaskId(taskEo.getId());
            dealBillEo.setResultId(verifyResultEo.getId());
            dealBillEo.setVerifyDate(taskEo.getVerifyDate());
            dealBillEo.setBillNo("JSD" + tradeType + taskEo.getVerifyDate() + taskEo.getTaskNum() + String.format("%06d", taskEo.getZhongtaiVerifyNum() + taskEo.getCiticVerifyNum()));
            dealBillEo.setBillType(billType);
            if (tradeType.equals(SettlementFlowTradeTypeEnum.ROUTING.getCode())) {
                dealBillEo.setFlowType(VerifyTaskTypeEnum.DJB_PAY.getCode());
            } else if (tradeType.equals(SettlementFlowTradeTypeEnum.WITHDRAW.getCode())) {
                dealBillEo.setFlowType(VerifyTaskTypeEnum.DJB_TI_XIAN.getCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)verifyResult)) {
                dealBillEo.setErrorBigType(VerifyResultEnum.formCode((String)verifyResult).getErrorBigType());
                dealBillEo.setErrorSmallType(VerifyResultEnum.formCode((String)verifyResult).getErrorSmallType());
            }
            dealBillEo.setBankFlowNo(detailItemDto.getUserSsn());
            dealBillEo.setZhongtaiFlowNo(detailItemDto.getBussId());
            if (zhontaiFlow != null) {
                dealBillEo.setOrderNo(zhontaiFlow.getOptTradeNo());
            }
            dealBillEo.setDealStatus(VerifyDealStatusEnum.WAIT_DEAL.getCode());
            this.dealBillDas.insert((BaseEo)dealBillEo);
        }
        CiticAccountTransVerifyReqDto dto = new CiticAccountTransVerifyReqDto();
        dto.setId(detailItemDto.getId());
        dto.setVerifyFlag(VerifyFlagEnum.YES.getCode());
        this.citicApi.accountTransVerify(dto);
        if (zhontaiFlowList != null && zhontaiFlowList.size() > 0) {
            for (TradeSettlementFlowEo itemFlowEo : zhontaiFlowList) {
                TradeSettlementFlowEo upFlowEo = new TradeSettlementFlowEo();
                upFlowEo.setId(itemFlowEo.getId());
                upFlowEo.setVerifyFlag(VerifyFlagEnum.YES.getCode());
                this.tradeSettlementFlowDas.updateSelective((BaseEo)upFlowEo);
                taskEo.setZhongtaiVerifyNum(Integer.valueOf(taskEo.getZhongtaiVerifyNum() + 1));
            }
        }
        taskEo.setCiticVerifyNum(Integer.valueOf(taskEo.getCiticVerifyNum() + 1));
        taskEo.setSuccessNum(Integer.valueOf(taskEo.getSuccessNum() + successNum));
        taskEo.setFailNum(Integer.valueOf(taskEo.getFailNum() + failNum));
        taskEo.setDiffBalanceNum(Integer.valueOf(taskEo.getDiffBalanceNum() + diffBalanceNum));
        taskEo.setDiffStatusNum(Integer.valueOf(taskEo.getDiffStatusNum() + diffStatusNum));
        taskEo.setLongNum(Integer.valueOf(taskEo.getLongNum() + longNum));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void flowVerifyByZhongtaiToBank(List<TradeSettlementFlowEo> zhontaiFlowList, VerifyTaskEo taskEo, String tradeType) {
        for (TradeSettlementFlowEo itemFlowEo : zhontaiFlowList) {
            VerifyTradeResultEo verifyResultEo = new VerifyTradeResultEo();
            if (itemFlowEo.getVerifyFlag().equals(VerifyFlagEnum.NO.getCode()) && (tradeType.equals(SettlementFlowTradeTypeEnum.PAY.getCode()) || tradeType.equals(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode()))) {
                BigDecimal tradeAmount = new BigDecimal(0);
                BigDecimal launchTradeAmount = new BigDecimal(0);
                BigDecimal tradePoundage = new BigDecimal(0);
                for (TradeSettlementFlowEo groupFlowEo : zhontaiFlowList) {
                    if (!itemFlowEo.getTradePayTradeId().equals(groupFlowEo.getTradePayTradeId())) continue;
                    tradeAmount = tradeAmount.add(groupFlowEo.getTradeAmount());
                    launchTradeAmount = launchTradeAmount.add(groupFlowEo.getLaunchTradeAmount());
                    tradePoundage = tradePoundage.add(groupFlowEo.getTradePoundage());
                    groupFlowEo.setVerifyFlag(VerifyFlagEnum.YES.getCode());
                    if (StringUtils.isNotEmpty((CharSequence)verifyResultEo.getOrderNo())) {
                        verifyResultEo.setOrderNo(verifyResultEo.getOrderNo() + "," + groupFlowEo.getOptTradeNo());
                    } else {
                        verifyResultEo.setOrderNo(groupFlowEo.getOptTradeNo());
                    }
                    if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode())) {
                        if (StringUtils.isNotEmpty((CharSequence)verifyResultEo.getFormerOrderNo())) {
                            verifyResultEo.setFormerOrderNo(verifyResultEo.getFormerOrderNo() + "," + groupFlowEo.getFormerOptOrderNo());
                        } else {
                            verifyResultEo.setFormerOrderNo(groupFlowEo.getFormerOptOrderNo());
                        }
                    }
                    TradeSettlementFlowEo upFlowEo = new TradeSettlementFlowEo();
                    upFlowEo.setId(groupFlowEo.getId());
                    upFlowEo.setVerifyFlag(VerifyFlagEnum.YES.getCode());
                    this.tradeSettlementFlowDas.updateSelective((BaseEo)upFlowEo);
                }
                verifyResultEo.setTradePoundage(tradePoundage);
                verifyResultEo.setTradeAmount(tradeAmount);
                verifyResultEo.setLaunchTradeAmount(launchTradeAmount);
                this.flowVerifyByZhongtaiToBank_common(verifyResultEo, taskEo, tradeType, itemFlowEo);
                continue;
            }
            if (!tradeType.equals(SettlementFlowTradeTypeEnum.ROUTING.getCode()) && !tradeType.equals(SettlementFlowTradeTypeEnum.WITHDRAW.getCode())) continue;
            TradeSettlementFlowEo upFlowEo = new TradeSettlementFlowEo();
            upFlowEo.setId(itemFlowEo.getId());
            upFlowEo.setVerifyFlag(VerifyFlagEnum.YES.getCode());
            this.tradeSettlementFlowDas.updateSelective((BaseEo)upFlowEo);
            verifyResultEo.setTradePoundage(itemFlowEo.getTradePoundage());
            verifyResultEo.setTradeAmount(itemFlowEo.getTradeAmount());
            verifyResultEo.setLaunchTradeAmount(itemFlowEo.getLaunchTradeAmount());
            verifyResultEo.setTradePoundage(itemFlowEo.getTradePoundage());
            verifyResultEo.setOrderNo(itemFlowEo.getOptTradeNo());
            verifyResultEo.setFormerOrderNo(itemFlowEo.getFormerOptOrderNo());
            this.flowVerifyByZhongtaiToBank_common(verifyResultEo, taskEo, tradeType, itemFlowEo);
        }
    }

    public void flowVerifyByZhongtaiToBank_common(VerifyTradeResultEo verifyResultEo, VerifyTaskEo taskEo, String tradeType, TradeSettlementFlowEo itemFlowEo) {
        verifyResultEo.setVerifyStatus(VerifySuccessStatusEnum.FAIL.getCode());
        verifyResultEo.setDealStatus(VerifyDealStatusEnum.WAIT_DEAL.getCode());
        Integer billType = 0;
        if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY.getCode())) {
            verifyResultEo.setVerifyResult(VerifyResultEnum.WFT_PAY_DUANKUAN.getCode());
            billType = VerifyBillTypeEnum.WFT_PAY_DUANKUAN_DEAL.getCode();
            verifyResultEo.setParentTradeNo(itemFlowEo.getParentTradeNo());
        } else if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode())) {
            verifyResultEo.setVerifyResult(VerifyResultEnum.WFT_REFUND_DUANKUAN.getCode());
            billType = VerifyBillTypeEnum.WFT_REFUND_DUANKUAN_DEAL.getCode();
            verifyResultEo.setParentTradeNo(itemFlowEo.getParentTradeNo());
        } else if (tradeType.equals(SettlementFlowTradeTypeEnum.ROUTING.getCode())) {
            verifyResultEo.setVerifyResult(VerifyResultEnum.DJB_PAY_DUANKUAN.getCode());
            billType = VerifyBillTypeEnum.DJB_PAY_DUANKUAN_DEAL.getCode();
            verifyResultEo.setLaunchTradeAmount(itemFlowEo.getLaunchTradeAmount());
            verifyResultEo.setParentTradeNo(itemFlowEo.getTradeNo());
        } else if (tradeType.equals(SettlementFlowTradeTypeEnum.WITHDRAW.getCode())) {
            verifyResultEo.setVerifyResult(VerifyResultEnum.DJB_WITHDRAW_DUANKUAN.getCode());
            billType = VerifyBillTypeEnum.DJB_WITHDRAW_DUANKUAN_DEAL.getCode();
            verifyResultEo.setLaunchTradeAmount(itemFlowEo.getLaunchTradeAmount());
            verifyResultEo.setParentTradeNo(itemFlowEo.getOptTradeNo());
        }
        verifyResultEo.setTaskId(taskEo.getId());
        verifyResultEo.setVerifyType(taskEo.getVerifyType());
        verifyResultEo.setVerifyDate(taskEo.getVerifyDate());
        verifyResultEo.setTradePayTradeId(itemFlowEo.getTradePayTradeId());
        verifyResultEo.setOptAccountName(itemFlowEo.getOptAccountName());
        verifyResultEo.setOptAccountNo(itemFlowEo.getOptAccountNo());
        verifyResultEo.setSettlementAccountName(itemFlowEo.getSettlementAccountName());
        verifyResultEo.setSettlementAccountNo(itemFlowEo.getSettlementAccountNo());
        verifyResultEo.setTradePoundageRate(itemFlowEo.getTradePoundageRate());
        verifyResultEo.setZhongtaiVerifyStatus(SettlementFlowTradeStatusEnum.fromCode((String)itemFlowEo.getTradeStatus()).getName());
        verifyResultEo.setZhongtaiApplyTime(itemFlowEo.getCreateTime());
        String verifyResult = verifyResultEo.getVerifyResult();
        verifyResultEo.setVerifyResult(VerifyResultEnum.formCode((String)verifyResultEo.getVerifyResult()).getName());
        verifyResultEo.setTradePayType(VerifyTradePayTypeEnum.getName((String)itemFlowEo.getTradePayType()));
        this.verifyTradeResultDas.insert((BaseEo)verifyResultEo);
        VerifyDealBillEo dealBillEo = new VerifyDealBillEo();
        dealBillEo.setTaskId(taskEo.getId());
        dealBillEo.setResultId(verifyResultEo.getId());
        dealBillEo.setVerifyDate(taskEo.getVerifyDate());
        dealBillEo.setBillNo("JSD" + tradeType + taskEo.getVerifyDate() + taskEo.getTaskNum() + String.format("%06d", taskEo.getZhongtaiVerifyNum() + taskEo.getCiticVerifyNum()));
        dealBillEo.setBillType(billType);
        dealBillEo.setFlowType(taskEo.getVerifyType());
        dealBillEo.setErrorBigType(VerifyResultEnum.formCode((String)verifyResult).getErrorBigType());
        dealBillEo.setErrorSmallType(VerifyResultEnum.formCode((String)verifyResult).getErrorSmallType());
        dealBillEo.setZhongtaiFlowNo(verifyResultEo.getParentTradeNo());
        dealBillEo.setOrderNo(verifyResultEo.getOrderNo());
        dealBillEo.setDealStatus(VerifyDealStatusEnum.WAIT_DEAL.getCode());
        this.dealBillDas.insert((BaseEo)dealBillEo);
        taskEo.setZhongtaiVerifyNum(Integer.valueOf(taskEo.getZhongtaiVerifyNum() + 1));
        taskEo.setFailNum(Integer.valueOf(taskEo.getFailNum() + 1));
        taskEo.setShortNum(Integer.valueOf(taskEo.getShortNum() + 1));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void wftFlowVerifyByBankToZhongtai(SwiftpassFinanceFileDetailRespDto detailItemDto, VerifyTaskEo taskEo, String tradeType) {
        Integer billType = 0;
        int successNum = 0;
        int failNum = 0;
        int diffBalanceNum = 0;
        int diffStatusNum = 0;
        int longNum = 0;
        VerifyTradeResultEo verifyResultEo = new VerifyTradeResultEo();
        TradeSettlementFlowEo flowSearchEo = new TradeSettlementFlowEo();
        flowSearchEo.setTradeType(tradeType);
        if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY.getCode())) {
            flowSearchEo.setTradePayTradeId(detailItemDto.getOutTradeNo());
        } else if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode())) {
            flowSearchEo.setTradePayTradeId(detailItemDto.getOutRefundNo());
        }
        List zhontaiFlowList = this.tradeSettlementFlowDas.select((BaseEo)flowSearchEo);
        if (zhontaiFlowList != null && zhontaiFlowList.size() > 0) {
            BigDecimal tradeAmount = new BigDecimal(0);
            BigDecimal launchTradeAmount = new BigDecimal(0);
            BigDecimal tradePoundage = new BigDecimal(0);
            for (TradeSettlementFlowEo addCalEo : zhontaiFlowList) {
                tradeAmount = tradeAmount.add(addCalEo.getTradeAmount());
                launchTradeAmount = launchTradeAmount.add(addCalEo.getLaunchTradeAmount());
                tradePoundage = tradePoundage.add(addCalEo.getTradePoundage());
                if (StringUtils.isNotEmpty((CharSequence)verifyResultEo.getOrderNo())) {
                    verifyResultEo.setOrderNo(verifyResultEo.getOrderNo() + "," + addCalEo.getOptTradeNo());
                } else {
                    verifyResultEo.setOrderNo(addCalEo.getOptTradeNo());
                }
                if (!tradeType.equals(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode())) continue;
                if (StringUtils.isNotEmpty((CharSequence)verifyResultEo.getFormerOrderNo())) {
                    verifyResultEo.setFormerOrderNo(verifyResultEo.getFormerOrderNo() + "," + addCalEo.getFormerOptOrderNo());
                    continue;
                }
                verifyResultEo.setFormerOrderNo(addCalEo.getFormerOptOrderNo());
            }
            verifyResultEo.setTradePoundage(tradePoundage);
            verifyResultEo.setTradeAmount(tradeAmount);
            verifyResultEo.setLaunchTradeAmount(launchTradeAmount);
            if (((TradeSettlementFlowEo)zhontaiFlowList.get(0)).getTradeStatus().equals(SettlementFlowTradeStatusEnum.SUCCESS.getCode())) {
                BigDecimal diff = null;
                if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY.getCode())) {
                    diff = tradeAmount.subtract(detailItemDto.getTotalFee());
                } else if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode())) {
                    diff = tradeAmount.subtract(this.getRefundFee(detailItemDto, verifyResultEo));
                }
                if (diff.compareTo(BigDecimal.valueOf(-1L)) > -1 && diff.compareTo(BigDecimal.valueOf(1L)) < 1) {
                    verifyResultEo.setVerifyStatus(VerifySuccessStatusEnum.SUCCESS.getCode());
                    verifyResultEo.setDealStatus(VerifyDealStatusEnum.NO_DEAL.getCode());
                    ++successNum;
                } else {
                    verifyResultEo.setVerifyStatus(VerifySuccessStatusEnum.FAIL.getCode());
                    verifyResultEo.setDealStatus(VerifyDealStatusEnum.WAIT_DEAL.getCode());
                    if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY.getCode())) {
                        verifyResultEo.setVerifyResult(VerifyResultEnum.WFT_PAY_BALANCE_DIFF.getCode());
                        billType = VerifyBillTypeEnum.WFT_PAY_BALANCE_DIFF_DEAL.getCode();
                    } else if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode())) {
                        verifyResultEo.setVerifyResult(VerifyResultEnum.WFT_REFUND_BALANCE_DIFF.getCode());
                        billType = VerifyBillTypeEnum.WFT_REFUND_BALANCE_DIFF_DEAL.getCode();
                    }
                    ++failNum;
                    ++diffBalanceNum;
                }
            } else {
                verifyResultEo.setVerifyStatus(VerifySuccessStatusEnum.FAIL.getCode());
                verifyResultEo.setDealStatus(VerifyDealStatusEnum.WAIT_DEAL.getCode());
                if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY.getCode())) {
                    verifyResultEo.setVerifyResult(VerifyResultEnum.WFT_PAY_STATUS_ZHONGTAI_FAIL.getCode());
                    billType = VerifyBillTypeEnum.WFT_PAY_STATUS_ZHONGTAI_FAIL_DEAL.getCode();
                } else if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode())) {
                    verifyResultEo.setVerifyResult(VerifyResultEnum.WFT_REFUND_STATUS_ZHONGTAI_FAIL.getCode());
                    billType = VerifyBillTypeEnum.WFT_REFUND_STATUS_ZHONGTAI_FAIL_DEAL.getCode();
                }
                ++failNum;
                ++diffStatusNum;
            }
        } else {
            verifyResultEo.setVerifyStatus(VerifySuccessStatusEnum.FAIL.getCode());
            verifyResultEo.setDealStatus(VerifyDealStatusEnum.WAIT_DEAL.getCode());
            if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY.getCode())) {
                verifyResultEo.setVerifyResult(VerifyResultEnum.WFT_PAY_CHANGKUAN.getCode());
                billType = VerifyBillTypeEnum.WFT_PAY_CHANGKUAN_DEAL.getCode();
            } else if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode())) {
                verifyResultEo.setVerifyResult(VerifyResultEnum.WFT_REFUND_CHANGKUAN.getCode());
                billType = VerifyBillTypeEnum.WFT_REFUND_CHANGKUAN_DEAL.getCode();
            }
            ++failNum;
            ++longNum;
        }
        verifyResultEo.setVerifyDate(taskEo.getVerifyDate());
        TradeSettlementFlowEo zhontaiFlow = null;
        if (zhontaiFlowList != null && zhontaiFlowList.size() > 0) {
            zhontaiFlow = (TradeSettlementFlowEo)zhontaiFlowList.get(0);
        }
        if (zhontaiFlow != null) {
            verifyResultEo.setParentTradeNo(zhontaiFlow.getParentTradeNo());
            verifyResultEo.setSettlementAccountName(zhontaiFlow.getSettlementAccountName());
            verifyResultEo.setSettlementAccountNo(zhontaiFlow.getSettlementAccountNo());
            verifyResultEo.setTradePoundageRate(zhontaiFlow.getTradePoundageRate());
            verifyResultEo.setZhongtaiVerifyStatus(SettlementFlowTradeStatusEnum.fromCode((String)zhontaiFlow.getTradeStatus()).getName());
            verifyResultEo.setZhongtaiApplyTime(zhontaiFlow.getCreateTime());
        }
        verifyResultEo.setTaskId(taskEo.getId());
        if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY.getCode())) {
            verifyResultEo.setTradePayTradeId(detailItemDto.getOutTradeNo());
            verifyResultEo.setVerifyType(VerifyTaskTypeEnum.WFT_PAY.getCode());
            verifyResultEo.setTradePayTradeChannelId(detailItemDto.getTransactionId());
            verifyResultEo.setTradePaidAmount(detailItemDto.getTotalFee());
        } else if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode())) {
            verifyResultEo.setTradePayTradeId(detailItemDto.getOutRefundNo());
            verifyResultEo.setVerifyType(VerifyTaskTypeEnum.WFT_TUI_KUAN.getCode());
            verifyResultEo.setTradePayTradeChannelId(detailItemDto.getRefundId());
            verifyResultEo.setTradePaidAmount(this.getRefundFee(detailItemDto, verifyResultEo));
        }
        verifyResultEo.setTradePayParnterPoundage(detailItemDto.getPoundage());
        verifyResultEo.setTradePayParnterRate(detailItemDto.getPoundageRate());
        verifyResultEo.setBankStatus(SettlementFlowTradeStatusEnum.SUCCESS.getName());
        verifyResultEo.setBankApplyTime(detailItemDto.getTradeTime());
        verifyResultEo.setTradePayType(VerifyTradePayTypeEnum.getName((String)detailItemDto.getService()));
        verifyResultEo.setTradeSettleAmount(detailItemDto.getSettlementFee());
        verifyResultEo.setOptAccountNo(detailItemDto.getSubOpenid());
        verifyResultEo.setOutTransactionId(detailItemDto.getOutTransactionId());
        String verifyResult = verifyResultEo.getVerifyResult();
        if (StringUtils.isNotEmpty((CharSequence)verifyResult)) {
            verifyResultEo.setVerifyResult(VerifyResultEnum.formCode((String)verifyResultEo.getVerifyResult()).getName());
        }
        this.verifyTradeResultDas.insert((BaseEo)verifyResultEo);
        if (!billType.equals(0)) {
            VerifyDealBillEo dealBillEo = new VerifyDealBillEo();
            dealBillEo.setTaskId(taskEo.getId());
            dealBillEo.setResultId(verifyResultEo.getId());
            dealBillEo.setVerifyDate(taskEo.getVerifyDate());
            dealBillEo.setBillNo("JSD" + tradeType + taskEo.getVerifyDate() + taskEo.getTaskNum() + String.format("%06d", taskEo.getZhongtaiVerifyNum() + taskEo.getCiticVerifyNum()));
            dealBillEo.setBillType(billType);
            if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY.getCode())) {
                dealBillEo.setFlowType(VerifyTaskTypeEnum.WFT_PAY.getCode());
                dealBillEo.setBankFlowNo(detailItemDto.getTransactionId());
            } else if (tradeType.equals(SettlementFlowTradeTypeEnum.PAY_REFUND.getCode())) {
                dealBillEo.setFlowType(VerifyTaskTypeEnum.WFT_TUI_KUAN.getCode());
                dealBillEo.setBankFlowNo(detailItemDto.getRefundId());
            }
            if (StringUtils.isNotEmpty((CharSequence)verifyResult)) {
                dealBillEo.setErrorBigType(VerifyResultEnum.formCode((String)verifyResult).getErrorBigType());
                dealBillEo.setErrorSmallType(VerifyResultEnum.formCode((String)verifyResult).getErrorSmallType());
            }
            if (zhontaiFlow != null) {
                dealBillEo.setZhongtaiFlowNo(zhontaiFlow.getParentTradeNo());
                dealBillEo.setOrderNo(verifyResultEo.getOrderNo());
            }
            dealBillEo.setDealStatus(VerifyDealStatusEnum.WAIT_DEAL.getCode());
            this.dealBillDas.insert((BaseEo)dealBillEo);
        }
        SwiftpassFinanceFileDetailReqDto swipassUpReqDto = new SwiftpassFinanceFileDetailReqDto();
        swipassUpReqDto.setId(detailItemDto.getId());
        swipassUpReqDto.setVerifyStatus(VerifyFlagEnum.YES.getCode());
        this.swiftpassFileDetailApi.modifySwiftpassFinanceFileDetail(swipassUpReqDto);
        if (zhontaiFlowList != null && zhontaiFlowList.size() > 0) {
            for (TradeSettlementFlowEo itemFlowEo : zhontaiFlowList) {
                TradeSettlementFlowEo upFlowEo = new TradeSettlementFlowEo();
                upFlowEo.setId(itemFlowEo.getId());
                upFlowEo.setVerifyFlag(VerifyFlagEnum.YES.getCode());
                this.tradeSettlementFlowDas.updateSelective((BaseEo)upFlowEo);
                taskEo.setZhongtaiVerifyNum(Integer.valueOf(taskEo.getZhongtaiVerifyNum() + 1));
            }
        }
        taskEo.setCiticVerifyNum(Integer.valueOf(taskEo.getCiticVerifyNum() + 1));
        taskEo.setSuccessNum(Integer.valueOf(taskEo.getSuccessNum() + successNum));
        taskEo.setFailNum(Integer.valueOf(taskEo.getFailNum() + failNum));
        taskEo.setDiffBalanceNum(Integer.valueOf(taskEo.getDiffBalanceNum() + diffBalanceNum));
        taskEo.setDiffStatusNum(Integer.valueOf(taskEo.getDiffStatusNum() + diffStatusNum));
        taskEo.setLongNum(Integer.valueOf(taskEo.getLongNum() + longNum));
    }

    private BigDecimal getRefundFee(SwiftpassFinanceFileDetailRespDto detailItemDto, VerifyTradeResultEo verifyResultEo) {
        BigDecimal refundFee = null;
        try {
            refundFee = new BigDecimal(detailItemDto.getRefundFee());
        }
        catch (Exception e) {
            refundFee = new BigDecimal(0);
            verifyResultEo.setExtension("\u5bf9\u8d26\u6587\u4ef6\u9000\u6b3e\u91d1\u989d\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u786e\u8ba4");
        }
        return refundFee;
    }

    @Override
    public String invokeVerify(Integer verifyTaskType, String verifyDateBegin, String verifyDateEnd) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {
            Date beginDate = format.parse(verifyDateBegin);
            Date endDate = format.parse(verifyDateEnd);
            if (beginDate.compareTo(endDate) > 0) {
                return "\u5f00\u59cb\u65e5\u671f\u8981\u5c0f\u4e8e\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f";
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(beginDate);
            String verifyDate = "";
            while (endDate.compareTo(cal.getTime()) >= 0) {
                verifyDate = format.format(cal.getTime());
                if (verifyTaskType.equals(VerifyTaskTypeEnum.WFT_PAY.getCode()) && !this.cacheService.exists(VerifyTaskTypeEnum.WFT_PAY.getKey())) {
                    this.financeFileApi.swiftpassFinanceFileParse(verifyDate);
                    this.verifyTradeResultService.verifyWftPay(verifyDate);
                } else if (verifyTaskType.equals(VerifyTaskTypeEnum.WFT_TUI_KUAN.getCode()) && !this.cacheService.exists(VerifyTaskTypeEnum.WFT_TUI_KUAN.getKey())) {
                    this.financeFileApi.swiftpassFinanceFileParse(verifyDate);
                    this.verifyTradeResultService.verifyWftTuiKuanFlow(verifyDate);
                } else if (verifyTaskType.equals(VerifyTaskTypeEnum.DJB_PAY.getCode()) && !this.cacheService.exists(VerifyTaskTypeEnum.DJB_PAY.getKey())) {
                    this.financeFileApi.generateAccountTransDetail(verifyDate);
                    this.verifyTradeResultService.verifyDjpPayFlow(verifyDate);
                } else if (verifyTaskType.equals(VerifyTaskTypeEnum.DJB_TI_XIAN.getCode()) && !this.cacheService.exists(VerifyTaskTypeEnum.DJB_TI_XIAN.getKey())) {
                    this.financeFileApi.generateAccountTransDetail(verifyDate);
                    this.verifyTradeResultService.verifyDjpTiXianFlow(verifyDate);
                } else if (verifyTaskType.equals(VerifyTaskTypeEnum.DJB_BALANCE.getCode()) && !this.cacheService.exists(VerifyTaskTypeEnum.DJB_BALANCE.getKey())) {
                    this.balanceDetailService.verifyBalanceDetail(verifyDate);
                } else {
                    return "\u5bf9\u8d26\u7c7b\u578b\u9519\u8bef\uff0c\u65e0\u4efb\u4f55\u5bf9\u8d26\u4efb\u52a1\u53ef\u88ab\u8c03\u53d6\u6216\u5bf9\u8d26\u4efb\u52a1\u8fdb\u884c\u4e2d\uff0c\u8bf7\u7b49\u5f85\u6267\u884c\u5b8c\u6bd5\u540e\u518d\u91cd\u65b0\u8c03\u7528";
                }
                cal.add(5, 1);
            }
        }
        catch (ParseException e) {
            return "\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3ayyyyMMdd";
        }
        catch (Exception e) {
            return "\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u4e3a\uff1a" + e.getMessage();
        }
        return "\u624b\u52a8\u8c03\u7528\u6210\u529f";
    }
}

