/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.track.api.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum TransactionNodeStatusEnum {
    N_ACCEPT(1, "\u4e8b\u52a1\u8282\u70b9\u5f00\u542f"),
    N_ERROR(2, "\u4e8b\u52a1\u8282\u70b9\u5f02\u5e38"),
    N_FAIL(3, "\u4e8b\u52a1\u8282\u70b9\u5931\u8d25"),
    N_SUCCESS(4, "\u4e8b\u52a1\u8282\u70b9\u6210\u529f");

    public final int code;
    public final String desc;
    public static final Map<Integer, TransactionNodeStatusEnum> CODE_LOOKUP;
    public static final Map<Integer, String> CODE_DESC_MAP;

    private TransactionNodeStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TransactionNodeStatusEnum forCode(int code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<Integer, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CODE_LOOKUP = Arrays.stream(TransactionNodeStatusEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(TransactionNodeStatusEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

