/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.track.api.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum TransactionNodeTypeEnum {
    N_GATE(1, "\u7f51\u5173\u8282\u70b9"),
    N_POINT(2, "\u8bf7\u6c42\u8282\u70b9");

    public final int code;
    public final String desc;
    public static final Map<Integer, TransactionNodeTypeEnum> CODE_LOOKUP;
    public static final Map<Integer, String> CODE_DESC_MAP;

    private TransactionNodeTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TransactionNodeTypeEnum forCode(int code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<Integer, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CODE_LOOKUP = Arrays.stream(TransactionNodeTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(TransactionNodeTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

