/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.service.impl.db;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.tcbj.app.open.biz.dto.RequestBaseData;
import com.dtyunxi.tcbj.app.open.biz.enums.DataDistributeRespEnum;
import com.dtyunxi.tcbj.app.open.biz.service.ICenterHandleService;
import com.dtyunxi.tcbj.app.open.biz.service.ISellerSkuPriceService;
import com.dtyunxi.tcbj.app.open.dao.das.DataDistributeDas;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.ModelInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.DataDistributeRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.ModelCodeEnum;
import com.dtyunxi.tcbj.center.openapi.api.exception.DBItemEnum;
import com.dtyunxi.tcbj.center.openapi.api.exception.ItemEnum;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.ICargoApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.CargoCreateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.query.ICargoQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IBrandApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemSkuApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IPropApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PropNameCreateReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.PropNameReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.TagReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.UnitRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IPropQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IUnitQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="centerHandleMaterialDBServiceImpl")
public class CenterHandleMaterialDBServiceImpl
implements ICenterHandleService {
    private static Logger logger = LoggerFactory.getLogger(CenterHandleMaterialDBServiceImpl.class);
    @Resource
    private IItemApi iItemApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemSkuApi iItemSkuApi;
    @Resource
    private IItemSkuQueryApi iItemSkuQueryApi;
    @Resource
    private IBrandApi brandApi;
    @Resource
    private IBrandQueryApi brandQueryApi;
    @Resource
    private RequestBaseData requestBaseData;
    @Resource
    private ICargoApi cargoApi;
    @Resource
    private ICargoQueryApi cargoQueryApi;
    @Resource
    private ISellerSkuPriceService sellerSkuPriceService;
    @Resource
    private IPropApi propApi;
    @Resource
    private IPropQueryApi propQueryApi;
    @Autowired
    private DataDistributeDas dataDistributeDas;
    @Autowired
    private IUnitQueryApi unitQueryApi;

    @Override
    public String getModelType() {
        return ModelCodeEnum.MP_CX_AWK_PRODUCT.name();
    }

    @Override
    public List<DataDistributeRespDto> handle(ModelInfoReqDto modelInfoReqDto) {
        logger.info("\u7269\u6599\u6570\u636e\u5206\u53d1:{}", (Object)JSONObject.toJSONString((Object)modelInfoReqDto));
        ArrayList<DataDistributeRespDto> responseList = new ArrayList<DataDistributeRespDto>();
        List list = JSONObject.parseArray((String)modelInfoReqDto.getDataStr(), Map.class);
        DataDistributeRespDto dataDistributeRespDto = null;
        String type = DataDistributeRespEnum.SUCCESS.getCode();
        String reason = DataDistributeRespEnum.SUCCESS.getValue();
        for (Map map : list) {
            dataDistributeRespDto = new DataDistributeRespDto();
            try {
                dataDistributeRespDto.setTask_id((String)map.get(ModelCodeEnum.CIDP_TASK_UUID.name()));
                logger.info("================\u300b \u65b0\u589e\u5546\u54c1");
                Long itemId = this.createItem(map);
                logger.info("================\u300b \u65b0\u589e\u5546\u54c1sku, itemId\uff1a{}", (Object)itemId);
                this.createItemSku(map, itemId);
                logger.info("================\u300b \u65b0\u589e\u5e93\u5b58\u8d27\u54c1\u5165\u53c2");
                this.createCarg(map);
            }
            catch (Exception e) {
                type = DataDistributeRespEnum.FAILURE.getCode();
                reason = e.getMessage();
            }
        }
        dataDistributeRespDto.setType(type);
        dataDistributeRespDto.setReason(reason);
        responseList.add(dataDistributeRespDto);
        return responseList;
    }

    private Long createItem(Map<String, String> map) {
        logger.info("\u5927BcreateItem");
        ItemChangeApplyDto changApply = new ItemChangeApplyDto();
        Long id = null;
        HashMap<String, String> itemMap = new HashMap<String, String>();
        itemMap.put("name", map.get(DBItemEnum.FNAME.getCode()));
        List itemRespDtos = ((PageInfo)this.itemQueryApi.queryByPage(JSONObject.toJSONString(itemMap), Integer.valueOf(1), Integer.valueOf(10)).getData()).getList();
        logger.info("\u6821\u9a8c\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)itemRespDtos));
        if (CollectionUtil.isNotEmpty((Collection)itemRespDtos)) {
            ItemReqDto itemReqDto = new ItemReqDto();
            id = ((ItemRespDto)itemRespDtos.get(0)).getId();
            itemReqDto.setName(map.get(DBItemEnum.FNAME.getCode()));
            itemReqDto.setId(id);
            itemReqDto.setSubType(this.getItemType(map.get(DBItemEnum.PRODTYPE.getCode())));
            this.iItemApi.modifyItem(itemReqDto);
            logger.info("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5df2\u5b58\u5728\uff01");
        } else {
            changApply.setBrandId(this.createBrand(map));
            String longCode = map.get(DBItemEnum.FNUMBER.getCode());
            logger.info("\u622a\u524d\u53d6\u4e32\uff1a{} \uff0c  \u622a\u53d6\u540e\u5b57\u7b26\u4e32\uff1a{}", (Object)longCode, (Object)longCode.substring(longCode.lastIndexOf(".") + 1));
            changApply.setStatus(Integer.valueOf(Integer.parseInt(map.get(DBItemEnum.MATERIAL_STATUS.getCode()))));
            changApply.setItemCode(map.get(DBItemEnum.ZNUMBER.getCode()));
            changApply.setItemName(map.get(DBItemEnum.FNAME.getCode()));
            logger.info("=================> \u65b0\u589e\u5546\u54c1\u540d\u79f0 : {}", (Object)changApply.getItemName());
            changApply.setDisplayName(changApply.getItemName());
            changApply.setBrand(map.get(DBItemEnum.CFPINPAINAME.getCode()));
            changApply.setDirId(Long.valueOf(1288630386802423099L));
            changApply.setDirName("\u9ed8\u8ba4\u7c7b\u76ee");
            changApply.setLongCode(longCode);
            changApply.setType(Integer.valueOf(1));
            changApply.setSubType(this.getItemType(map.get(DBItemEnum.PRODTYPE.getCode())));
            changApply.setSellerId(Long.valueOf(0L));
            changApply.setCreatePerson("\u7cfb\u7edf\u7528\u6237");
            changApply.setTenantId(this.requestBaseData.getTenantId());
            changApply.setInstanceId(this.requestBaseData.getInstanceId());
            logger.info("=================> \u65b0\u589e\u5546\u54c1\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)changApply));
            id = (Long)this.iItemApi.addItem(changApply).getData();
        }
        return id;
    }

    private void createItemSku(Map<String, String> map, Long itemId) {
        ItemBundleReqDto itemBundleReqDto = new ItemBundleReqDto();
        List skuRespDtos = (List)this.iItemSkuQueryApi.queryBySkuCode((List)Lists.newArrayList((Object[])new String[]{map.get(DBItemEnum.FNUMBER.getCode())})).getData();
        logger.info("\u67e5\u8be2\u5546\u54c1sku\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)skuRespDtos));
        if (CollectionUtil.isNotEmpty((Collection)skuRespDtos)) {
            logger.info("\u5546\u54c1sku\u5df2\u5b58\u5728\uff01");
        } else {
            itemBundleReqDto.setItemId(itemId);
            itemBundleReqDto.setMinPackage(StringUtils.isEmpty((CharSequence)map.get(DBItemEnum.FNUMBER_MINUNIT.getCode())) ? null : Integer.valueOf((int)Double.parseDouble(map.get(DBItemEnum.FNUMBER_MINUNIT.getCode()))));
            itemBundleReqDto.setMinPackage(Integer.valueOf(1));
            itemBundleReqDto.setCargoCode(map.get(DBItemEnum.FNUMBER.getCode()));
            itemBundleReqDto.setCode(map.get(DBItemEnum.FNUMBER.getCode()));
            itemBundleReqDto.setCreatePerson("\u7cfb\u7edf\u7528\u6237");
            itemBundleReqDto.setTenantId(this.requestBaseData.getTenantId());
            itemBundleReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            logger.info("=================> \u65b0\u589e\u5546\u54c1sku\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)itemBundleReqDto));
            ArrayList prices = Lists.newArrayList();
            ItemPriceReqDto itemPriceReqDto = new ItemPriceReqDto();
            itemPriceReqDto.setName("\u5212\u7ebf\u4ef7");
            itemPriceReqDto.setCurrency("\u5143");
            String price = StringUtils.isEmpty((CharSequence)map.get(DBItemEnum.PRICE.getCode())) ? "99999.90" : map.get(DBItemEnum.PRICE.getCode());
            itemPriceReqDto.setPrice(new BigDecimal(price));
            itemPriceReqDto.setPriceType("PRICE");
            prices.add(itemPriceReqDto);
            itemPriceReqDto = new ItemPriceReqDto();
            itemPriceReqDto.setName("\u552e\u4ef7");
            itemPriceReqDto.setCurrency("\u5143");
            itemPriceReqDto.setPrice(new BigDecimal(price));
            itemPriceReqDto.setPriceType("RETAIL_PRICE");
            prices.add(itemPriceReqDto);
            itemBundleReqDto.setPrices((List)prices);
            this.iItemSkuApi.addItemSku((List)Lists.newArrayList((Object[])new ItemBundleReqDto[]{itemBundleReqDto}));
        }
    }

    public void createCarg(Map<String, String> map) {
        CargoCreateReqDto cargoCreateReqDto = new CargoCreateReqDto();
        CargoRespDto respDto = (CargoRespDto)this.cargoQueryApi.queryByCode(map.get(DBItemEnum.FNUMBER.getCode()), "").getData();
        logger.info("\u67e5\u8be2\u5546\u54c1\u8d27\u54c1\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)respDto));
        if (ObjectUtils.isNotEmpty((Object)respDto)) {
            logger.info("\u5546\u54c1\u8d27\u54c1\u5df2\u5b58\u5728\uff01");
        } else {
            cargoCreateReqDto.setCode(map.get(DBItemEnum.FNUMBER.getCode()));
            cargoCreateReqDto.setArtNo(map.get(DBItemEnum.FNUMBER.getCode()));
            cargoCreateReqDto.setName(map.get(DBItemEnum.FNAME.getCode()));
            cargoCreateReqDto.setBrandName(map.get(DBItemEnum.CFPINPAINAME.getCode()));
            cargoCreateReqDto.setTenantId(this.requestBaseData.getTenantId());
            cargoCreateReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            logger.info("=================> \u65b0\u589e\u5546\u54c1\u8d27\u54c1\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)cargoCreateReqDto));
            this.cargoApi.addCargo(cargoCreateReqDto).getData();
        }
    }

    private Long createBrand(Map<String, String> map) {
        Long id = null;
        String filter = "{\"name\":\"" + map.get(ItemEnum.CFPINPAINAME.getCode()) + "\"}";
        PageInfo dtoPageInfo = (PageInfo)this.brandQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(10)).getData();
        logger.info("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)dtoPageInfo.getList()));
        if (CollectionUtil.isEmpty((Collection)dtoPageInfo.getList())) {
            TagReqDto.BrandReqDto brandReqDto = new TagReqDto.BrandReqDto();
            brandReqDto.setCode(map.get(ItemEnum.CFPINPAIDNUM.getCode()));
            brandReqDto.setName(map.get(ItemEnum.CFPINPAINAME.getCode()));
            brandReqDto.setStatus(Integer.valueOf(1));
            brandReqDto.setCreatePerson("\u7cfb\u7edf\u7528\u6237");
            brandReqDto.setTenantId(this.requestBaseData.getTenantId());
            brandReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            logger.info("=================> \u65b0\u589e\u54c1\u724c\u5165\u53c2 : {}", (Object)JSONObject.toJSONString((Object)brandReqDto));
            id = (Long)this.brandApi.addBrand(brandReqDto).getData();
            logger.info("=================> \u65b0\u589e\u54c1\u724cid : {}", (Object)id);
        } else {
            logger.info("=================> \u54c1\u724c\u5df2\u5b58\u5728 : {}", (Object)((BrandRespDto)dtoPageInfo.getList().get(0)).getId());
            id = ((BrandRespDto)dtoPageInfo.getList().get(0)).getId();
        }
        return id;
    }

    private Long createItemUnit(String unitName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", unitName);
        List list = ((PageInfo)this.unitQueryApi.queryByPage(JSONObject.toJSONString(map), Integer.valueOf(1), Integer.valueOf(10)).getData()).getList();
        return CollectionUtil.isNotEmpty((Collection)list) ? ((UnitRespDto)list.get(0)).getId() : null;
    }

    private void createItemPrice(String longCode) {
        this.sellerSkuPriceService.addNewSellerSkuPrice(longCode);
    }

    private Integer getItemType(String type) {
        switch (type) {
            case "Product": {
                return 1;
            }
        }
        return 1;
    }

    private boolean isEmpty(Object obj) {
        if (obj.toString().equals("{\"extFields\":{}}")) {
            return true;
        }
        if (null == obj) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StrUtil.isEmpty((CharSequence)((CharSequence)obj));
        }
        if (obj instanceof Map) {
            return MapUtil.isEmpty((Map)((Map)obj));
        }
        if (obj instanceof Iterable) {
            return IterUtil.isEmpty((Iterable)((Iterable)obj));
        }
        if (obj instanceof Iterator) {
            return IterUtil.isEmpty((Iterator)((Iterator)obj));
        }
        return ArrayUtil.isArray((Object)obj) ? ArrayUtil.isEmpty((Object)obj) : false;
    }

    private String assembleAttr(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"backDirList\":[1288630386802423099],\"propList\":[{\"extFields\":{},\"id\":");
        PropNameReqDto propNameReqDto = new PropNameReqDto();
        propNameReqDto.setName("\u9ed8\u8ba4");
        List list = ((PageInfo)this.propQueryApi.queryPropNameByPage(propNameReqDto, Integer.valueOf(1), Integer.valueOf(10)).getData()).getList();
        logger.info("\u67e5\u8be2\u5230\u5c5e\u6027\u540d\uff1a{}", (Object)JSONObject.toJSONString((Object)list));
        List collect = list.stream().filter(t -> t.getName().equals("\u9ed8\u8ba4")).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(collect)) {
            PropNameCreateReqDto propNameCreateReqDto = new PropNameCreateReqDto();
            propNameCreateReqDto.setCode(DateUtil.getCurrentTimeNum());
            propNameCreateReqDto.setName("\u9ed8\u8ba4");
            propNameCreateReqDto.setInputType(Integer.valueOf(1));
            propNameCreateReqDto.setRequired(Integer.valueOf(1));
            propNameCreateReqDto.setTenantId(this.requestBaseData.getTenantId());
            propNameCreateReqDto.setInstanceId(this.requestBaseData.getInstanceId());
            propNameCreateReqDto.setPropValueList((List)Lists.newArrayList((Object[])new String[]{map.get(ItemEnum.FMODEL.getCode())}));
            logger.info("\u65b0\u589e\u5c5e\u6027\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)propNameCreateReqDto));
            Long aLong = (Long)this.propApi.addProp(propNameCreateReqDto).getData();
            logger.info("\u83b7\u53d6\u5230\u5c5e\u6027id\uff1a{}", (Object)aLong);
            stringBuilder.append(aLong.toString() + ",");
        } else {
            CubeBeanUtils.copyProperties((Object)propNameReqDto, collect.get(0), (String[])new String[0]);
            stringBuilder.append(propNameReqDto.getId().toString() + ",");
            logger.info("copy\u540e\u53c2\u6570 \uff1a{}", (Object)JSONObject.toJSONString((Object)propNameReqDto));
            if (!propNameReqDto.getPropValueList().contains(map.get(ItemEnum.FMODEL.getCode()))) {
                propNameReqDto.getPropValueList().add(map.get(ItemEnum.FMODEL.getCode()));
                logger.info("=================> \u5546\u54c1\u89c4\u683c\u4e0d\u5b58\u5728\u65b0\u589e\u89c4\u683c\u4fe1\u606f\uff01 {}", (Object)propNameReqDto.getPropValueList());
                this.propApi.modifyProp(propNameReqDto);
            }
        }
        String name = "\"name\":\"\u9ed8\u8ba4\",";
        String propValueList = "\"propValueList\":[\"" + map.get(ItemEnum.FMODEL.getCode()) + "\"]}]}";
        stringBuilder.append(name);
        stringBuilder.append(propValueList);
        logger.info("\u7ec4\u88c5\u5c5e\u6027\uff1a{}", (Object)JSONObject.toJSONString((Object)stringBuilder.toString()));
        return stringBuilder.toString().replace("\\", "").replace("\\\\", "");
    }

    @DS(value="slave_1")
    private void jointBrand(Map<String, String> map) {
        List mapList = this.dataDistributeDas.selectBrand(map.get(DBItemEnum.FNUMBER.getCode()));
        if (CollectionUtil.isNotEmpty((Collection)mapList)) {
            Map itemMap = (Map)mapList.get(0);
            logger.info("==========================\u300b \u5546\u54c1\u957f\u7f16\u7801{}\uff0c\u4f20\u5165\u54c1\u724c\u540d\u79f0{}\uff0c\u67e5\u8be2\u5230\u54c1\u724c\u540d\u79f0{}", new Object[]{map.get("FNUMBER"), map.get("CFPINPAINAME"), itemMap.get("PROD_BRAND_NAME")});
            map.put("CFPINPAINAME", (String)itemMap.get("PROD_BRAND_NAME"));
            map.put("D_SOURCESYSTEM", (String)itemMap.get("D_SOURCESYSTEM"));
        }
    }
}

