/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.store.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.tcbj.app.open.biz.store.IStoreService;
import com.dtyunxi.tcbj.app.open.biz.store.token.StoreTokenProperties;
import com.dtyunxi.tcbj.app.open.biz.utils.HttpUtil;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.store.StoreDetailsReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.store.StorePageReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.store.GeoRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.store.StoreDataRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.store.StoreDetailsRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.store.StoreInfoRespDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.store.StoreTokenDataRespDto;
import com.dtyunxi.tcbj.center.openapi.api.enums.StoreUrlEnum;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.customer.api.IStoreAreaApi;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreAreaLevelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreAreaReqDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.IStoreApi;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class StoreServiceImpl
implements IStoreService {
    private static final Logger logger = LoggerFactory.getLogger(IStoreService.class);
    @Value(value="${yxt.store.url}")
    private String url;
    @Resource
    private StoreTokenProperties storeTokenProperties;
    @Resource
    private IStoreApi storeApi;
    @Resource
    private IStoreAreaApi storeAreaApi;
    @Resource
    private HttpUtil httpUtil;
    @Resource
    private ICacheService cacheService;
    private static final String STORE_ACCESS_TOKEN = "STORE_ACCESS_TOKEN";

    @Override
    public PageInfo<StoreInfoRespDto> queryStoreList(StorePageReqDto dto) {
        logger.info("\u3010\u8d62\u9500\u901a\u3011\u83b7\u53d6\u836f\u5e97\u5217\u8868\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        JSONObject map = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dto));
        map.put("access_token", this.queryToken());
        String storeUrl = this.url + StoreUrlEnum.STORE_LIST.getUrl();
        StoreDataRespDto storeDataRespDto = this.httpPost(storeUrl, (Map<String, Object>)map, StoreDataRespDto.class);
        logger.info("\u3010\u8d62\u9500\u901a\u3011\u83b7\u53d6\u836f\u5e97\u5217\u8868\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        if (Objects.isNull(storeDataRespDto)) {
            throw new BizException("\u8c03\u7528\u8d62\u9500\u901a\u836f\u5e97\u5217\u8868\u4fe1\u606f\u5931\u8d25");
        }
        logger.info("\u3010\u8d62\u9500\u901a\u3011\u83b7\u53d6\u836f\u5e97\u5217\u8868\u4fe1\u606furl: {}, {}", (Object)storeUrl, (Object)JacksonUtil.toJson((Object)storeDataRespDto));
        if (!"1".equals(storeDataRespDto.getStatus())) {
            throw new BizException(storeDataRespDto.getMessage());
        }
        PageInfo pageInfo = new PageInfo();
        this.getPageInfo(storeDataRespDto, (PageInfo<StoreInfoRespDto>)pageInfo);
        ArrayList storeInfoRespDtos = (ArrayList)JSON.parseObject((String)storeDataRespDto.getDataset(), (TypeReference)new TypeReference<ArrayList<StoreInfoRespDto>>(){}, (Feature[])new Feature[0]);
        pageInfo.setList((List)storeInfoRespDtos);
        return pageInfo;
    }

    private void getPageInfo(StoreDataRespDto result, PageInfo<StoreInfoRespDto> pageInfo) {
        int pageSize = Integer.parseInt(result.getPageSize());
        pageInfo.setPageNum(Integer.parseInt(result.getPageNo()));
        pageInfo.setPageSize(pageSize);
        int total = Integer.parseInt(result.getTotal());
        pageInfo.setPages(total % pageSize == 0 ? total / pageSize : total / pageSize + 1);
        pageInfo.setTotal((long)total);
    }

    @Override
    public PageInfo<StoreInfoRespDto> queryStoreChangeList(StorePageReqDto dto) {
        logger.info("\u3010\u8d62\u9500\u901a\u3011\u83b7\u53d6\u836f\u5e97\u6700\u8fd1\u53d8\u66f4\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        JSONObject map = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dto));
        map.put("access_token", this.queryToken());
        String storeChangeUrl = this.url + StoreUrlEnum.STORE_CHANGE_LIST.getUrl();
        StoreDataRespDto result = this.httpPost(storeChangeUrl, (Map<String, Object>)map, StoreDataRespDto.class);
        if (Objects.isNull(result)) {
            throw new BizException("\u8c03\u7528\u8d62\u9500\u901a\u836f\u5e97\u6700\u8fd1\u53d8\u66f4\u5931\u8d25");
        }
        logger.info("\u3010\u8d62\u9500\u901a\u3011\u83b7\u53d6\u836f\u5e97\u6700\u8fd1\u53d8\u66f4\u4fe1\u606furl: {}, {}", (Object)storeChangeUrl, (Object)JSONObject.toJSONString((Object)result));
        if (!"1".equals(result.getStatus())) {
            throw new BizException(result.getMessage());
        }
        PageInfo pageInfo = new PageInfo();
        this.getPageInfo(result, (PageInfo<StoreInfoRespDto>)pageInfo);
        ArrayList storeInfoRespDtos = (ArrayList)JSON.parseObject((String)result.getDataset(), (TypeReference)new TypeReference<ArrayList<StoreInfoRespDto>>(){}, (Feature[])new Feature[0]);
        pageInfo.setList((List)storeInfoRespDtos);
        return pageInfo;
    }

    @Override
    public PageInfo<StoreDetailsRespDto> queryStoreDetails(StoreDetailsReqDto dto) {
        logger.info("\u3010\u8d62\u9500\u901a\u3011\u83b7\u53d6\u836f\u5e97\u8be6\u7ec6\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        JSONObject map = JSONObject.parseObject((String)JSONObject.toJSONString((Object)dto));
        map.put("access_token", (Object)this.queryToken());
        String storeDetailsUrl = this.url + StoreUrlEnum.STORE_DETAILS.getUrl();
        StoreDataRespDto result = this.httpPost(storeDetailsUrl, (Map<String, Object>)map, StoreDataRespDto.class);
        if (Objects.isNull(result)) {
            throw new BizException("\u8c03\u7528\u8d62\u9500\u901a\u836f\u5e97\u8be6\u60c5\u5931\u8d25");
        }
        logger.info("\u3010\u8d62\u9500\u901a\u3011\u83b7\u53d6\u836f\u5e97\u8be6\u7ec6\u4fe1\u606furl: {}, {}", (Object)storeDetailsUrl, (Object)JSONObject.toJSONString((Object)result));
        if (!"1".equals(result.getStatus())) {
            throw new BizException(result.getMessage());
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(Integer.parseInt(result.getPageNo()));
        pageInfo.setPageSize(Integer.parseInt(result.getPageSize()));
        pageInfo.setTotal(Long.parseLong(result.getTotal()));
        ArrayList storeRespDtos = (ArrayList)JSON.parseObject((String)result.getDataset(), (TypeReference)new TypeReference<ArrayList<StoreDetailsRespDto>>(){}, (Feature[])new Feature[0]);
        pageInfo.setList((List)storeRespDtos);
        return pageInfo;
    }

    @Override
    public String queryToken() {
        String cacheToken = (String)this.cacheService.getCache(STORE_ACCESS_TOKEN, String.class);
        if (StringUtils.isNotEmpty((CharSequence)cacheToken)) {
            return cacheToken;
        }
        String tokenUrl = this.url + StoreUrlEnum.STORE_TOKEN.getUrl();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("client_id", this.storeTokenProperties.getClientId());
        map.put("client_secret", this.storeTokenProperties.getClientSecret());
        map.put("grant_type", this.storeTokenProperties.getGrantType());
        StoreTokenDataRespDto result = this.httpPost(tokenUrl, map, StoreTokenDataRespDto.class);
        logger.info("\u3010\u8d62\u9500\u901a\u3011token: {}", (Object)result);
        if (Objects.isNull(result)) {
            throw new BizException("\u3010\u8d62\u9500\u901a\u3011\u83b7\u53d6token\u4fe1\u606f\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)result.getAccessToken())) {
            throw new BizException(result.getErrorDescription());
        }
        cacheToken = result.getAccessToken();
        this.cacheService.setCache(STORE_ACCESS_TOKEN, cacheToken, (Object)result.getExpiresIn());
        return cacheToken;
    }

    @Override
    public PageInfo<GeoRespDto> queryGeo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("access_token", this.queryToken());
        String storeDetailsUrl = this.url + StoreUrlEnum.GEO.getUrl();
        StoreDataRespDto result = this.httpPost(storeDetailsUrl, map, StoreDataRespDto.class);
        if (Objects.isNull(result)) {
            throw new BizException("\u8c03\u7528\u8d62\u9500\u901a\u5730\u7406\u533a\u57df\u4fe1\u606f\u5931\u8d25");
        }
        logger.info("\u3010\u8d62\u9500\u901a\u3011\u83b7\u53d6\u5730\u7406\u533a\u57df\u4fe1\u606furl: {}, {}", (Object)storeDetailsUrl, (Object)JSONObject.toJSONString((Object)result));
        if (!"1".equals(result.getStatus())) {
            throw new BizException(result.getMessage());
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(Integer.parseInt(result.getPageNo()));
        pageInfo.setPageSize(Integer.parseInt(result.getPageSize()));
        pageInfo.setTotal(Long.parseLong(result.getTotal()));
        ArrayList storeRespDtos = (ArrayList)JSON.parseObject((String)result.getDataset(), (TypeReference)new TypeReference<ArrayList<GeoRespDto>>(){}, (Feature[])new Feature[0]);
        pageInfo.setList((List)storeRespDtos);
        return pageInfo;
    }

    @Override
    public void initializeStore(Integer pageSize) {
        StorePageReqDto dto = new StorePageReqDto();
        dto.setPageNo(Integer.valueOf(1));
        dto.setPageSize(Integer.valueOf(1));
        PageInfo<StoreInfoRespDto> storeInfoRespDtoPageInfo = this.queryStoreList(dto);
        if (ObjectUtils.isEmpty(storeInfoRespDtoPageInfo)) {
            logger.error("\u67e5\u8be2\u5f02\u5e38");
        }
        logger.info("\u9700\u8981\u540c\u6b65\u7684\u6570\u636e\uff1a{}", (Object)storeInfoRespDtoPageInfo.getTotal());
        if (ObjectUtils.isNotEmpty((Object)storeInfoRespDtoPageInfo.getTotal()) && storeInfoRespDtoPageInfo.getTotal() > 0L) {
            int time = new BigDecimal(storeInfoRespDtoPageInfo.getTotal()).divide(new BigDecimal(pageSize)).setScale(0, 2).intValue();
            logger.info("\u6267\u884c\u6b21\u6570\uff1a{}", (Object)time);
            int i = 1;
            while (i <= time) {
                logger.info("\u6267\u884c\u6b65\u9aa4\uff1a{}", (Object)i);
                int page = i++;
                ExecutorUtils.execute(() -> {
                    logger.info("\u5f02\u6b65\u6267\u884c\uff1a{}=={}", (Object)page, (Object)pageSize);
                    try {
                        StorePageReqDto reqDto = new StorePageReqDto();
                        reqDto.setPageNo(Integer.valueOf(page));
                        reqDto.setPageSize(pageSize);
                        List<StoreReqDto> storeReqDtoList = this.queryStoreAndDetail(reqDto);
                        if (CollectionUtil.isNotEmpty(storeReqDtoList)) {
                            this.storeApi.addStoreBatch(storeReqDtoList);
                            List collect = storeReqDtoList.stream().map(StoreReqDto::getStoreId).collect(Collectors.toList());
                            this.storeApi.fillStoreAreaCode(collect);
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                });
            }
        }
        logger.info("\u6267\u884c\u7ed3\u675f");
    }

    public <T> T httpPost(String url, Map<String, Object> map, Class<T> clazz) {
        ArrayList params = Lists.newArrayList();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            params.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
        }
        HttpPost httppost = new HttpPost(url);
        httppost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
        HttpResponse response = null;
        try {
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity((List)params, "UTF-8"));
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            response = httpClient.execute((HttpUriRequest)httppost);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (response != null);
        HttpEntity httpEntity = response.getEntity();
        String result = null;
        try {
            result = EntityUtils.toString((HttpEntity)httpEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)JSONObject.parseObject((String)result, clazz);
    }

    @Override
    public void initializeStoreArea() {
        logger.info("\u8bf7\u6c42\u5f00\u59cb\u521d\u59cb\u5316\u8d62\u9500\u901a\u533a\u57df\u6570\u636e");
        PageInfo<GeoRespDto> geoRespDtoPageInfo = this.queryGeo();
        if (ObjectUtils.isEmpty(geoRespDtoPageInfo) || CollectionUtil.isEmpty((Collection)geoRespDtoPageInfo.getList())) {
            logger.info("\u521d\u59cb\u5316\u8d62\u9500\u901a\u533a\u57df\u6570\u636e\u7ed3\u7b97\uff0c\u6682\u65e0\u6570\u636e\u9700\u8981\u540c\u6b65");
            return;
        }
        ArrayList errorGeoList = new ArrayList();
        ArrayList areaReqDtoList = new ArrayList();
        HashMap<String, GeoRespDto> provinceMaps = new HashMap<String, GeoRespDto>();
        HashMap<String, GeoRespDto> cityMaps = new HashMap<String, GeoRespDto>();
        geoRespDtoPageInfo.getList().forEach(geo -> {
            int i = 0;
            if (StringUtils.isNotEmpty((CharSequence)geo.getProvinceCode()) && StringUtils.isNotEmpty((CharSequence)geo.getProvinceName())) {
                provinceMaps.put(geo.getProvinceCode(), (GeoRespDto)geo);
                ++i;
                if (StringUtils.isNotEmpty((CharSequence)geo.getCityCode()) && StringUtils.isNotEmpty((CharSequence)geo.getCityName())) {
                    cityMaps.put(geo.getCityCode(), (GeoRespDto)geo);
                    ++i;
                    if (StringUtils.isNotEmpty((CharSequence)geo.getDistrictCode()) && StringUtils.isNotEmpty((CharSequence)geo.getDistrictName())) {
                        StoreAreaReqDto storeArea = new StoreAreaReqDto();
                        storeArea.setCode(geo.getDistrictCode());
                        storeArea.setName(geo.getDistrictName());
                        storeArea.setLevel(StoreAreaLevelEnum.DISTRICT.getCode());
                        storeArea.setParentCode(geo.getCityCode());
                        areaReqDtoList.add(storeArea);
                        ++i;
                    }
                }
            }
            if (ObjectUtils.isNotEmpty((Object)geo.getCityCode()) && i < 2 || ObjectUtils.isNotEmpty((Object)geo.getDistrictCode()) && i < 3 || i == 0) {
                errorGeoList.add(geo);
            }
        });
        provinceMaps.forEach((k, v) -> {
            StoreAreaReqDto storeArea = new StoreAreaReqDto();
            storeArea.setCode(k);
            storeArea.setName(v.getProvinceName());
            storeArea.setLevel(StoreAreaLevelEnum.PROVINCE.getCode());
            storeArea.setParentCode("0");
            areaReqDtoList.add(storeArea);
        });
        cityMaps.forEach((k, v) -> {
            StoreAreaReqDto storeArea = new StoreAreaReqDto();
            storeArea.setCode(k);
            storeArea.setName(v.getCityName());
            storeArea.setLevel(StoreAreaLevelEnum.CITY.getCode());
            storeArea.setParentCode(v.getProvinceCode());
            areaReqDtoList.add(storeArea);
        });
        logger.info("\u603b\u6570\u636e\u4e3a\uff1a{}\uff0c\u53ef\u4ee5\u540c\u6b65\u7684\u6570\u636e\u4e3a\uff1a{}\uff0c\u5f02\u5e38\u6570\u636e\u4e3a\uff1a{}", new Object[]{geoRespDtoPageInfo.getList().size(), areaReqDtoList.size(), errorGeoList.size()});
        this.storeAreaApi.initStoreArea(areaReqDtoList);
    }

    @Override
    public String initializePartStore(StorePageReqDto dto) {
        List<StoreReqDto> storeReqDtoList = this.queryStoreAndDetail(dto);
        if (CollectionUtil.isEmpty(storeReqDtoList)) {
            return "\u65e0\u6570\u636e\u9700\u8981\u540c\u6b65";
        }
        this.storeApi.syncStore(storeReqDtoList);
        return "\u540c\u6b65\u5b8c\u6210\uff0c\u5171\u8ba1\uff1a" + storeReqDtoList.size();
    }

    @Override
    public List<StoreReqDto> queryStoreAndDetail(StorePageReqDto dto) {
        logger.info("\u83b7\u53d6\u836f\u5e97\u57fa\u7840\u6570\u636e\u53ca\u8be6\u7ec6\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        PageInfo<StoreInfoRespDto> pageInfo = this.queryStoreList(dto);
        if (Objects.isNull(pageInfo)) {
            throw new BizException("\u83b7\u53d6\u836f\u5e97\u6570\u636e\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            logger.info("\u6ca1\u6709\u836f\u5e97\u6570\u636e");
            return new ArrayList<StoreReqDto>();
        }
        ArrayList<StoreReqDto> storeReqDtoList = new ArrayList<StoreReqDto>();
        StoreDetailsReqDto storeDetailsParams = new StoreDetailsReqDto();
        pageInfo.getList().forEach(storeBase -> {
            StoreReqDto storeReqDto = new StoreReqDto();
            CubeBeanUtils.copyProperties((Object)storeReqDto, (Object)storeBase, (String[])new String[0]);
            if (StringUtils.isNotEmpty((CharSequence)storeBase.getStoreId())) {
                storeDetailsParams.setStoreId(storeBase.getStoreId());
                PageInfo<StoreDetailsRespDto> storeDetailsRespDtoPageInfo = this.queryStoreDetails(storeDetailsParams);
                if (ObjectUtils.isNotEmpty(storeDetailsRespDtoPageInfo) && CollectionUtil.isNotEmpty((Collection)storeDetailsRespDtoPageInfo.getList())) {
                    CubeBeanUtils.copyProperties((Object)storeReqDto, storeDetailsRespDtoPageInfo.getList().get(0), (String[])new String[0]);
                    if (StringUtils.isNotEmpty((CharSequence)storeReqDto.getIsChain()) && storeReqDto.getIsChain().trim().equals("1")) {
                        storeReqDto.setIsChain("\u662f");
                    } else {
                        storeReqDto.setIsChain("\u5426");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)storeReqDto.getIsInsurance()) && storeReqDto.getIsInsurance().trim().equals("1")) {
                        storeReqDto.setIsInsurance("\u662f");
                    } else {
                        storeReqDto.setIsInsurance("\u5426");
                    }
                }
            }
            storeReqDtoList.add(storeReqDto);
        });
        return storeReqDtoList;
    }

    @Deprecated
    private StoreReqDto buildStoreDto(StoreInfoRespDto storeBase, List<StoreDetailsRespDto> storeDetails) {
        StoreReqDto storeReqDto = new StoreReqDto();
        if (ObjectUtils.isNotEmpty((Object)storeBase)) {
            CubeBeanUtils.copyProperties((Object)storeReqDto, (Object)storeBase, (String[])new String[0]);
        }
        if (CollectionUtil.isNotEmpty(storeDetails)) {
            CubeBeanUtils.copyProperties((Object)storeReqDto, (Object)storeDetails.get(0), (String[])new String[0]);
        }
        return storeReqDto;
    }
}

