/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.price.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.tcbj.app.open.biz.price.IBItemPriceService;
import com.dtyunxi.tcbj.app.open.biz.utils.ErpOrderAssert;
import com.dtyunxi.tcbj.app.open.biz.utils.OrderExceptionEnum;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.price.ItemPriceExtDto;
import com.dtyunxi.yundt.cube.center.price.api.constants.CategoryCodeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PriceHelper {
    private static final Logger log = LoggerFactory.getLogger(PriceHelper.class);
    @Autowired
    private IBItemPriceService ibItemPriceService;

    public void assemblyPrice(OrderReqDto orderReqDto) {
        List itemPriceExtDtos = orderReqDto.getOrderItems().stream().map(this::converPriceReqDto).collect(Collectors.toList());
        this.replacePrice(itemPriceExtDtos, Long.valueOf(orderReqDto.getCustomerId()));
        Map itemPriceExtDtoMap = itemPriceExtDtos.stream().collect(Collectors.toMap(ItemPriceExtDto::getItemId, Function.identity()));
        BigDecimal totaPrice = BigDecimal.ZERO;
        for (TradeItemReqDto tradeItem : orderReqDto.getOrderItems()) {
            ItemPriceExtDto itemPriceExtDto = (ItemPriceExtDto)itemPriceExtDtoMap.get(Long.valueOf(tradeItem.getItemSerial()));
            ErpOrderAssert.notNull(itemPriceExtDto, OrderExceptionEnum.NO_OFFER, tradeItem.getItemCode());
            BigDecimal itemPrice = this.getItemPrice(itemPriceExtDto, tradeItem.getItemNum());
            ErpOrderAssert.notNull(itemPrice, OrderExceptionEnum.NO_OFFER, tradeItem.getItemCode());
            tradeItem.setItemPrice(itemPrice);
            tradeItem.setItemOrigPrice(itemPrice);
            tradeItem.setItemMarketPrice(itemPrice);
            totaPrice = totaPrice.add(itemPrice.multiply(BigDecimal.valueOf(tradeItem.getItemNum().intValue())));
        }
        orderReqDto.setPayAmount(totaPrice);
        orderReqDto.setTotalAmount(totaPrice);
    }

    public BigDecimal getItemPrice(ItemPriceExtDto itemPriceExtDto, Integer itemNum) {
        BigDecimal result = null;
        if (itemPriceExtDto.isHasLadderPrice()) {
            ItemPriceExtDto.LadderPrice ladderPrice = itemPriceExtDto.getLadderPrices().stream().filter(e -> e.getLower().compareTo(itemNum) <= 0 && (e.getUpper() == null || e.getUpper().compareTo(itemNum) >= 0)).findFirst().orElse(null);
            if (ladderPrice != null) {
                result = ladderPrice.getPrice();
            }
        } else {
            result = itemPriceExtDto.isHasDiscountPrice() ? itemPriceExtDto.getDiscountPrice() : itemPriceExtDto.getRetailPrice();
        }
        return result;
    }

    public void replacePrice(List<? extends ItemPriceExtDto> priceExtDtos, Long customerId) {
        if (CollectionUtil.isNotEmpty(priceExtDtos)) {
            CommunalPriceQueryReqDto communalPriceQueryReqDto = new CommunalPriceQueryReqDto();
            communalPriceQueryReqDto.setCustId(customerId);
            communalPriceQueryReqDto.setPriceCategoryCode(CategoryCodeEnum.SUPPLY_CHANNEL.getCode());
            communalPriceQueryReqDto.setPolicyDate((Date)DateTime.now());
            ArrayList<CommunalPriceQueryReqDto.ItemSkuPriceReqDto> skuList = new ArrayList<CommunalPriceQueryReqDto.ItemSkuPriceReqDto>(priceExtDtos.size());
            for (ItemPriceExtDto itemPriceExtDto : priceExtDtos) {
                CommunalPriceQueryReqDto.ItemSkuPriceReqDto itemSkuPriceReqDto = new CommunalPriceQueryReqDto.ItemSkuPriceReqDto();
                BeanUtil.copyProperties((Object)itemPriceExtDto, (Object)itemSkuPriceReqDto, (String[])new String[0]);
                itemSkuPriceReqDto.setSkuSellPrice(itemPriceExtDto.getRetailPrice());
                itemSkuPriceReqDto.setShopId(itemPriceExtDto.getShopId());
                if (!ObjectUtil.isNotEmpty((Object)itemSkuPriceReqDto.getSkuId())) continue;
                skuList.add(itemSkuPriceReqDto);
            }
            communalPriceQueryReqDto.setSkuList(skuList);
            log.info("\u5f00\u59cb\u67e5\u8be2\u5916\u90e8\u4ef7\u683c");
            List itemPriceEsDtos = (List)this.ibItemPriceService.getItemPrice(communalPriceQueryReqDto).getData();
            if (CollectionUtil.isNotEmpty((Collection)itemPriceEsDtos)) {
                for (ItemPolicyPriceRespDto itemPriceEsDto : itemPriceEsDtos) {
                    for (ItemPriceExtDto itemPriceExtDto : priceExtDtos) {
                        if (!itemPriceEsDto.getSkuId().equals(itemPriceExtDto.getSkuId())) continue;
                        if (itemPriceEsDto.getHasLadderPrice()) {
                            log.info("itemId=[{}]skuId=[{}]itemName=[{}]\u914d\u7f6e\u4e86\u9636\u68af\u4ef7", new Object[]{itemPriceExtDto.getItemId(), itemPriceExtDto.getSkuId(), itemPriceExtDto.getItemName()});
                            itemPriceExtDto.setHasLadderPrice(true);
                            ArrayList<ItemPriceExtDto.LadderPrice> ladderPrices = new ArrayList<ItemPriceExtDto.LadderPrice>();
                            for (ItemPolicyPriceRespDto.LadderPrice ladderPrice : itemPriceEsDto.getLadderPrices()) {
                                ItemPriceExtDto.LadderPrice price = new ItemPriceExtDto.LadderPrice();
                                BeanUtil.copyProperties((Object)ladderPrice, (Object)price, (String[])new String[0]);
                                ladderPrices.add(price);
                            }
                            itemPriceExtDto.setLadderPrices(ladderPrices);
                            continue;
                        }
                        if (itemPriceEsDto.getHasDiscountPrice()) {
                            log.info("itemId=[{}]skuId=[{}]itemName=[{}]\u914d\u7f6e\u4e86\u6298\u6263", new Object[]{itemPriceExtDto.getItemId(), itemPriceExtDto.getSkuId(), itemPriceExtDto.getItemName()});
                            itemPriceExtDto.setHasDiscountPrice(true);
                            itemPriceExtDto.setDiscountPrice(itemPriceEsDto.getDiscountPrice());
                            continue;
                        }
                        itemPriceExtDto.setRetailPrice(itemPriceEsDto.getPrice());
                    }
                }
            }
        }
    }

    private ItemPriceExtDto converPriceReqDto(TradeItemReqDto tradeItemReqDto) {
        ItemPriceExtDto itemPriceExtDto = new ItemPriceExtDto();
        itemPriceExtDto.setItemId(Long.valueOf(tradeItemReqDto.getItemSerial()));
        itemPriceExtDto.setSkuId(Long.valueOf(tradeItemReqDto.getSkuSerial()));
        itemPriceExtDto.setRetailPrice(tradeItemReqDto.getItemPrice());
        itemPriceExtDto.setShopId(Long.valueOf(tradeItemReqDto.getShopId()));
        return itemPriceExtDto;
    }
}

