/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.OrderAndStatusRespDto;
import com.dtyunxi.tcbj.api.dto.response.PreemptSourceNoRespDto;
import com.dtyunxi.tcbj.api.query.IInventoryReportQueryApi;
import com.dtyunxi.tcbj.api.query.IOrderReportQueryApi;
import com.dtyunxi.tcbj.app.open.biz.enums.ContrastInventoryPreemptTypeEnum;
import com.dtyunxi.tcbj.app.open.biz.enums.OrderTradeStatusEnum;
import com.dtyunxi.tcbj.app.open.biz.service.IContrastInventoryPreemptService;
import com.dtyunxi.tcbj.app.open.biz.service.IDataDistributeService;
import com.dtyunxi.tcbj.app.open.dao.eo.ContrastInventoryPreemptEo;
import com.dtyunxi.tcbj.app.open.dao.eo.YxyInventoryVo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="contrastInventoryPreemptEvent")
@Scope(value="prototype")
public class ContrastInventoryPreemptEvent
extends SingleTupleScheduleEvent {
    private static Logger logger = LoggerFactory.getLogger(ContrastInventoryPreemptEvent.class);
    @Resource
    private IInventoryReportQueryApi inventoryReportQueryApi;
    @Resource
    private IOrderReportQueryApi orderReportQueryApi;
    @Resource
    private IDataDistributeService dataDistributeService;
    @Resource
    private IContrastInventoryPreemptService contrastInventoryPreemptService;

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        long startTime = System.currentTimeMillis();
        this.task(null);
        long endTime = System.currentTimeMillis();
        logger.info("\u3010\u5b9a\u65f6\u5bf9\u6bd4\u8425\u9500\u4e91\u5e93\u5b58\u548c\u5e93\u5b58\u4e2d\u5fc3\u5e93\u5b58\u3011\u7ed3\u675f\uff0c\u7528\u65f6\uff1a{}", (Object)(startTime - endTime + "ms"));
        return true;
    }

    public void task(List<String> sourceNoList) {
        PageInfo pageInfo;
        logger.info("contrastInventoryPreemptEvent \u5bf9\u6bd4\u4e2d\u53f0\u9884\u5360\u4e0e\u4ea4\u6613\u8ba2\u5355\u72b6\u6001\u3001\u8fdb\u9500\u5b58\u9884\u5360\u6570\u91cf\u53ca\u72b6\u6001 \u5355\u53f7\u96c6\u5408\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(sourceNoList));
        Long startTime = System.currentTimeMillis();
        Date createTime = DateUtil.addDays((Date)new Date(), (int)-7);
        this.contrastInventoryPreemptService.deleteByCreateTime(createTime);
        Integer pageSize = 1000;
        Integer pageNum = 1;
        while (!Objects.isNull(pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inventoryReportQueryApi.queryPreemptSourceNo(pageNum, pageSize, sourceNoList))) && !CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            logger.info("contrastInventoryPreemptEvent \u67e5\u8be2\u5f53\u524d\u9884\u5360\u4fe1\u606f\u5217\u8868\u6761\u6570\uff1a{}", (Object)pageInfo.getSize());
            Map preemptMap = pageInfo.getList().stream().collect(Collectors.toMap(PreemptSourceNoRespDto::getSourceNo, Function.identity(), (k1, k2) -> k1));
            ArrayList<String> preemptSourceNos = new ArrayList<String>(preemptMap.keySet());
            List orderAndStatusRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.orderReportQueryApi.queryByOrderNos(preemptSourceNos));
            logger.info("contrastInventoryPreemptEvent \u6839\u636e\u9884\u5360\u8868\u6709\u6548\u7684\u8ba2\u5355\u53f7\u67e5\u8be2\u4ea4\u6613\u4e2d\u5fc3\u8ba2\u5355\u4fe1\u606f\u96c6\u5408\uff1a{}", (Object)JSON.toJSONString((Object)orderAndStatusRespDtos));
            ArrayList<ContrastInventoryPreemptEo> contrastInventoryPreemptEos = new ArrayList<ContrastInventoryPreemptEo>();
            ArrayList<String> orderNos = new ArrayList<String>();
            if (CollectionUtils.isNotEmpty((Collection)orderAndStatusRespDtos)) {
                for (OrderAndStatusRespDto respDto : orderAndStatusRespDtos) {
                    boolean differenceState;
                    boolean bl = differenceState = OrderTradeStatusEnum.ALL_DELIVERY.getCode().equals(respDto.getOrderTradeStatus()) || OrderTradeStatusEnum.CANCEL.getCode().equals(respDto.getOrderTradeStatus()) || OrderTradeStatusEnum.CLOSE.getCode().equals(respDto.getOrderTradeStatus()) || OrderTradeStatusEnum.CONFIRM.getCode().equals(respDto.getOrderTradeStatus());
                    if (differenceState && Objects.nonNull(preemptMap.get(respDto.getOrderNo()))) {
                        PreemptSourceNoRespDto preemptSourceNoRespDto = (PreemptSourceNoRespDto)preemptMap.get(respDto.getOrderNo());
                        ContrastInventoryPreemptEo eo = new ContrastInventoryPreemptEo();
                        eo.setSourceNo(preemptSourceNoRespDto.getSourceNo());
                        eo.setPreemptCreateTime(preemptSourceNoRespDto.getPreemptCreateTime());
                        eo.setPreemptUpdateTime(preemptSourceNoRespDto.getPreemptUpdateTime());
                        eo.setContrastType(ContrastInventoryPreemptTypeEnum.SMALL_B_MALL.getCode());
                        eo.setRemark("\u8ba2\u5355\u4ea4\u6613\u72b6\u6001\uff1a" + respDto.getOrderTradeStatus() + " " + OrderTradeStatusEnum.toName(respDto.getOrderTradeStatus()));
                        contrastInventoryPreemptEos.add(eo);
                    }
                    orderNos.add(respDto.getOrderNo());
                }
            }
            ArrayList<String> numberList = CollectionUtils.isEmpty((Collection)orderAndStatusRespDtos) ? preemptSourceNos : preemptSourceNos.stream().filter(e -> !orderNos.contains(e)).collect(Collectors.toList());
            logger.info("contrastInventoryPreemptEvent \u9700\u67e5\u8be2\u8fdb\u9500\u5b58\u7684\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString(numberList));
            if (CollectionUtils.isNotEmpty(numberList)) {
                List<YxyInventoryVo> jxcInventoryVoList = this.dataDistributeService.queryOccupyInventoryByNumberList(numberList);
                HashSet jxcOrderNo = CollectionUtils.isEmpty(jxcInventoryVoList) ? new HashSet() : jxcInventoryVoList.stream().map(e -> e.getNumber()).collect(Collectors.toSet());
                for (String orderNo : numberList) {
                    if (jxcOrderNo.contains(orderNo) || Objects.isNull(preemptMap.get(orderNo))) continue;
                    PreemptSourceNoRespDto preemptSourceNoRespDto = (PreemptSourceNoRespDto)preemptMap.get(orderNo);
                    ContrastInventoryPreemptEo eo = new ContrastInventoryPreemptEo();
                    eo.setSourceNo(preemptSourceNoRespDto.getSourceNo());
                    eo.setPreemptCreateTime(preemptSourceNoRespDto.getPreemptCreateTime());
                    eo.setPreemptUpdateTime(preemptSourceNoRespDto.getPreemptUpdateTime());
                    eo.setContrastType(ContrastInventoryPreemptTypeEnum.NONE.getCode());
                    eo.setRemark("\u8fdb\u9500\u5b58\u5df2\u91ca\u653e\u9884\u5360");
                    contrastInventoryPreemptEos.add(eo);
                }
            }
            if (CollectionUtils.isNotEmpty(contrastInventoryPreemptEos)) {
                this.contrastInventoryPreemptService.addList(contrastInventoryPreemptEos);
                logger.info("contrastInventoryPreemptEvent \u63d2\u5165\u5dee\u5f02\u5bf9\u6bd4\u8868\u6570\u636e{}\u6761", (Object)contrastInventoryPreemptEos.size());
            }
            if (pageInfo.getSize() < pageSize) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
        logger.info("contrastInventoryPreemptEvent \u5bf9\u6bd4\u4e2d\u53f0\u9884\u5360\u4e0e\u4ea4\u6613\u8ba2\u5355\u72b6\u6001\u3001\u8fdb\u9500\u5b58\u9884\u5360\u6570\u91cf\u53ca\u72b6\u6001 \u5355\u53f7\u96c6\u5408\u7ed3\u675f\uff0c\u7528\u65f6\uff1a{}\u6beb\u79d2", (Object)(System.currentTimeMillis() - startTime));
    }

    public void after(TaskMsg taskMsg) {
    }
}

