/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.tcbj.app.open.biz.scheduler;

import com.dtyunxi.tcbj.app.open.biz.store.IStoreService;
import com.dtyunxi.tcbj.center.openapi.api.dto.request.store.StorePageReqDto;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yx.tcbj.center.customer.api.IStoreApi;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="SyncStoreEvent")
@Scope(value="prototype")
public class SyncStoreEvent
extends SingleTupleScheduleEvent {
    private static final Logger logger = LoggerFactory.getLogger(SyncStoreEvent.class);
    @Resource
    private IStoreService storeService;
    @Resource
    private IStoreApi storeApi;

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        logger.info("\u5b9a\u65f6\u540c\u6b65\u8d62\u9500\u901a\u836f\u5e97\u4fe1\u606f\u6570\u636e\u8c03\u5ea6\u4efb\u52a1");
        this.doSyncStore();
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }

    private void doSyncStore() {
        SimpleDateFormat dataFormat = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Date nowDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        logger.info("\u67e5\u8be2\u66f4\u65b0\u8bbf\u95ee\uff1a{} \u81f3 {}", (Object)dataFormat.format(calendar.getTime()), (Object)dataFormat.format(nowDate));
        StorePageReqDto reqDto = new StorePageReqDto();
        reqDto.setStartUpdateTime(dataFormat.format(calendar.getTime()));
        reqDto.setEndUpdateTime(dataFormat.format(nowDate));
        List<StoreReqDto> storeReqDtoList = this.storeService.queryStoreAndDetail(reqDto);
        if (CollectionUtils.isEmpty(storeReqDtoList)) {
            logger.info("\u6682\u65e0\u66f4\u65b0\u6570\u636e");
            return;
        }
        this.storeApi.syncStore(storeReqDtoList);
        logger.info("\u66f4\u65b0\u5b8c\u6bd5\uff0c\u603b\u8ba1\uff1a{}", (Object)storeReqDtoList.size());
    }
}

